/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.messageanalyzer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.soda.devicekit.generator.model.elements.CommandElement;
import org.eclipse.soda.devicekit.generator.model.elements.CommandsElement;
import org.eclipse.soda.devicekit.generator.model.elements.ControlItem;
import org.eclipse.soda.devicekit.generator.model.elements.FilterElement;
import org.eclipse.soda.devicekit.generator.model.elements.MessageClassItem;
import org.eclipse.soda.devicekit.generator.model.elements.MessageElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagCollection;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;

public class FilterComputer {
    private byte[] fAnd;
    private byte[] fMegaFilter;
    private byte[] fOr;
    private byte[] fXor;
    private byte[] fComplement;
    private byte[] fPattern;
    private byte[] fMask;
    private boolean includeCommands;
    private List fFilters;
    private List fMessages;
    private List fMessageBytes;
    private TagCollection fCollection;
    protected List list = new ArrayList();

    public FilterComputer(TagCollection collection, List list) {
        this(collection, list, true);
    }

    public FilterComputer(TagCollection collection, List list, boolean includeCommands) {
        this.fCollection = collection;
        this.list = list;
        this.includeCommands = includeCommands;
        this.fMessageBytes = new ArrayList();
        this.fMessages = new ArrayList();
    }

    byte[] andBytes(List bytes) {
        if (bytes.size() == 0) {
            return null;
        }
        if (bytes.size() == 1) {
            return (byte[])bytes.get(0);
        }
        byte[] result = (byte[])bytes.get(0);
        int i = 1;
        while (i < bytes.size()) {
            byte[] curr = (byte[])bytes.get(i);
            result = DeviceKitUtilities.andMask(result, curr);
            ++i;
        }
        return result;
    }

    int clean(byte[] array) {
        if (array == null) {
            return 0;
        }
        int count = 0;
        int i = array.length - 1;
        while (i >= 0) {
            if (array[i] == 0) {
                ++count;
            } else {
                return count;
            }
            --i;
        }
        return count;
    }

    public void compute() {
        this.setup();
        this.fAnd = this.computeAndMessages();
        this.fOr = this.computeOrMessages();
        this.fXor = DeviceKitUtilities.xorMask(this.fAnd, this.fOr);
        this.fComplement = DeviceKitUtilities.complement(this.fXor);
        if (this.fMegaFilter != null && this.fMegaFilter.length < this.fAnd.length) {
            this.fMegaFilter = DeviceKitUtilities.growByteArray(this.fMegaFilter, this.fAnd.length, (byte)0);
        }
        this.fPattern = DeviceKitUtilities.andMask(this.fMegaFilter, this.fAnd);
        this.fMask = DeviceKitUtilities.andMask(this.fMegaFilter, this.fComplement);
        int trailingZeroes = this.clean(this.fMask);
        if (trailingZeroes > 0) {
            if (this.fMask.length - trailingZeroes > 0) {
                byte[] newMask = new byte[this.fMask.length - trailingZeroes];
                System.arraycopy(this.fMask, 0, newMask, 0, newMask.length);
                this.fMask = newMask;
            } else {
                this.fMask = null;
            }
            if (this.fPattern.length - trailingZeroes > 0) {
                byte[] newPattern = new byte[this.fPattern.length - trailingZeroes];
                System.arraycopy(this.fPattern, 0, newPattern, 0, newPattern.length);
                this.fPattern = newPattern;
            } else {
                this.fPattern = null;
            }
        }
    }

    byte[] computeAndMessages() {
        int maxLength = 0;
        int i = 0;
        while (i < this.fMessages.size()) {
            MessageClassItem me = (MessageClassItem)this.fMessages.get(i);
            if (me instanceof MessageElement) {
                byte[] curr = me.getBytes();
                if ((curr == null || curr.length == 0) && me.getTextData() != null) {
                    curr = me.getTextData().getBytes();
                }
                if (curr != null && curr.length > 0 && this.isUnique(curr, this.fMessageBytes)) {
                    this.fMessageBytes.add(curr);
                    if (curr.length > maxLength) {
                        maxLength = curr.length;
                    }
                }
            }
            ++i;
        }
        this.fMessageBytes = this.padBytes(maxLength, this.fMessageBytes);
        return this.andBytes(this.fMessageBytes);
    }

    byte[] computeOrMessages() {
        if (this.fMessageBytes == null) {
            return null;
        }
        return this.orBytes(this.fMessageBytes);
    }

    byte[] getDefaultFilter(byte[] bytes) {
        byte[] filter = new byte[bytes.length];
        int i = 0;
        while (i < filter.length) {
            filter[i] = -1;
            ++i;
        }
        return filter;
    }

    public byte[] getMask() {
        return this.fMask;
    }

    public byte[] getPattern() {
        return this.fPattern;
    }

    boolean isUnique(byte[] curr, List currList) {
        int i = 0;
        while (i < currList.size()) {
            byte[] currInList = (byte[])currList.get(i);
            if (currInList.length == curr.length) {
                boolean same = true;
                int j = 0;
                while (j < currInList.length) {
                    if (currInList[j] != curr[j]) {
                        same = false;
                    }
                    ++j;
                }
                if (same) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    byte[] orBytes(List bytes) {
        if (bytes.size() == 0) {
            return null;
        }
        if (bytes.size() == 1) {
            return (byte[])bytes.get(0);
        }
        byte[] result = (byte[])bytes.get(0);
        int i = 1;
        while (i < bytes.size()) {
            byte[] curr = (byte[])bytes.get(i);
            result = DeviceKitUtilities.orMask(result, curr);
            ++i;
        }
        return result;
    }

    List padBytes(int length, List byteList) {
        return this.padBytes(length, byteList, (byte)-1);
    }

    List padBytes(int length, List byteList, byte filler) {
        int i = 0;
        while (i < byteList.size()) {
            byte[] curr = (byte[])byteList.get(i);
            if (curr.length != length) {
                byteList.set(i, DeviceKitUtilities.growByteArray(curr, length, filler));
            }
            ++i;
        }
        return byteList;
    }

    void setup() {
        int maxLength = 0;
        ArrayList<byte[]> filters = new ArrayList<byte[]>();
        List ids = this.fCollection.getIds();
        int i = 0;
        while (i < ids.size()) {
            if (ids.get(i) instanceof ControlItem) {
                List messages;
                ControlItem ci = (ControlItem)ids.get(i);
                boolean include = true;
                if (ci instanceof CommandElement || ci instanceof CommandsElement) {
                    include = this.includeCommands;
                }
                if (include && (messages = ci.getMessageChildren()).size() > 0) {
                    String idref;
                    MessageClassItem me = (MessageClassItem)messages.get(0);
                    if (me.getAttribute("id") == null && (idref = me.getAttribute("idref")) != null) {
                        me = (MessageClassItem)this.fCollection.getMessage(idref);
                    }
                    if (me != null) {
                        this.fMessages.add(me);
                        List messageFilters = me.getAllChildrenWithTagCode(6);
                        byte[] currFilter = null;
                        if (messageFilters.size() > 0) {
                            String idref2;
                            FilterElement fe = (FilterElement)messageFilters.get(0);
                            if (fe.getAttribute("id") == null && (idref2 = fe.getAttribute("idref")) != null) {
                                fe = (FilterElement)this.fCollection.getFilter(idref2);
                            }
                            currFilter = fe.getBytes();
                        } else {
                            byte[] messBytes = me.getBytes();
                            if (messBytes == null && me.getTextDataFix() != null) {
                                messBytes = me.getTextDataFix().getBytes();
                            }
                            if (messBytes != null) {
                                currFilter = this.getDefaultFilter(messBytes);
                            }
                        }
                        if (currFilter != null && this.isUnique(currFilter, filters)) {
                            filters.add(currFilter);
                            if (currFilter.length > maxLength) {
                                maxLength = currFilter.length;
                            }
                        }
                    }
                }
            }
            ++i;
        }
        this.fFilters = this.padBytes(maxLength, filters, (byte)0);
        this.fMegaFilter = this.andBytes(this.fFilters);
    }
}

