/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.html;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.soda.devicekit.DeviceKitPlugin;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitTagConstants;
import org.eclipse.soda.devicekit.generator.html.HtmlGenerator;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.elements.ControlItem;
import org.eclipse.soda.devicekit.generator.model.elements.CustomParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.DataElement;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.MeasurementElement;
import org.eclipse.soda.devicekit.generator.model.elements.SpecElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TestAgentElement;
import org.eclipse.soda.devicekit.generator.model.elements.TestCaseElement;
import org.eclipse.soda.devicekit.generator.model.java.CodeUtilities;
import org.eclipse.soda.devicekit.generator.team.TeamUtilties;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.util.doc.DocChanges;
import org.eclipse.soda.devicekit.util.DkmlReferenceResolver;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExternalHtmlGenerator
extends HtmlGenerator
implements Comparator {
    protected TagElement element;
    protected MainTagElement elementOld;
    protected IFile dkmlFile;
    private String name;
    protected DeviceKitTagModel dkFileModel;
    protected DeviceKitTagModel dkFileModelOld;
    public HashMap links;
    protected String[] ids;
    private String changeHistory;
    protected HashMap baselineIds;
    protected Properties betterDataTypes;
    static /* synthetic */ Class class$0;

    public ExternalHtmlGenerator(File srcDir, String filename, String layerClass, String version) {
        block5: {
            this.name = "";
            this.dkFileModelOld = null;
            this.links = new HashMap();
            this.changeHistory = "";
            this.baselineIds = new HashMap();
            this.betterDataTypes = ExternalHtmlGenerator.loadBetterDataProperties();
            try {
                this.setLayerClass(layerClass);
                IFile file = TeamUtilties.getIFile(srcDir, filename);
                if (file == null) break block5;
                InputStream fileOld = TeamUtilties.getBranchStream(srcDir, filename);
                String changeHistory = TeamUtilties.getFileVersionInformationHtml(srcDir, filename, version);
                this.setChangeHistory(changeHistory);
                String[] ids = TeamUtilties.getBranchStreamIds(srcDir, filename);
                this.setIds(ids);
                this.dkFileModel = new DeviceKitTagModel(file.getContents(true), this.getReferencedFiles(file), null);
                this.dkFileModel.build();
                this.element = this.dkFileModel.getMainElement();
                if (fileOld == null) break block5;
                try {
                    this.dkFileModelOld = new DeviceKitTagModel(fileOld, this.getReferencedFiles(file), null);
                    this.dkFileModelOld.build();
                    this.elementOld = this.dkFileModelOld.getMainElement();
                    if (this.elementOld != null) {
                        this.buildBaselineIds(this.elementOld);
                    }
                }
                catch (Exception exception) {
                    this.dkFileModelOld = null;
                }
            }
            catch (Exception exception) {
                System.out.println("Problem in file " + filename);
                exception.printStackTrace();
            }
        }
    }

    public ExternalHtmlGenerator(IFile file) {
        this.name = "";
        this.dkFileModelOld = null;
        this.links = new HashMap();
        this.changeHistory = "";
        this.baselineIds = new HashMap();
        this.betterDataTypes = ExternalHtmlGenerator.loadBetterDataProperties();
        try {
            this.dkFileModel = new DeviceKitTagModel(file.getContents(true), this.getReferencedFiles(file), null);
            this.dkFileModel.build();
            this.element = this.dkFileModel.getMainElement();
            this.dkFileModelOld = null;
            this.elementOld = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ExternalHtmlGenerator(TagElement element, DeviceKitTagModel dkFileModel, IFile dkmlFile) {
        this.name = "";
        this.dkFileModelOld = null;
        this.links = new HashMap();
        this.changeHistory = "";
        this.baselineIds = new HashMap();
        this.betterDataTypes = ExternalHtmlGenerator.loadBetterDataProperties();
        this.element = element;
        this.dkFileModel = dkFileModel;
        this.dkmlFile = dkmlFile;
        this.dkFileModelOld = null;
        this.elementOld = null;
    }

    protected static Properties loadBetterDataProperties() {
        Properties properties = new Properties();
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.soda.devicekit.generator.html.HtmlGenerator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            InputStream is = clazz.getResourceAsStream("betterdata.properties");
            properties.load(is);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return properties;
    }

    protected void addCommonVariables(MainTagElement element) {
        this.variables.put("feature", this.getFeature());
        this.variables.put("Name", element.getId());
        this.variables.put("provider", element.getProvider());
        this.variables.put("Provider", element.getProvider());
        this.variables.put("vendors", element.getVendors());
        this.variables.put("Vendors", element.getVendors());
        this.variables.put("vendor", element.getVendor());
        this.variables.put("Vendor", element.getVendor());
        this.variables.put("version", element.getVersion());
        this.variables.put("Version", element.getVersion());
        this.variables.put("year", Integer.toString(Calendar.getInstance().get(1)));
        this.variables.put("Year", Integer.toString(Calendar.getInstance().get(1)));
        this.variables.put("years", Integer.toString(Calendar.getInstance().get(1)));
        this.variables.put("Years", Integer.toString(Calendar.getInstance().get(1)));
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        StringBuffer buffer = new StringBuffer(64);
        buffer.append(year);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        buffer.append('-');
        if (month < 10) {
            buffer.append('0');
        }
        buffer.append(month);
        buffer.append('-');
        if (day < 10) {
            buffer.append('0');
        }
        buffer.append(day);
        this.variables.put("Date", buffer.toString());
        this.variables.put("date", buffer.toString());
        if (this.variables.get("EclipseVersion") == null) {
            this.variables.put("EclipseVersion", DeviceKitPlugin.getEclipseVersion());
        }
        if (this.elementOld == null) {
            this.variables.put("stylesheet", "newstylesheet.css");
        } else {
            this.variables.put("stylesheet", "stylesheet.css");
        }
        this.variables.put("layerClass", this.getLayerClass());
    }

    protected String betterDataType(String type) {
        String better = this.betterDataTypes.getProperty(type);
        if (better != null) {
            return better;
        }
        return type;
    }

    public void buildBaselineIds(Node node) {
        String value;
        Node idNode;
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && (idNode = attributes.getNamedItem("id")) != null && (value = idNode.getNodeValue()) != null) {
            this.baselineIds.put(value, node);
        }
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node child = childNodes.item(i);
            if (child != null) {
                this.buildBaselineIds(child);
            }
            ++i;
        }
    }

    public void buildBaselineIds(TagElement tagElement) {
        String id = tagElement.getIdRaw();
        if (id != null) {
            this.baselineIds.put(id, tagElement);
        }
        List childNodes = tagElement.getChildren();
        int i = 0;
        while (i < childNodes.size()) {
            TagElement child = (TagElement)childNodes.get(i);
            if (child != null) {
                this.buildBaselineIds(child);
            }
            ++i;
        }
    }

    public boolean generate(IProgressMonitor progressMonitor) {
        if (this.element instanceof MainTagElement) {
            IFolder folderExternal;
            IProject project = this.dkmlFile.getProject();
            IFolder folder = project.getFolder("doc");
            if (!folder.exists()) {
                try {
                    folder.create(true, true, progressMonitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if (!(folderExternal = folder.getFolder("external")).exists()) {
                try {
                    folderExternal.create(true, true, progressMonitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            String name = this.element.getId();
            this.getContents();
            IFile file = folderExternal.getFile(String.valueOf(name) + "External.html");
            this.save(file, this.getStringWriter(), progressMonitor);
        }
        return true;
    }

    protected void generateChild(TagElement element2, String baseName, String description, String operation, String type, String units) {
        this.println("\t<tr>");
        this.print("\t<td valign=\"top\">");
        this.print(baseName);
        this.print('/');
        this.print("<a href=\"#");
        this.print(operation);
        this.println("\">");
        this.print(operation);
        this.println("</a></td>");
        this.print("\t<td valign=\"top\"><code>");
        this.print(type);
        this.println("</code></td>");
        this.print("\t<td valign=\"top\">");
        this.print(units);
        this.println("</td>");
        this.println("\t</tr>");
    }

    public HashMap getBaselineIds() {
        return this.baselineIds;
    }

    public String getChangeHistory() {
        return this.changeHistory;
    }

    public String getContents() {
        if (this.element instanceof TestAgentElement) {
            return this.getContents_TestAgent();
        }
        if (this.element instanceof MainTagElement) {
            String mainDescription;
            String versionOld;
            String vendorsOld;
            String providerOld;
            MainTagElement mainElement = (MainTagElement)this.element;
            this.addCommonVariables(mainElement);
            this.template("external.txt");
            this.println("\t<table>");
            String provider = mainElement.getProvider();
            String string = providerOld = this.elementOld != null ? this.elementOld.getProvider() : null;
            if (provider != null && provider.length() > 0) {
                this.printKeyValueTableEntry("Provider", provider, providerOld);
            }
            String vendors = mainElement.getVendors();
            String string2 = vendorsOld = this.elementOld != null ? this.elementOld.getVendors() : null;
            if (vendors != null && vendors.length() > 0) {
                this.printKeyValueTableEntry("Vendors", vendors, vendorsOld);
            }
            String version = mainElement.getVersion();
            String string3 = versionOld = this.elementOld != null ? this.elementOld.getVersion() : null;
            if (version != null && version.length() > 0) {
                this.printKeyValueTableEntry("Version", version, versionOld);
            }
            this.println("\t</table>");
            List specs = mainElement.getAllChildrenWithTagCode(64);
            int count = 0;
            if (specs.size() > 0) {
                int i = 0;
                while (i < specs.size()) {
                    SpecElement se = (SpecElement)specs.get(i);
                    String title = se.getSpecTitle();
                    if (title != null) {
                        String url;
                        if (count == 0) {
                            this.println("<table>");
                        }
                        if ((url = se.getSpecUrl()) != null) {
                            StringBuffer buffer = new StringBuffer(128);
                            buffer.append("<a href=\"");
                            buffer.append(url);
                            buffer.append("\">");
                            buffer.append(title);
                            buffer.append("</a>");
                            this.printKeyValueTableEntry("Specification title", buffer.toString());
                            buffer = new StringBuffer(128);
                            buffer.append("<a href=\"");
                            buffer.append(url);
                            buffer.append("\">");
                            buffer.append(url);
                            buffer.append("</a>");
                            this.printKeyValueTableEntry("Specification URL", buffer.toString());
                        } else {
                            this.printKeyValueTableEntry("Specification title", title);
                        }
                        if (se.getSpecVersion() != null) {
                            this.printKeyValueTableEntry("Specification version", se.getSpecVersion());
                        }
                        if (se.getSpecDate() != null) {
                            this.printKeyValueTableEntry("Specification data", se.getSpecDate());
                        }
                        if (se.getSpecVendor() != null) {
                            this.printKeyValueTableEntry("Specification vendor", se.getSpecVendor());
                        }
                        if (se.getSpecComment() != null) {
                            this.printKeyValueTableEntry("Specification comment", se.getSpecComment());
                        }
                        ++count;
                    }
                    ++i;
                }
                if (count > 0) {
                    this.println("</table>");
                }
            }
            String name = this.element.getId();
            this.setName(name);
            List list = this.getControlElements(mainElement);
            int size = list.size();
            if (size > 0) {
                ControlItem[] elements = new ControlItem[list.size()];
                elements = list.toArray(elements);
                int i = 0;
                while (i < elements.length) {
                    ControlItem element = elements[i];
                    String externalId = element.getExternalId();
                    if (externalId != null) {
                        this.links.put(externalId, externalId);
                        this.links.put(element.getId(), externalId);
                        List dlist = this.getDataElements(element);
                        if (dlist.size() > 0) {
                            DataElement[] delements = new DataElement[dlist.size()];
                            delements = dlist.toArray(delements);
                            int j = 0;
                            while (j < delements.length) {
                                DataElement dataElement = delements[j];
                                String dexternalId = dataElement.getExternalId();
                                if (dexternalId != null) {
                                    this.links.put(dexternalId, dexternalId);
                                    this.links.put(dataElement.getId(), dexternalId);
                                }
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
            }
            if ((mainDescription = mainElement.getDescription()) != null) {
                this.println("<p>");
                String oldDescription = null;
                if (this.elementOld != null) {
                    oldDescription = this.elementOld.getDescription();
                }
                if (oldDescription == null) {
                    this.printDescription(mainDescription);
                } else {
                    this.printDescription(mainDescription, oldDescription);
                }
                this.println("</p>");
            }
            if (size > 0) {
                ControlItem element;
                ControlItem[] elements = new ControlItem[list.size()];
                elements = list.toArray(elements);
                Arrays.sort(elements, this);
                int i = 0;
                while (i < elements.length) {
                    String units;
                    element = elements[i];
                    this.print("\t<h4><a name=\"");
                    this.print(element.getExternalId());
                    this.print("\">");
                    boolean flagIns = false;
                    String id = element.getAnyId();
                    String oldDescription = null;
                    if (id != null && id.length() > 0 && this.dkFileModelOld != null) {
                        TagElement oldTagElement = (TagElement)this.getBaselineIds().get(id);
                        if (oldTagElement == null) {
                            flagIns = true;
                        } else {
                            oldDescription = oldTagElement.getDescription();
                        }
                    }
                    if (flagIns) {
                        this.print(this.getNewIcon());
                        this.print("<ins>");
                        this.print(CodeUtilities.betterName(element.getId(), true));
                        this.print("</ins>");
                    } else {
                        this.print(CodeUtilities.betterName(element.getId(), true));
                    }
                    this.print(" (");
                    this.print(element.getExternalId());
                    this.print(")</a>");
                    String typeDocumentation = element.getParameterDataTypeDocumentation();
                    if (typeDocumentation != null && typeDocumentation.length() > 0) {
                        this.print(" <code>");
                        this.print(typeDocumentation);
                        this.print("</code>");
                    }
                    if ((units = element.getUnits()) != null && units.length() > 0) {
                        this.print(" ");
                        this.print(units);
                    }
                    this.print("</h4>");
                    this.println("\t<p>");
                    String description = element.getDescription();
                    if (description == null) {
                        description = "";
                    }
                    if (flagIns) {
                        this.print("<ins>");
                        this.printDescription(description);
                        this.print("</ins>");
                    } else if (oldDescription == null) {
                        this.printDescription(description);
                    } else {
                        this.printDescription(description, oldDescription);
                    }
                    String details = element.getFieldExtraComment(element.getAnyId());
                    this.println(details);
                    this.println("\t</p>");
                    List dlist = this.getDataElements(element);
                    if (dlist.size() > 0) {
                        DataElement[] delements = new DataElement[dlist.size()];
                        delements = dlist.toArray(delements);
                        Arrays.sort(delements, this);
                        this.println("\t<table width=\"100%\">");
                        int j = 0;
                        while (j < delements.length) {
                            DataElement dataElement = delements[j];
                            String externalId = dataElement.getExternalId();
                            if (externalId != null) {
                                Object oldId;
                                this.println("\t<tr>");
                                this.print("\t<td valign=\"top\"><b>");
                                String dexternalId = dataElement.getExternalId();
                                flagIns = false;
                                id = dataElement.getAnyId();
                                if (id != null && id.length() > 0 && this.dkFileModelOld != null && (oldId = this.getBaselineIds().get(id)) == null) {
                                    flagIns = true;
                                }
                                if (flagIns) {
                                    this.print(this.getNewIcon());
                                }
                                this.print("<a href=\"#");
                                this.print(dexternalId);
                                this.print("\">");
                                if (flagIns) {
                                    this.print("<ins>");
                                    this.print(dexternalId);
                                    this.print("</ins>");
                                } else {
                                    this.print(dexternalId);
                                }
                                this.print("</a>");
                                this.println("</b></td>");
                                this.print("<td>");
                                String dataDescription = dataElement.getDescription();
                                if (dataDescription == null) {
                                    dataDescription = "";
                                }
                                this.printDescription(dataDescription);
                                this.println("</td>");
                                this.println("\t</tr>");
                            }
                            ++j;
                        }
                        this.println("\t</table>");
                    }
                    ++i;
                }
                if (elements.length > 0) {
                    this.template("table.txt");
                    i = 0;
                    while (i < elements.length) {
                        String units;
                        Object oldId;
                        Object oldId2;
                        element = elements[i];
                        StringBuffer baseName = new StringBuffer(1024);
                        boolean flagIns = false;
                        String id = element.getAnyId();
                        if (id != null && id.length() > 0 && this.dkFileModelOld != null && (oldId2 = this.getBaselineIds().get(id)) == null) {
                            flagIns = true;
                        }
                        baseName.append("<i><a href=\"#prefix\">prefix</a>/</i><b>");
                        baseName.append("<a href=\"#");
                        baseName.append(element.getExternalId());
                        baseName.append("\">");
                        String externalId = element.getExternalId();
                        if (flagIns) {
                            baseName.append("<ins>");
                            baseName.append(externalId);
                            baseName.append("</ins>");
                        } else {
                            baseName.append(externalId);
                        }
                        baseName.append("</a></b>");
                        int rowspan = 3;
                        String ctype = element.getParameterDataType();
                        if (element instanceof MeasurementElement) {
                            MeasurementElement measurementElement = (MeasurementElement)element;
                            if (measurementElement.isExecuteRead()) {
                                ++rowspan;
                            }
                            if (measurementElement.isExecuteWrite()) {
                                ++rowspan;
                            }
                        }
                        this.print("\t<tr><td colspan=\"3\"><b>");
                        flagIns = false;
                        id = element.getAnyId();
                        if (id != null && id.length() > 0 && this.dkFileModelOld != null && (oldId = this.getBaselineIds().get(id)) == null) {
                            flagIns = true;
                        }
                        if (flagIns) {
                            this.print(this.getNewIcon());
                            this.print("<ins>");
                            this.print(CodeUtilities.betterName(element.getId(), true));
                            this.print("</ins>");
                        } else {
                            this.print(CodeUtilities.betterName(element.getId(), true));
                        }
                        this.println("</b>");
                        String typeDocumentation = element.getParameterDataTypeDocumentation();
                        if (typeDocumentation != null && typeDocumentation.length() > 0) {
                            this.print(" <code>");
                            this.print(typeDocumentation);
                            this.print("</code>");
                        }
                        this.println("</td>");
                        this.print("\t<td valign=\"top\" rowspan=\"");
                        this.print(String.valueOf(rowspan));
                        this.print("\">");
                        String description = element.getDescription();
                        if (description == null) {
                            description = "";
                        }
                        if ((units = element.getUnits()) == null) {
                            units = "";
                        }
                        this.printDescription(description);
                        this.println("</td></tr>");
                        this.println("\t<tr>");
                        this.print("\t<td valign=\"top\">");
                        this.print(baseName.toString());
                        this.println("</td>");
                        this.print("\t<td valign=\"top\"><code>");
                        if (ctype == null) {
                            ctype = "";
                        }
                        this.print(ctype);
                        this.println("</code></td>");
                        this.print("\t<td valign=\"top\">");
                        this.print(units);
                        this.println("</td>");
                        this.println("\t<td/>");
                        this.println("\t</tr>");
                        int type = element.getTagCode();
                        switch (type) {
                            case 1: 
                            case 19: {
                                this.generateChild(element, baseName.toString(), description, "execute", ctype, units);
                                break;
                            }
                            case 2: {
                                MeasurementElement measurementElement = (MeasurementElement)element;
                                this.generateChild(element, baseName.toString(), description, "get", "", "");
                                if (measurementElement.isExecuteRead()) {
                                    this.generateChild(element, baseName.toString(), description, "read", "", "");
                                }
                                if (!measurementElement.isExecuteWrite()) break;
                                this.generateChild(element, baseName.toString(), description, "write", ctype, units);
                                break;
                            }
                            case 3: {
                                this.generateChild(element, baseName.toString(), description, "trigger", ctype, units);
                            }
                        }
                        if (element.isError()) {
                            this.generateChild(element, baseName.toString(), description, "error", "", "");
                        }
                        ++i;
                    }
                    this.println("\t</table>");
                }
                this.outputDataElements(mainElement);
                if (elements.length > 0) {
                    this.template("topickeys.txt");
                }
                this.outputConfigurationParameters(mainElement);
            }
            this.println(this.changeHistory);
            this.template("end.txt");
            return this.getStringWriter().getBuffer().toString();
        }
        return null;
    }

    public String getContents_TestAgent() {
        TestAgentElement testAgentElement = (TestAgentElement)this.element;
        this.addCommonVariables(testAgentElement);
        String name = testAgentElement.getId();
        String basePackage = testAgentElement.getPackageBase();
        String baseProject = DeviceKitUtilities.getPackageFromClassName(name, basePackage);
        this.setName(name);
        String mainName = name;
        if (name != null && name.endsWith("TestAgent")) {
            mainName = name.substring(0, name.length() - "TestAgent".length());
        }
        this.variables.put("Name", mainName);
        this.template("external_testagent.txt");
        String mainDescription = testAgentElement.getDescription();
        if (mainDescription != null) {
            this.println("<p>");
            this.printDescription(mainDescription);
            this.println("</p>");
        }
        this.println("\t<br/>");
        this.println("\t<h4>Validation Test Agent Projects</h4>");
        this.template("table_testagent.txt");
        this.println("\t<tr>");
        this.println("\t<td valign=\"left\">Test Agent</td>");
        this.print("\t<td valign=\"left\">");
        this.print(baseProject);
        this.println("</td>");
        this.println("\t</tr>");
        if (testAgentElement.isBundle()) {
            this.println("\t<tr>");
            this.println("\t<td valign=\"left\">Bundle activator</td>");
            this.print("\t<td valign=\"left\">");
            this.print(baseProject);
            this.println(".bundle</td>");
            this.println("\t</tr>");
        }
        if (testAgentElement.isManagedFactoryBundle()) {
            this.println("\t<tr>");
            this.println("\t<td valign=\"left\">Factory activator</td>");
            this.print("\t<td valign=\"left\">");
            this.print(baseProject);
            this.println(".factory</td>");
            this.println("\t</tr>");
        }
        if (testAgentElement.isManagedFactoryBundle()) {
            this.println("\t<tr>");
            this.println("\t<td valign=\"left\">Managed activator</td>");
            this.print("\t<td valign=\"left\">");
            this.print(baseProject);
            this.println(".managed</td>");
            this.println("\t</tr>");
        }
        this.println("\t</table>");
        List testCases = testAgentElement.getAllChildrenWithTagCode(71);
        this.println("\t<br/>");
        this.println("\t<h4>Test Cases</h4>");
        this.template("table_testcase.txt");
        int i = 0;
        while (i < testCases.size()) {
            TestCaseElement testCase = (TestCaseElement)testCases.get(i);
            String id = testCase.getId();
            String description = testCase.getDescription();
            this.println("\t<tr>");
            this.print("\t<td valign=\"left\">");
            this.print(id);
            this.println("</td>");
            this.print("\t<td valign=\"left\">");
            this.print(description);
            this.println("</td>");
            this.println("\t</tr>");
            ++i;
        }
        this.println("\t</table>");
        this.println("\t<br/>");
        this.template("end.txt");
        return this.getStringWriter().getBuffer().toString();
    }

    protected List getControlElements(TagElement mainElement) {
        ArrayList<TagElement> results = new ArrayList<TagElement>();
        List elements = mainElement.getAllChildrenWithTagCodes(new int[]{1, 19, 2, 3, 4}, false);
        int i = 0;
        while (i < elements.size()) {
            TagElement element = (TagElement)elements.get(i);
            String id = element.getId();
            if (id != null && id.length() > 0 && (element.getTagCode() == 1 || element.getTagCode() == 19 || element.getTagCode() == 2 || element.getTagCode() == 3 || element.getTagCode() == 4 && !element.isMessageClassElement())) {
                results.add(element);
            }
            ++i;
        }
        return results;
    }

    protected List getCustomParameterElements(TagElement mainElement) {
        ArrayList<TagElement> results = new ArrayList<TagElement>();
        List elements = mainElement.getAllChildrenWithTagCodes(new int[]{46}, false);
        int i = 0;
        while (i < elements.size()) {
            TagElement element = (TagElement)elements.get(i);
            results.add(element);
            ++i;
        }
        return results;
    }

    protected List getDataElements(TagElement mainElement) {
        List elements = mainElement.getAllChildrenWithTagCodes(new int[]{76}, DeviceKitTagConstants.ALL_PARENT_CONTROLS_PLUS_DATA);
        return elements;
    }

    public IFile getDkmlFile() {
        return this.dkmlFile;
    }

    public TagElement getElement() {
        return this.element;
    }

    public String[] getIds() {
        return this.ids;
    }

    public String getName() {
        return this.name;
    }

    public String getNewIcon() {
        return "<img src=\"../icons/new.gif\" alt=\"New\"/>&nbsp;";
    }

    private List getReferencedFiles(IFile file) throws Exception {
        DkmlReferenceResolver resolver = new DkmlReferenceResolver(file);
        return resolver.getReferences();
    }

    public void outputConfigurationParameters(TagElement mainElement) {
        List customParameterList = this.getCustomParameterElements(mainElement);
        if (customParameterList.size() > 0) {
            this.println("\t<br/>");
            this.template("ctable.txt");
            CustomParameterElement[] customParameters = new CustomParameterElement[customParameterList.size()];
            customParameters = customParameterList.toArray(customParameters);
            Arrays.sort(customParameters, this);
            int i = 0;
            while (i < customParameters.length) {
                CustomParameterElement element = customParameters[i];
                String externalId = element.getAttribute("name");
                if (externalId != null) {
                    Object oldId;
                    this.println("\t<tr>");
                    this.print("\t<td valign=\"top\"><b>");
                    this.print("<a name=\"");
                    this.print(externalId);
                    this.print("\">");
                    boolean flagIns = false;
                    String id = element.getAnyId();
                    if (id != null && id.length() > 0 && this.dkFileModelOld != null && (oldId = this.getBaselineIds().get(id)) == null) {
                        flagIns = true;
                    }
                    if (flagIns) {
                        this.print(this.getNewIcon());
                        this.print("<ins>");
                        this.print(externalId);
                        this.print("</ins>");
                    } else {
                        this.print(externalId);
                    }
                    this.println("</a></b></td>");
                    String ctype = element.getValidMetaType();
                    if (ctype != null) {
                        this.print("<td valign=\"top\">");
                        this.print(ctype);
                        this.println("</td>");
                    } else {
                        this.println("<td/>");
                    }
                    String units = element.getUnits();
                    if (units != null) {
                        this.print("<td valign=\"top\">");
                        this.print(units);
                        this.println("</td>");
                    } else {
                        this.println("<td/>");
                    }
                    String defaultValue = element.getDefaultValue();
                    if (defaultValue != null) {
                        this.print("<td valign=\"top\">");
                        this.print(defaultValue);
                        this.println("</td>");
                    } else {
                        this.println("<td/>");
                    }
                    this.print("<td>");
                    String description = element.getDescription();
                    if (description == null) {
                        description = "";
                    }
                    this.printDescription(description);
                    String deprecated = element.getDeprecated();
                    if (deprecated != null && deprecated.length() > 0) {
                        this.println(" (");
                        this.printDescription(deprecated);
                        this.println(")");
                    }
                    this.println("</td>");
                    this.println("\t</tr>");
                }
                ++i;
            }
            this.println("\t</table>");
        }
    }

    protected void outputDataElements(MainTagElement mainElement) {
        List dlist = this.getDataElements(mainElement);
        int dsize = dlist.size();
        if (dsize > 0) {
            this.template("table.txt");
            DataElement[] delements = new DataElement[dlist.size()];
            delements = dlist.toArray(delements);
            Arrays.sort(delements, this);
            int i = 0;
            while (i < delements.length) {
                DataElement element = delements[i];
                String externalId = element.getExternalId();
                if (externalId != null) {
                    Object oldId;
                    this.println("\t<tr>");
                    this.print("\t<td valign=\"top\"><b>");
                    this.print("<a name=\"");
                    this.print(element.getExternalId());
                    this.print("\">");
                    boolean flagIns = false;
                    String id = element.getAnyId();
                    if (id != null && id.length() > 0 && this.dkFileModelOld != null && (oldId = this.getBaselineIds().get(id)) == null) {
                        flagIns = true;
                    }
                    if (flagIns) {
                        this.print(this.getNewIcon());
                        this.print("<ins>");
                        this.print(externalId);
                        this.print("</ins>");
                    } else {
                        this.print(externalId);
                    }
                    this.println("</a></b></td>");
                    String ctype = element.getAttribute("type");
                    this.print("<td valign=\"top\">");
                    if (ctype == null) {
                        ctype = "";
                    }
                    ctype = this.betterDataType(ctype);
                    this.print(ctype);
                    this.println("</td>");
                    String units = element.getUnits();
                    this.print("<td valign=\"top\">");
                    if (units == null) {
                        units = "";
                    }
                    this.print(units);
                    this.println("</td>");
                    this.print("<td>");
                    String description = element.getDescription();
                    if (description == null) {
                        description = "";
                    }
                    this.printDescription(description);
                    this.println("</td>");
                    this.println("\t</tr>");
                }
                ++i;
            }
            this.println("\t</table>");
            this.println("\t<br/>");
        }
    }

    public void printCommand(int style) {
        this.print("<font class=\"command\"><a href=\"#command\">C</a></font>&nbsp;");
    }

    public void printDescription(String string) {
        StringBuffer buffer = new StringBuffer(4096);
        StringTokenizer tokenizer = new StringTokenizer(string, " \r\n\"", true);
        String lastToken = "";
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (lastToken.equals("\"")) {
                Object value = this.links.get(token);
                if (value == null) {
                    buffer.append(token);
                } else {
                    buffer.append("<a href=\"#");
                    buffer.append(value.toString());
                    buffer.append("\">");
                    buffer.append(token);
                    buffer.append("</a>");
                }
            } else {
                buffer.append(token);
            }
            lastToken = token;
        }
        this.println(buffer.toString());
    }

    public void printDescription(String string, String oldString) {
        if (this.dkFileModelOld == null || oldString == null || string.equals(oldString)) {
            this.printDescription(string);
        } else {
            String markString = DocChanges.markChanges(string, oldString);
            StringBuffer buffer = new StringBuffer(4096);
            StringTokenizer tokenizer = new StringTokenizer(markString, " \r\n\"", true);
            String lastToken = "";
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (lastToken.equals("\"")) {
                    Object value = this.links.get(token);
                    if (value == null) {
                        buffer.append(token);
                    } else {
                        buffer.append("<a href=\"#");
                        buffer.append(value.toString());
                        buffer.append("\">");
                        buffer.append(token);
                        buffer.append("</a>");
                    }
                } else {
                    buffer.append(token);
                }
                lastToken = token;
            }
            this.println(buffer.toString());
        }
    }

    public void printKeyValueTableEntry(String key, String value) {
        this.println("\t<tr>");
        this.print("\t<td valign=\"top\">");
        this.print(key);
        this.println("\t</td>");
        this.print("\t<td valign=\"top\">");
        this.print(value);
        this.println("\t</td>");
        this.println("\t</tr>");
    }

    public void printKeyValueTableEntry(String key, String value, String valueOld) {
        this.println("\t<tr>");
        this.print("\t<td valign=\"top\">");
        if (this.elementOld == null) {
            this.print(key);
            this.println("\t</td>");
            this.print("\t<td valign=\"top\">");
            this.print(value);
        } else {
            if (valueOld != null) {
                this.print(key);
            } else {
                this.print(this.getNewIcon());
                this.print("<ins>");
                this.print(key);
                this.print("</ins>");
            }
            this.println("\t</td>");
            this.print("\t<td valign=\"top\">");
            if (valueOld != null) {
                if (value.equals(valueOld)) {
                    this.print(value);
                } else {
                    this.print("<em>");
                    this.print(value);
                    this.print("</em>");
                }
            } else {
                this.print("<ins>");
                this.print(value);
                this.print("</ins>");
            }
        }
        this.println("\t</td>");
        this.println("\t</tr>");
    }

    public void printListen(int style) {
        this.print("<font class=\"listen\"><a href=\"#listen\">L</a></font>&nbsp;");
    }

    public void printMeasurement(int style) {
        this.print("<font class=\"measurement\"><a href=\"#measurement\">M</a></font>&nbsp;");
    }

    public void printNotify(int style) {
        this.print("<font class=\"notify\"><a href=\"#notify\">N</a></font>&nbsp;");
    }

    public void printSignal(int style) {
        this.print("<font class=\"signal\"><a href=\"#signal\">S</a></font>&nbsp;");
    }

    public void setBaselineIds(HashMap baselineIds) {
        this.baselineIds = baselineIds;
    }

    public void setChangeHistory(String changeHistory) {
        this.changeHistory = changeHistory;
    }

    public void setDkmlFile(IFile dkmlFile) {
        this.dkmlFile = dkmlFile;
    }

    public void setElement(TagElement element) {
        this.element = element;
    }

    public void setIds(String[] ids) {
        this.ids = ids;
    }

    public void setName(String name) {
        this.name = name;
    }
}

