/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator;

import java.io.IOException;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.soda.devicekit.generator.templates.GeneratorContextType;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class GeneratorPlugin
extends Plugin {
    public static final String USE_ECLIPSE_32_NAMES_KEY = "org.eclipse.soda.devicekit.plugin.generator.use.eclipse32names";
    private static GeneratorPlugin plugin;
    private TemplateStore templateStore;
    private IPreferenceStore preferenceStore;
    private ContributionContextTypeRegistry contextTypeRegistry;

    public static GeneratorPlugin getDefault() {
        return plugin;
    }

    public static String getVersion() {
        Bundle bundle = GeneratorPlugin.getDefault().getBundle();
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        Version versionIdentifier = new Version(version);
        int major = versionIdentifier.getMajor();
        int minor = versionIdentifier.getMinor();
        int mirco = versionIdentifier.getMicro();
        int qc = versionIdentifier.getMicro();
        StringBuffer buffer = new StringBuffer(32);
        if (qc >= 99) {
            ++minor;
        }
        if (minor >= 99) {
            ++major;
            minor = 0;
            mirco = 0;
        }
        buffer.append(major);
        buffer.append('.');
        buffer.append(minor);
        buffer.append('.');
        buffer.append(mirco);
        return buffer.toString();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public GeneratorPlugin() {
        plugin = this;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.contextTypeRegistry == null) {
            this.contextTypeRegistry = new ContributionContextTypeRegistry();
            this.contextTypeRegistry.addContextType((TemplateContextType)new GeneratorContextType());
        }
        return this.contextTypeRegistry;
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), this.getBundle().getSymbolicName());
        }
        return this.preferenceStore;
    }

    public TemplateStore getTemplateStore() {
        if (this.templateStore == null) {
            this.templateStore = new ContributionTemplateStore(this.getPreferenceStore(), "org.eclipse.soda.devicekit.generator.templates.customtemplates");
            try {
                this.templateStore.load();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.templateStore;
    }

    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    public void setTemplateStore(TemplateStore templateStore) {
        this.templateStore = templateStore;
    }
}

