/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.metadata.processing;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.soda.devicekit.generator.metadata.DeviceKitMetaDataException;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.metadata.processing.MetaDataXmlParser;

public class MetaDataLoader {
    private IFile dkmlFile;

    public MetaDataLoader(IFile dkmlFile) {
        this.dkmlFile = dkmlFile;
    }

    public IFile getMetaDataFile() throws DeviceKitMetaDataException {
        if (this.dkmlFile == null || !this.dkmlFile.exists()) {
            throw new DeviceKitMetaDataException("There are some problems reading the meta data file");
        }
        IContainer parent = this.dkmlFile.getParent();
        return parent.getFile((IPath)new Path(".dkmetadata"));
    }

    public GeneratedInfo loadInformation() throws DeviceKitMetaDataException {
        IFile metaDataFile = this.getMetaDataFile();
        if (metaDataFile == null || !metaDataFile.exists()) {
            return null;
        }
        return this.loadInformation(metaDataFile);
    }

    private GeneratedInfo loadInformation(IFile metaDataFile) throws DeviceKitMetaDataException {
        try {
            MetaDataXmlParser parser = new MetaDataXmlParser(metaDataFile);
            GeneratedInfo info = parser.getGeneratedInfo();
            return info;
        }
        catch (CoreException coreException) {
            throw new DeviceKitMetaDataException("There are some problems reading the meta data file");
        }
    }
}

