/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.metadata.processing;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.soda.devicekit.generator.metadata.DeviceKitMetaDataException;
import org.eclipse.soda.devicekit.generator.metadata.MetaDataUtility;
import org.eclipse.soda.devicekit.generator.metadata.model.CustomInfo;
import org.eclipse.soda.devicekit.generator.metadata.model.CustomTypeInformation;
import org.eclipse.soda.devicekit.generator.metadata.model.FieldInformation;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.metadata.model.MethodInformation;
import org.eclipse.soda.devicekit.generator.metadata.model.TypeInformation;
import org.eclipse.soda.devicekit.generator.metadata.processing.MetaDataLoader;
import org.eclipse.soda.devicekit.generator.util.DeviceKitEclipseUtilities;

public class CustomElementLoader {
    private IJavaProject project;
    private IFile dkmlFile;
    private IFile metaDataFile;
    private GeneratedInfo generatedInfo;
    private CustomInfo customInfo;
    private CustomInfo existInfo;

    public CustomElementLoader(IJavaProject project, IFile dkmlFile) {
        this.project = project;
        this.dkmlFile = dkmlFile;
        this.customInfo = new CustomInfo();
        this.existInfo = new CustomInfo();
    }

    /*
     * Exception decompiling
     */
    protected void collectCustomManifest(String name, IFile manifestFile) throws CoreException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 111->115)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void collectCustomManifests() throws DeviceKitMetaDataException {
        try {
            IPackageFragmentRoot[] sourceFolders = this.getProject().getPackageFragmentRoots();
            int i = 0;
            while (i < sourceFolders.length) {
                IFile manifest;
                IFolder metaInf;
                IResource sourceFolderDir = sourceFolders[i].getResource();
                if (sourceFolderDir instanceof IFolder && (metaInf = ((IFolder)sourceFolderDir).getFolder("META-INF")) != null && metaInf.exists() && (manifest = metaInf.getFile("MANIFEST.MF")) != null && manifest.exists()) {
                    this.collectCustomManifest(sourceFolderDir.getName(), manifest);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            throw new DeviceKitMetaDataException(e.getMessage());
        }
        catch (CoreException e) {
            throw new DeviceKitMetaDataException(e.getMessage());
        }
        catch (IOException e) {
            throw new DeviceKitMetaDataException(e.getMessage());
        }
    }

    protected void collectCustomType(TypeInformation typeInfo) throws JavaModelException, DeviceKitMetaDataException {
        IType type;
        IJavaProject defaultProject;
        String packageName = typeInfo.getPackageName();
        String typeName = typeInfo.getTypeName();
        ICompilationUnit cu = null;
        String project = typeInfo.getProject();
        IJavaProject jProject = null;
        if (project != null) {
            jProject = this.getJavaProject(project);
        }
        if ((cu = this.getCompilationUnit(packageName, typeName, jProject, defaultProject = this.getProject())) != null && (type = cu.getType(typeName)) != null) {
            int i;
            CustomTypeInformation ti;
            MethodInformation[] allMethods = MetaDataUtility.getAllMethods(type);
            MethodInformation[] customMethods = MetaDataUtility.getCustomMethods(typeInfo, allMethods);
            FieldInformation[] allFields = MetaDataUtility.getAllFields(type);
            FieldInformation[] customFields = MetaDataUtility.getCustomFields(typeInfo, allFields);
            if (customFields.length > 0 || customMethods.length > 0) {
                ti = this.customInfo.addCustomTypeInformation(packageName, typeName);
                i = 0;
                while (i < customFields.length) {
                    ti.addFieldInformation(customFields[i].getKey(), customFields[i].getData(), "1.0.0");
                    ++i;
                }
                i = 0;
                while (i < customMethods.length) {
                    ti.addMethodInformation(customMethods[i].getKey(), customMethods[i].getData(), "1.0.0");
                    ++i;
                }
            }
            if (allFields.length > 0 || allMethods.length > 0) {
                ti = this.existInfo.addCustomTypeInformation(packageName, typeName);
                i = 0;
                while (i < allFields.length) {
                    ti.addFieldInformation(allFields[i].getKey(), allFields[i].getData(), "1.0.0");
                    ++i;
                }
                i = 0;
                while (i < allMethods.length) {
                    ti.addMethodInformation(allMethods[i].getKey(), allMethods[i].getData(), "1.0.0");
                    ++i;
                }
            }
        }
    }

    protected void collectCustomTypes() throws JavaModelException, DeviceKitMetaDataException {
        if (this.generatedInfo != null) {
            TypeInformation[] typeInfos = this.generatedInfo.getTypes();
            int i = 0;
            while (i < typeInfos.length) {
                this.collectCustomType(typeInfos[i]);
                ++i;
            }
        }
    }

    protected ICompilationUnit getCompilationUnit(String packageName, String className, IJavaProject project, IJavaProject defaultProject) {
        try {
            IPackageFragment packFrag = DeviceKitEclipseUtilities.getDkPackageFragment(project, defaultProject, packageName);
            if (packFrag != null) {
                StringBuffer buffer = new StringBuffer(className.length() + ".java".length());
                buffer.append(className);
                buffer.append(".java");
                return packFrag.getCompilationUnit(buffer.toString());
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public CustomInfo getExistInfo() {
        return this.existInfo;
    }

    public GeneratedInfo getGeneratedInfo() {
        return this.generatedInfo;
    }

    private IJavaProject getJavaProject(String projectName) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = ws.getRoot();
        IProject project = root.getProject(projectName);
        IJavaProject jProject = DeviceKitEclipseUtilities.getJavaProjectFromProject(project);
        return jProject;
    }

    public IFile getMetaDataFile() {
        return this.metaDataFile;
    }

    protected IJavaProject getProject() {
        return this.project;
    }

    public CustomInfo loadCustomInfo() throws JavaModelException {
        try {
            this.loadMetaData();
            this.collectCustomTypes();
            this.collectCustomManifests();
            return this.customInfo;
        }
        catch (DeviceKitMetaDataException deviceKitMetaDataException) {
            return new CustomInfo();
        }
    }

    protected void loadMetaData() throws DeviceKitMetaDataException {
        MetaDataLoader loader = new MetaDataLoader(this.dkmlFile);
        this.generatedInfo = loader.loadInformation();
        this.metaDataFile = loader.getMetaDataFile();
    }
}

