/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.metadata.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.soda.devicekit.generator.metadata.model.CustomManifestInformation;
import org.eclipse.soda.devicekit.generator.metadata.model.CustomTypeInformation;

public class CustomInfo {
    private List customManifests;
    private List customTypes = new ArrayList();

    public CustomInfo() {
        this.customManifests = new ArrayList();
    }

    public CustomManifestInformation addCustomManifestInformation(String bundleName) {
        CustomManifestInformation manifestInfo = new CustomManifestInformation(bundleName);
        this.customManifests.add(manifestInfo);
        return manifestInfo;
    }

    public CustomTypeInformation addCustomTypeInformation(String packageName, String typeName) {
        CustomTypeInformation typeInfo = new CustomTypeInformation(packageName, typeName);
        this.customTypes.add(typeInfo);
        return typeInfo;
    }

    public CustomManifestInformation getManifestInformation(String bundleName) {
        CustomManifestInformation[] manifests = this.getManifests();
        int i = 0;
        while (i < manifests.length) {
            CustomManifestInformation info = manifests[i];
            if (info.getKey().equals(bundleName)) {
                return info;
            }
            ++i;
        }
        return null;
    }

    public CustomManifestInformation[] getManifests() {
        CustomManifestInformation[] result = new CustomManifestInformation[this.customManifests.size()];
        this.customManifests.toArray(result);
        return result;
    }

    public CustomTypeInformation getTypeInformation(String packageName, String typeName) {
        CustomTypeInformation[] types = this.getTypes();
        int i = 0;
        while (i < types.length) {
            CustomTypeInformation info = types[i];
            if (info.getPackageName().equals(packageName) && info.getTypeName().equals(typeName)) {
                return info;
            }
            ++i;
        }
        return null;
    }

    public CustomTypeInformation[] getTypes() {
        CustomTypeInformation[] result = new CustomTypeInformation[this.customTypes.size()];
        this.customTypes.toArray(result);
        return result;
    }
}

