/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.manifest;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.soda.devicekit.DeviceKitPlugin;
import org.eclipse.soda.devicekit.generator.manifest.ManifestPrinter;
import org.eclipse.soda.devicekit.generator.model.IGeneratorModel;
import org.eclipse.soda.devicekit.generator.save.IFileSaver;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.osgi.framework.Version;

public class ManifestModel
implements IGeneratorModel {
    static final String[] SPECIAL_KEYS = new String[]{"Bundle-Category", "Bundle-Copyright", "Bundle-Description", "Bundle-Name"};
    private boolean isAbstract;
    private Map keys;
    private IFileSaver fSaver;
    protected Properties pluginProperties = new Properties();
    private Map exportedPackagesMap = new HashMap();
    private Map requiredBundle = new HashMap();
    private String vendors;
    private boolean singleton = false;

    public ManifestModel() {
        this.keys = new HashMap();
    }

    public ManifestModel(IFile file) {
        this.keys = new HashMap();
        try {
            FileInputStream fis = new FileInputStream(file.getRawLocation().toFile());
            BufferedInputStream is = new BufferedInputStream(fis, 4096);
            Manifest manifest = new Manifest(is);
            Attributes attributes = manifest.getMainAttributes();
            Iterator<Map.Entry<Object, Object>> iterator = attributes.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                String keyValue = key.toString();
                if (keyValue.equals("Manifest-Version")) continue;
                this.keys.put(keyValue, value);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addCategory(String category) {
        this.addKeyMultiValue("Bundle-Category", category);
    }

    public void addExportedPackage(String exportedPackage) {
        String texportedPackage = exportedPackage;
        if (!this.exportedPackagesMap.containsKey(texportedPackage)) {
            this.exportedPackagesMap.put(texportedPackage, texportedPackage);
            String version = this.getVersion();
            if (texportedPackage != null && version != null) {
                if (version.endsWith(".qualifier")) {
                    version = version.substring(0, version.length() - 10);
                }
                texportedPackage = String.valueOf(texportedPackage) + ";version=\"" + version + '\"';
            }
            this.addKeyMultiValue("Export-Package", texportedPackage);
        }
    }

    public void addExportedService(String exportedService) {
        this.addKeyMultiValue("Export-Service", exportedService);
    }

    public void addImportPackage(String importedPackage) {
        if (importedPackage.length() > 0 && !importedPackage.startsWith("java.")) {
            String last = DeviceKitUtilities.stripPackage(importedPackage);
            if (Character.isUpperCase(last.charAt(0))) {
                throw new RuntimeException(importedPackage);
            }
            if (this.exportedPackagesMap.get(importedPackage) == null) {
                String version = this.getExportPackageVersion(importedPackage);
                if (version != null && version.length() > 0) {
                    StringBuffer buffer = new StringBuffer(1024);
                    buffer.append(importedPackage);
                    buffer.append(";version=\"");
                    buffer.append(version);
                    buffer.append('\"');
                    this.addKeyMultiValue("Import-Package", buffer.toString());
                } else {
                    this.addKeyMultiValue("Import-Package", importedPackage);
                }
            }
        }
    }

    public void addImportService(String importedService) {
        this.addKeyMultiValue("Import-Service", importedService);
    }

    private void addKeyMultiValue(String key, String value) {
        if (value == null || value.trim().length() == 0) {
            return;
        }
        String[] currItems = this.getKeyMultiValue(key);
        if (currItems == null) {
            this.setKeyMultiValue(key, new String[]{value});
        } else {
            int i = 0;
            while (i < currItems.length) {
                if (currItems[i].equals(value)) {
                    return;
                }
                ++i;
            }
            String[] newValue = new String[currItems.length + 1];
            System.arraycopy(currItems, 0, newValue, 0, currItems.length);
            newValue[newValue.length - 1] = value;
            this.setKeyMultiValue(key, newValue);
        }
    }

    public void addRequiredBundle(String bundleId) {
        if (this.requiredBundle.get(bundleId) == null) {
            StringBuffer buffer = new StringBuffer(1024);
            buffer.append(bundleId);
            String version = this.getBundleVersion(bundleId);
            if (version != null && version.length() > 0) {
                buffer.append(";bundle-version=\"");
                buffer.append(version);
                buffer.append('\"');
            }
            buffer.append(";resolution:=optional");
            this.addKeyMultiValue("Require-Bundle", buffer.toString());
        }
    }

    public void addRequiredBundle(String bundleId, String options) {
        if (options != null && options.length() > 0) {
            if (this.requiredBundle.get(bundleId) == null) {
                String newOptions = options;
                StringBuffer buffer = new StringBuffer(128);
                boolean versionFound = false;
                StringTokenizer tokenizer = new StringTokenizer(options, ";");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (buffer.length() > 0) {
                        buffer.append(';');
                    }
                    if (token.startsWith("bundle-version")) {
                        String version = this.getBundleVersion(bundleId);
                        if (version == null || version.length() <= 0) continue;
                        buffer.append("bundle-version=\"");
                        buffer.append(version);
                        buffer.append('\"');
                        versionFound = true;
                        continue;
                    }
                    buffer.append(token);
                }
                newOptions = buffer.toString();
                if (!versionFound) {
                    buffer = new StringBuffer(128);
                    String version = this.getBundleVersion(bundleId);
                    if (version != null && version.length() > 0) {
                        buffer.append("bundle-version=\"");
                        buffer.append(version);
                        buffer.append('\"');
                        versionFound = true;
                        buffer.append(';');
                        buffer.append(newOptions);
                        newOptions = buffer.toString();
                    }
                }
                this.addKeyMultiValue("Require-Bundle", String.valueOf(bundleId) + ';' + newOptions);
            }
        } else {
            this.addKeyMultiValue("Require-Bundle", bundleId);
        }
    }

    public String getBundleActivator() {
        String[] result = this.getKeyValue("Bundle-Activator");
        if (result != null) {
            return result[0];
        }
        return null;
    }

    public String getBundleLocalization() {
        String[] result = this.getKeyValue("Bundle-Localization");
        if (result != null) {
            return result[0];
        }
        return null;
    }

    public String getBundleName() {
        String[] result = this.getKeyValue("Bundle-Name");
        if (result != null) {
            return result[0];
        }
        return null;
    }

    public String getServiceComponent() {
        String[] result = this.getKeyValue("Service-Component");
        if (result != null) {
            return result[0];
        }
        return null;
    }

    public String getBundleVersion(String symbolicName) {
        String bestVersion = "";
        State state = PDECore.getDefault().getModelManager().getState().getState();
        BundleDescription[] bundleDescriptions = state.getBundles(symbolicName);
        int i = 0;
        while (i < bundleDescriptions.length) {
            Version version = bundleDescriptions[i].getVersion();
            if (version != null) {
                StringBuffer buffer = new StringBuffer(32);
                buffer.append(version.getMajor());
                buffer.append('.');
                buffer.append(version.getMinor());
                buffer.append('.');
                buffer.append(version.getMicro());
                String newVersion = buffer.toString();
                if (bestVersion.equals("")) {
                    bestVersion = newVersion;
                } else if (bestVersion.compareTo(newVersion) > 0) {
                    bestVersion = newVersion;
                }
            }
            ++i;
        }
        return bestVersion;
    }

    public List getCategories() {
        return this.getKeyMultiValueAsList("Bundle-Category");
    }

    public String getContents() {
        return new ManifestPrinter(this).getContents();
    }

    public String getCopyright() {
        String[] result = this.getKeyValue("Bundle-Copyright");
        if (result != null) {
            return result[0];
        }
        return null;
    }

    public String getDescription() {
        String[] result = this.getKeyValue("Bundle-Description");
        if (result != null) {
            return result[0];
        }
        return null;
    }

    public String getExportPackageVersion(String packageName) {
        String bestVersion = "";
        State state = PDECore.getDefault().getModelManager().getState().getState();
        ExportPackageDescription[] exportPackages = state.getExportedPackages();
        int i = 0;
        while (i < exportPackages.length) {
            Version version;
            ExportPackageDescription exportPackage = exportPackages[i];
            if (packageName.equals(exportPackage.getName()) && (version = exportPackage.getVersion()) != null) {
                String newVersion = version.toString();
                if (bestVersion.equals("")) {
                    bestVersion = newVersion;
                } else if (bestVersion.compareTo(newVersion) > 0) {
                    bestVersion = newVersion;
                }
            }
            ++i;
        }
        return bestVersion;
    }

    public List getExportedPackages() {
        return this.getKeyMultiValueAsList("Export-Package");
    }

    public Map getExportedPackagesMap() {
        return this.exportedPackagesMap;
    }

    public List getExportedServices() {
        if (this.isAbstract) {
            return new ArrayList();
        }
        return this.getKeyMultiValueAsList("Export-Service");
    }

    public List getImportedPackages() {
        return this.getKeyMultiValueAsList("Import-Package");
    }

    public List getImportedServices() {
        return this.getKeyMultiValueAsList("Import-Service");
    }

    public String[] getKeyMultiValue(String key) {
        Object value = this.keys.get(key);
        if (value != null) {
            if (value instanceof String[]) {
                String[] castedValue = (String[])value;
                return castedValue;
            }
            StringTokenizer tokenizer = new StringTokenizer(value.toString(), ",");
            int count = tokenizer.countTokens();
            String[] tokens = new String[count];
            int i = 0;
            while (i < count) {
                tokens[i] = tokenizer.nextToken();
                ++i;
            }
            return tokens;
        }
        return null;
    }

    public List getKeyMultiValueAsList(String key) {
        ArrayList<String> vectorResult = new ArrayList<String>();
        String[] result = this.getKeyMultiValue(key);
        if (result == null) {
            return vectorResult;
        }
        int i = 0;
        while (i < result.length) {
            vectorResult.add(result[i]);
            ++i;
        }
        return vectorResult;
    }

    public String[] getKeyValue(String key) {
        Object o;
        if (key != null && (o = this.keys.get(key)) != null) {
            if (o instanceof String[]) {
                return this.getKeyMultiValue(key);
            }
            return new String[]{(String)o};
        }
        return null;
    }

    protected Map getKeys() {
        return this.keys;
    }

    public String[] getKeysArray() {
        Set set = this.keys.keySet();
        int size = set.size();
        Object[] list = new String[size];
        list = set.toArray(list);
        Arrays.sort(list);
        return list;
    }

    public Manifest getManifest() throws IOException {
        Manifest manifest;
        InputStream stream = null;
        try {
            String contents = this.getContents();
            stream = new ByteArrayInputStream(contents.getBytes());
            manifest = new Manifest(stream);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            stream.close();
            stream = null;
            throw throwable;
        }
        stream.close();
        stream = null;
        return manifest;
    }

    public Properties getPluginProperties() {
        this.pluginProperties.put("description", this.getDescription());
        this.pluginProperties.put("name", this.getBundleName());
        this.pluginProperties.put("copyright", this.getCopyright());
        return this.pluginProperties;
    }

    public Map getRequiredBundle() {
        return this.requiredBundle;
    }

    public String getRequiredExecutionEnvironments() {
        String[] result = this.getKeyValue("Bundle-RequiredExecutionEnvironment");
        if (result != null) {
            return result[0];
        }
        return null;
    }

    public String getSymbolicBundleName() {
        String[] result = this.getKeyValue("Bundle-SymbolicName");
        if (result != null) {
            String symbolicBundleName = result[0].trim();
            return symbolicBundleName;
        }
        return null;
    }

    public String getVendor() {
        String[] result = this.getKeyValue("Bundle-Vendor");
        if (result != null) {
            return result[0];
        }
        return null;
    }

    public String getVendors() {
        if (this.vendors != null) {
            return this.vendors;
        }
        return this.getVendor();
    }

    public String getVersion() {
        String[] result = this.getKeyValue("Bundle-Version");
        if (result != null) {
            return result[0];
        }
        return null;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public Object organize(IProgressMonitor progressMonitor) throws Exception {
        if (this.fSaver != null) {
            return this.fSaver.organize(this, progressMonitor);
        }
        return null;
    }

    public Object save(IProgressMonitor progressMonitor) throws Exception {
        if (this.fSaver != null && DeviceKitPlugin.getGenerateManifest()) {
            return this.fSaver.save(this, progressMonitor);
        }
        return null;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void setBundleActivator(String bundleActivator) {
        this.setKeyValue("Bundle-Activator", bundleActivator);
    }

    public void setBundleLocalization(String bndleLocalization) {
        this.setKeyValue("Bundle-Localization", bndleLocalization);
    }

    public void setBundleName(String bundleName) {
        this.setKeyValue("Bundle-Name", bundleName);
    }

    public void setServiceComponent(String serviceComponent) {
        this.setKeyValue("Service-Component", serviceComponent);
    }

    public void setBundleRequiredExecutionEnvironments(String executionEnvironments) {
        this.setKeyValue("Bundle-RequiredExecutionEnvironment", executionEnvironments);
    }

    public void setCopyright(String copyright) {
        this.setKeyValue("Bundle-Copyright", copyright);
    }

    public void setDescription(String description) {
        if (description == null) {
            this.setKeyValue("Bundle-Description", "");
        } else {
            int index = description.indexOf(46);
            if (index < 0) {
                this.setKeyValue("Bundle-Description", description);
            } else {
                this.setKeyValue("Bundle-Description", description.substring(0, index));
            }
        }
    }

    public void setExportedPackagesMap(Map exportedPackages) {
        this.exportedPackagesMap = exportedPackages;
    }

    private void setKeyMultiValue(String key, String[] value) {
        this.keys.put(key, value);
    }

    public void setKeyValue(String key, String value) {
        if (key != null && value != null) {
            if (key.equals("Bundle-SymbolicName")) {
                int index = value.indexOf(59);
                if (index < 0 && this.isSingleton()) {
                    this.keys.put(key, String.valueOf(value) + ";singleton:=true");
                } else if (index < 0) {
                    this.keys.put(key, value);
                } else {
                    this.setSingleton(true);
                    this.keys.put(key, value);
                }
            } else {
                this.keys.put(key, value);
            }
        }
    }

    public void setRequiredBundle(Map requiredBundle) {
        this.requiredBundle = requiredBundle;
    }

    public void setSaver(IFileSaver saver) {
        this.fSaver = saver;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public void setSymbolicBundleName(String symbolicBundleName) {
        int index = symbolicBundleName.indexOf(59);
        if (index < 0) {
            this.setKeyValue("Bundle-SymbolicName", symbolicBundleName);
        } else {
            this.setKeyValue("Bundle-SymbolicName", symbolicBundleName.substring(0, index));
        }
    }

    public void setVendor(String vendor) {
        this.setKeyValue("Bundle-Vendor", vendor);
    }

    public void setVendors(String vendors) {
        this.vendors = vendors;
    }

    public void setVersion(String version) {
        this.setKeyValue("Bundle-Version", version);
    }

    public boolean updateExportPackages(ManifestModel model) {
        String[] currentExports = this.getKeyMultiValue("Export-Package");
        String[] exports = model.getKeyMultiValue("Export-Package");
        if (exports != null) {
            this.keys.put("Export-Package", exports);
            this.setExportedPackagesMap(model.getExportedPackagesMap());
            if (currentExports != null) {
                int i = 0;
                while (i < currentExports.length) {
                    String currentExport = currentExports[i];
                    int index = currentExport.indexOf(59);
                    if (index < 0) {
                        this.addExportedPackage(currentExport);
                    } else {
                        String exportedPackage = currentExport.substring(0, index);
                        this.addExportedPackage(exportedPackage);
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public boolean updateImportPackages(ManifestModel model) {
        String[] currentImports = this.getKeyMultiValue("Import-Package");
        String[] imports = model.getKeyMultiValue("Import-Package");
        if (imports != null) {
            this.keys.put("Import-Package", imports);
            if (currentImports != null) {
                int i = 0;
                while (i < currentImports.length) {
                    String currentImport = currentImports[i];
                    int index = currentImport.indexOf(59);
                    if (index < 0) {
                        this.addImportPackage(currentImport);
                    } else {
                        String importedPackage = currentImport.substring(0, index);
                        this.addImportPackage(importedPackage);
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public boolean updateModel(ManifestModel model) {
        boolean changed = false;
        Iterator iterator = model.getKeys().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object myValue = this.keys.get(key);
            if (myValue == null) {
                this.keys.put(key, value);
                changed = true;
                continue;
            }
            boolean compareValues = value.equals(myValue);
            if (compareValues) continue;
            if ("Export-Package".equals(key)) {
                this.updateExportPackages(model);
                continue;
            }
            if ("Require-Bundle".equals(key)) {
                this.updateRequiredBundles(model);
                continue;
            }
            if ("Import-Package".equals(key)) {
                this.updateImportPackages(model);
                continue;
            }
            if (!"Bundle-Vendor".equals(key) && !"Bundle-SymbolicName".equals(key) && !"Bundle-Version".equals(key)) continue;
            this.keys.put(key, value);
            changed = true;
        }
        return changed;
    }

    public boolean updateRequiredBundles(ManifestModel model) {
        String[] currentRequiredBundles = this.getKeyMultiValue("Require-Bundle");
        String[] requiredBundles = model.getKeyMultiValue("Require-Bundle");
        if (requiredBundles != null) {
            this.keys.put("Require-Bundle", requiredBundles);
            this.setRequiredBundle(model.getRequiredBundle());
            if (currentRequiredBundles != null) {
                int i = 0;
                while (i < currentRequiredBundles.length) {
                    String currentRequiredBundle = currentRequiredBundles[i];
                    int index = currentRequiredBundle.indexOf(59);
                    if (index < 0) {
                        this.addRequiredBundle(currentRequiredBundle);
                    } else {
                        String requiredBundle = currentRequiredBundle.substring(0, index);
                        String options = currentRequiredBundle.substring(index + 1);
                        this.addRequiredBundle(requiredBundle, options);
                    }
                    ++i;
                }
            }
        }
        return false;
    }
}

