/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.ConfigurationModel;
import org.eclipse.soda.devicekit.generator.model.elements.ConfigurationField;
import org.eclipse.soda.devicekit.generator.model.elements.ConnectionItemElement;
import org.eclipse.soda.devicekit.generator.model.elements.IConnectionItem;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class RandomAccessFileElement
extends ConnectionItemElement
implements IConnectionItem {
    private String name;
    private String path;
    private String mode;

    public RandomAccessFileElement(Node node, TagElement parent) {
        super(node, parent);
    }

    protected String findType() {
        if (this.getAttribute("implementation") != null) {
            return this.getAttribute("implementation");
        }
        return DeviceKitGenerationConstants.CLASS_CONNECTION_RANDOM_ACCESS_FILE;
    }

    public ConfigurationField[] getConfigurationOptions() {
        ConfigurationModel model = ConfigurationModel.getConnection("randomaccessfile");
        return model.getConfigurationFields();
    }

    public String getConnectionConstant() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append(DkUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_RANDOM_ACCESS_FILE_SERVICE));
        buffer.append('.');
        buffer.append("CONNECTION_TYPE");
        return buffer.toString();
    }

    public String getConnectionTag() {
        return "randomaccessfile";
    }

    public String[] getExtraImports() {
        return new String[0];
    }

    public String getMode() {
        if (this.mode == null) {
            this.mode = "rw";
        }
        return this.mode;
    }

    public Map getProperties() {
        HashMap<String, String> table = new HashMap<String, String>();
        table.put("name", this.getRandomAccessFilePath());
        table.put("path", this.getRandomAccessFileName());
        table.put("mode", this.getMode());
        return table;
    }

    public String getRandomAccessFileName() {
        if (this.name == null) {
            this.name = "name";
        }
        return this.name;
    }

    public String getRandomAccessFilePath() {
        if (this.path == null) {
            this.path = "path";
        }
        return this.path;
    }

    public int getTagCode() {
        return 61;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("name".equals(childNodeName)) {
            this.setRandomAccessFileName(ParserUtilities.extractData(childNode));
        } else if ("path".equals(childNodeName)) {
            this.setRandomAccessFilePath(ParserUtilities.extractData(childNode));
        } else if ("mode".equals(childNodeName)) {
            this.setMode(ParserUtilities.extractData(childNode));
        } else {
            super.handleChild(childNode);
        }
    }

    private void setMode(String mode) {
        this.mode = mode;
    }

    private void setRandomAccessFileName(String name) {
        this.name = name;
    }

    private void setRandomAccessFilePath(String path) {
        this.path = path;
    }
}

