/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.build.IBuildModelFactory;
import org.eclipse.pde.internal.core.build.BuildModelFactory;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.soda.sat.plugin.activator.ui.internal.bundle.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildPropertiesFileManager {
    private WorkspaceBuildModel buildModel;
    private IBuild build;
    private IBuildModelFactory buildModelFactory;
    private IFile file;

    public BuildPropertiesFileManager(IFile file) {
        this.setFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addKey(String key) {
        IBuild build;
        boolean added = false;
        IBuild iBuild = build = this.getBuild();
        synchronized (iBuild) {
            try {
                this.getBuildEntry(key);
                this.dirty();
                added = true;
            }
            catch (CoreException exception) {
                this.logError(exception);
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addToken(String key, String token) {
        boolean added = false;
        try {
            IBuildEntry entry;
            IBuildEntry iBuildEntry = entry = this.getBuildEntry(key);
            synchronized (iBuildEntry) {
                boolean exists = entry.contains(token);
                if (exists) {
                    return true;
                }
                entry.addToken(token);
                this.dirty();
                return true;
            }
        }
        catch (CoreException exception) {
            this.logError(exception);
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBuildEntry basicGetEntry(String key) {
        IBuildEntry entry;
        IBuild build;
        IBuild iBuild = build = this.getBuild();
        synchronized (iBuild) {
            entry = build.getEntry(key);
        }
        return entry;
    }

    private Properties buildProperties() {
        Properties properties = new Properties();
        List<String> keys = this.getKeys();
        for (String key : keys) {
            String value = this.getValue(key);
            properties.put(key, value);
        }
        return properties;
    }

    private IBuildEntry createBuildEntry(String key) {
        IBuildModelFactory factory = this.getBuildModelFactory();
        IBuildEntry entry = factory.createEntry(key);
        return entry;
    }

    private IBuildModelFactory createBuildModelFactory() {
        WorkspaceBuildModel model = this.getBuildModel();
        BuildModelFactory factory = new BuildModelFactory((IBuildModel)model);
        return factory;
    }

    private WorkspaceBuildModel createModel() {
        IFile file = this.getFile();
        WorkspaceBuildModel model = new WorkspaceBuildModel(file);
        model.load();
        return model;
    }

    private void dirty() {
        WorkspaceBuildModel model = this.getBuildModel();
        model.setDirty(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBuild getBuild() {
        WorkspaceBuildModel model;
        WorkspaceBuildModel workspaceBuildModel = model = this.getBuildModel();
        synchronized (workspaceBuildModel) {
            if (this.build == null) {
                IBuild build = model.getBuild();
                this.setBuild(build);
            }
        }
        return this.build;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBuildEntry getBuildEntry(String key) throws CoreException {
        IBuildEntry entry;
        IBuild build;
        IBuild iBuild = build = this.getBuild();
        synchronized (iBuild) {
            entry = this.basicGetEntry(key);
            if (entry == null) {
                entry = this.createBuildEntry(key);
                build.add(entry);
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkspaceBuildModel getBuildModel() {
        BuildPropertiesFileManager buildPropertiesFileManager = this;
        synchronized (buildPropertiesFileManager) {
            if (this.buildModel == null) {
                WorkspaceBuildModel model = this.createModel();
                this.setBuildModel(model);
            }
        }
        return this.buildModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBuildModelFactory getBuildModelFactory() {
        BuildPropertiesFileManager buildPropertiesFileManager = this;
        synchronized (buildPropertiesFileManager) {
            if (this.buildModelFactory == null) {
                IBuildModelFactory factory = this.createBuildModelFactory();
                this.setBuildModelFactory(factory);
            }
        }
        return this.buildModelFactory;
    }

    private IFile getFile() {
        return this.file;
    }

    public List<String> getKeys() {
        IBuild build = this.getBuild();
        IBuildEntry[] entries = build.getBuildEntries();
        int size = entries.length;
        ArrayList<String> list = new ArrayList<String>(size);
        int i = 0;
        while (i < size) {
            IBuildEntry entry = entries[i];
            String key = entry.getName();
            list.add(key);
            ++i;
        }
        return list;
    }

    public Properties getProperties() {
        Properties properties = null;
        boolean dirty = this.isDirty();
        if (dirty) {
            properties = this.buildProperties();
        } else {
            try {
                properties = this.loadProperties();
            }
            catch (CoreException exception) {
                this.logError(exception);
            }
            catch (IOException exception) {
                this.logError(exception);
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTokens(String key) {
        IBuild build;
        String[] value = null;
        IBuild iBuild = build = this.getBuild();
        synchronized (iBuild) {
            IBuildEntry entry = this.basicGetEntry(key);
            if (entry != null) {
                value = entry.getTokens();
            }
        }
        return value;
    }

    public String getValue(String key) {
        String[] values = this.getTokens(key);
        int size = values.length;
        StringBuffer buffer = new StringBuffer(size * 25);
        int i = 0;
        while (i < size) {
            String value = values[i];
            buffer.append(value);
            if (i < size) {
                buffer.append(", ");
            }
            ++i;
        }
        String value = buffer.toString();
        return value;
    }

    private boolean isDirty() {
        WorkspaceBuildModel model = this.getBuildModel();
        boolean dirty = model.isDirty();
        return dirty;
    }

    private Properties loadProperties() throws IOException, CoreException {
        Properties properties = null;
        IFile file = this.getFile();
        InputStream stream = null;
        try {
            stream = file.getContents(true);
            properties = new Properties();
            properties.load(stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return properties;
    }

    private void logError(Throwable throwable) {
        Activator activator = Activator.getDefault();
        activator.log(4, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeKey(String key) {
        IBuild build;
        boolean removed = false;
        IBuild iBuild = build = this.getBuild();
        synchronized (iBuild) {
            IBuildEntry entry;
            block6: {
                entry = this.basicGetEntry(key);
                if (entry != null) break block6;
                return true;
            }
            try {
                build.remove(entry);
                this.dirty();
                removed = true;
            }
            catch (CoreException exception) {
                this.logError(exception);
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeToken(String key, String token) {
        boolean removed = false;
        try {
            IBuildEntry entry;
            IBuildEntry iBuildEntry = entry = this.getBuildEntry(key);
            synchronized (iBuildEntry) {
                boolean exists = entry.contains(token);
                if (exists) {
                    return true;
                }
                entry.removeToken(token);
                this.dirty();
                return true;
            }
        }
        catch (CoreException exception) {
            this.logError(exception);
        }
        return removed;
    }

    public void save() {
        WorkspaceBuildModel model = this.getBuildModel();
        model.save();
    }

    private void setBuild(IBuild build) {
        this.build = build;
    }

    private void setBuildModel(WorkspaceBuildModel model) {
        this.buildModel = model;
    }

    private void setBuildModelFactory(IBuildModelFactory buildModelFactory) {
        this.buildModelFactory = buildModelFactory;
    }

    private void setFile(IFile file) {
        this.file = file;
    }
}

