/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.soda.sat.plugin.activator.ui.internal.bundle.Activator;
import org.eclipse.soda.sat.plugin.activator.ui.internal.util.api.IFileManager;

abstract class FileManager
implements IFileManager {
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private IFile file;
    private boolean dirty;
    private final Object lock = new Object();

    protected FileManager(IFile file) {
        this.setFile(file);
        this.setDirty(false);
    }

    private void applyChanges(String contents) throws CoreException, IOException {
        byte[] bytes = contents.getBytes();
        IFile file = this.getFile();
        InputStream stream = null;
        try {
            stream = new ByteArrayInputStream(bytes);
            stream = new BufferedInputStream(stream);
            file.setContents(stream, true, true, null);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            this.setDirty(false);
        }
    }

    protected abstract String getContents() throws CoreException, IOException;

    protected final IFile getFile() {
        return this.file;
    }

    protected final Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isDirty() {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            return this.dirty;
        }
    }

    protected final void logError(Throwable throwable) {
        Activator activator = Activator.getDefault();
        activator.log(4, throwable);
    }

    protected void postApplyChanges() throws CoreException, IOException {
    }

    protected void preApplyChanges() throws CoreException, IOException {
    }

    protected abstract void printOn(StringBuffer var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save() throws CoreException, IOException {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            boolean dirty = this.isDirty();
            if (!dirty) {
                return;
            }
            this.preApplyChanges();
            String contents = this.getContents();
            this.applyChanges(contents);
            this.postApplyChanges();
        }
    }

    protected final void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    private void setFile(IFile file) {
        this.file = file;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer(300);
        try {
            this.printOn(buffer);
        }
        catch (Exception exception) {
            this.logError(exception);
            String basic = super.toString();
            buffer.append(basic);
        }
        String value = buffer.toString();
        return value;
    }
}

