/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.internal.equinox.console.cmdprov;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.soda.sat.core.service.BundleDependencyService;
import org.eclipse.soda.sat.core.util.MessageFormatter;
import org.eclipse.soda.sat.internal.equinox.console.cmdprov.AbstractCommandProvider;
import org.eclipse.soda.sat.internal.equinox.console.cmdprov.nls.Messages;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class MissingImportedServicesCommandProvider
extends AbstractCommandProvider {
    private static final String ALL_MISSING_IMPORTED_SERVICES_DESCRIPTION_KEY = "MissingImportedServicesCommandProvider.AllMissingImportedServicesDescription";
    private static final String IDENTIFIERS_DESCRIPTION_KEY = "MissingImportedServicesCommandProvider.IdentifiersDescription";
    private static final String MISSING_OPTIONAL_IMPORTED_SERVICES_KEY = "MissingImportedServicesCommandProvider.MissingOptionalImportedServices";
    private static final String MISSING_OPTIONAL_IMPORTED_SERVICES_DESCRIPTION_KEY = "MissingImportedServicesCommandProvider.MissingOptionalImportedServicesDescription";
    private static final String MISSING_REQUIRED_IMPORTED_SERVICES_KEY = "MissingImportedServicesCommandProvider.MissingRequiredImportedServices";
    private static final String MISSING_REQUIRED_IMPORTED_SERVICES_DESCRIPTION_KEY = "MissingImportedServicesCommandProvider.MissingRequiredImportedServicesDescription";
    private static final String TITLE_KEY = "MissingImportedServicesCommandProvider.Title";
    private static final String ALL_MISSING_IMPORTED_SERVICES_DESCRIPTION = Messages.getString("MissingImportedServicesCommandProvider.AllMissingImportedServicesDescription");
    private static final String IDENTIFIERS_DESCRIPTION = Messages.getString("MissingImportedServicesCommandProvider.IdentifiersDescription");
    private static final String MISSING_OPTIONAL_IMPORTED_SERVICES = Messages.getString("MissingImportedServicesCommandProvider.MissingOptionalImportedServices");
    private static final String MISSING_OPTIONAL_IMPORTED_SERVICES_DESCRIPTION = Messages.getString("MissingImportedServicesCommandProvider.MissingOptionalImportedServicesDescription");
    private static final String MISSING_REQUIRED_IMPORTED_SERVICES = Messages.getString("MissingImportedServicesCommandProvider.MissingRequiredImportedServices");
    private static final String MISSING_REQUIRED_IMPORTED_SERVICES_DESCRIPTION = Messages.getString("MissingImportedServicesCommandProvider.MissingRequiredImportedServicesDescription");
    private static final String TITLE = Messages.getString("MissingImportedServicesCommandProvider.Title");
    private static final String IDENTIFIERS_COMMAND_HELP = "ids - {0}";
    private static final String MISSING_OPTIONAL_IMPORTED_SERVICES_COMMAND_HELP = "mos [id] - {0}";
    private static final String MISSING_REQUIRED_IMPORTED_SERVICES_COMMAND_HELP = "mrs [id] - {0}";
    private static final String ALL_MISSING_IMPORTED_SERVICES_COMMAND_HELP = "ams [id] - {0}";
    private BundleDependencyService model;

    public MissingImportedServicesCommandProvider(BundleContext bundleContext, BundleDependencyService bundleDependencyService) {
        super(bundleContext);
        this.setModel(bundleDependencyService);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _ams(CommandInterpreter interpreter) throws Exception {
        this.setInterpreter(interpreter);
        List ids = this.getIds();
        try {
            this.appendMissingRequiredImportedServices(ids);
            this.appendMissingOptionalImportedServices(ids);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.flushBuffer();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.flushBuffer();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _ids(CommandInterpreter interpreter) throws Exception {
        this.setInterpreter(interpreter);
        List ids = this.getAllIds();
        try {
            this.append(ids);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.flushBuffer();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.flushBuffer();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _missing(CommandInterpreter interpreter) throws Exception {
        this.setInterpreter(interpreter);
        try {
            this.appendAllMissingImportedServices();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.flushBuffer();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.flushBuffer();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _mos(CommandInterpreter interpreter) throws Exception {
        this.setInterpreter(interpreter);
        List ids = this.getIds();
        try {
            this.appendMissingOptionalImportedServices(ids);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.flushBuffer();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.flushBuffer();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _mrs(CommandInterpreter interpreter) throws Exception {
        this.setInterpreter(interpreter);
        List ids = this.getIds();
        try {
            this.appendMissingRequiredImportedServices(ids);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.flushBuffer();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.flushBuffer();
    }

    private void appendAllMissingImportedServices() {
        List ids = this.getAllIds();
        int size = ids.size();
        ArrayList list = new ArrayList(size);
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            String id = (String)iterator.next();
            this.collectMissingRequiredImportedServices(id, list);
            this.collectMissingOptionalImportedServices(id, list);
        }
        TreeSet set = new TreeSet(list);
        this.append(set);
    }

    private void appendMissingImportedServices(String id, List names, String pattern) {
        boolean empty = names.isEmpty();
        if (empty) {
            return;
        }
        String message = MessageFormatter.format((String)pattern, (Object)id);
        this.appendLine(message);
        Collections.sort(names);
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            this.appendIndent();
            this.appendLine(name);
        }
    }

    private void appendMissingOptionalImportedServices(List ids) throws Exception {
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            String id = (String)iterator.next();
            this.appendMissingOptionalImportedServices(id);
        }
    }

    private void appendMissingOptionalImportedServices(String id) {
        List names = this.getMissingOptionalImportedServices(id);
        this.appendMissingImportedServices(id, names, MISSING_OPTIONAL_IMPORTED_SERVICES);
    }

    private void appendMissingRequiredImportedServices(List ids) throws Exception {
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            String id = (String)iterator.next();
            this.appendMissingRequiredImportedServices(id);
        }
    }

    private void appendMissingRequiredImportedServices(String id) {
        List names = this.getMissingRequiredImportedServices(id);
        this.appendMissingImportedServices(id, names, MISSING_REQUIRED_IMPORTED_SERVICES);
    }

    private void collectMissingOptionalImportedServices(String id, List list) {
        List missing = this.getMissingOptionalImportedServices(id);
        list.addAll(missing);
    }

    private void collectMissingRequiredImportedServices(String id, List list) {
        List missing = this.getMissingRequiredImportedServices(id);
        list.addAll(missing);
    }

    private List getAllIdArguments() {
        List arguments = this.getAllArguments();
        boolean empty = arguments.isEmpty();
        if (empty) {
            return arguments;
        }
        int size = arguments.size();
        ArrayList<String> ids = new ArrayList<String>(size);
        Iterator iterator = arguments.iterator();
        while (iterator.hasNext()) {
            String argument = (String)iterator.next();
            Bundle bundle = this.getBundle(argument);
            String id = bundle != null ? bundle.getSymbolicName() : argument;
            ids.add(id);
        }
        return ids;
    }

    private List getAllIds() {
        BundleDependencyService model = this.getModel();
        List list = model.getBundleActivationManagerIds();
        return list;
    }

    private String getAllMissingImportedServicesCommandHelpLine() {
        return MessageFormatter.format((String)ALL_MISSING_IMPORTED_SERVICES_COMMAND_HELP, (Object)ALL_MISSING_IMPORTED_SERVICES_DESCRIPTION);
    }

    protected String[] getCommandHelpLines() {
        return new String[]{this.getAllMissingImportedServicesCommandHelpLine(), this.getIdentifiersCommandHelpLine(), this.getMissingOptionalImportedServicesCommandHelpLine(), this.getMissingRequiredImportedServicesCommandHelpLine()};
    }

    private String getIdentifiersCommandHelpLine() {
        return MessageFormatter.format((String)IDENTIFIERS_COMMAND_HELP, (Object)IDENTIFIERS_DESCRIPTION);
    }

    private List getIds() {
        List ids = this.getAllIdArguments();
        boolean empty = ids.isEmpty();
        if (empty) {
            ids = this.getAllIds();
        }
        return ids;
    }

    private List getMissingOptionalImportedServices(String id) {
        BundleDependencyService model = this.getModel();
        List names = model.getUnacquiredOptionalImportedServiceNames(id);
        if (names == null) {
            return AbstractCommandProvider.EMPTY_LIST;
        }
        return names;
    }

    private String getMissingOptionalImportedServicesCommandHelpLine() {
        return MessageFormatter.format((String)MISSING_OPTIONAL_IMPORTED_SERVICES_COMMAND_HELP, (Object)MISSING_OPTIONAL_IMPORTED_SERVICES_DESCRIPTION);
    }

    private List getMissingRequiredImportedServices(String id) {
        BundleDependencyService model = this.getModel();
        List names = model.getUnacquiredImportedServiceNames(id);
        if (names == null) {
            return AbstractCommandProvider.EMPTY_LIST;
        }
        return names;
    }

    private String getMissingRequiredImportedServicesCommandHelpLine() {
        return MessageFormatter.format((String)MISSING_REQUIRED_IMPORTED_SERVICES_COMMAND_HELP, (Object)MISSING_REQUIRED_IMPORTED_SERVICES_DESCRIPTION);
    }

    private BundleDependencyService getModel() {
        return this.model;
    }

    protected String getTitle() {
        return TITLE;
    }

    private void setModel(BundleDependencyService model) {
        this.model = model;
    }
}

