/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.util;

import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.util.MessageFormatter;

public final class Assertion {
    private static final String ARGUMENT_MUST_NOT_BE_NULL_KEY = "Assertion.ArgumentMustNotBeNull";
    private static final String ARGUMENT_MUST_BE_IN_RANGE_KEY = "Assertion.ArgumentMustBeInRange";
    private static final String ARGUMENT_1_MUST_BE_LESS_THAN_OR_EQUAL_TO_ARGUMENT_2_KEY = "Assertion.Argument1MustBeLessThanOrEqualToArgument2";
    private static final String ARRAY_MUST_NOT_BE_EMPTY = "Assertion.ArrayMustNotBeEmpty";

    public static void checkArgumentIsNotNull(Object value, String name) throws IllegalArgumentException {
        Assertion.checkIsNotNull(value, ARGUMENT_MUST_NOT_BE_NULL_KEY, name);
    }

    public static void checkArrayIsNotEmpty(Object value, String name) throws IllegalArgumentException {
        Object[] array = (Object[])value;
        if (array.length != 0) {
            return;
        }
        String pattern = ARRAY_MUST_NOT_BE_EMPTY;
        String message = MessageFormatter.format(pattern, name);
        throw new IllegalArgumentException(message);
    }

    private static void checkIsLessThanOrEqualTo(long value1, String name1, long value2, String name2) throws IllegalArgumentException {
        if (value1 <= value2) {
            return;
        }
        String pattern = ARGUMENT_1_MUST_BE_LESS_THAN_OR_EQUAL_TO_ARGUMENT_2_KEY;
        Object[] values = new Object[]{name1, new Long(value1), name2, new Long(value2)};
        String message = MessageFormatter.format(pattern, values);
        throw new IllegalArgumentException(message);
    }

    public static void checkIsNotNull(Object value, String messageKey) throws IllegalArgumentException {
        Assertion.checkIsNotNull(value, messageKey, null);
    }

    public static void checkIsNotNull(Object value, String messageKey, Object messageParameter) throws IllegalArgumentException {
        if (value != null) {
            return;
        }
        String message = Messages.getString(messageKey);
        if (messageParameter != null) {
            message = MessageFormatter.format(message, messageParameter);
        }
        throw new IllegalArgumentException(message);
    }

    public static void checkRange(long value, String name, long beginRange, long endRange) throws IllegalArgumentException {
        Assertion.checkIsLessThanOrEqualTo(beginRange, "beginRange", endRange, "endRange");
        if (value >= beginRange && value <= endRange) {
            return;
        }
        Object[] values = new Object[]{name, new Long(value), new Long(beginRange), new Long(endRange)};
        String pattern = Messages.getString(ARGUMENT_MUST_BE_IN_RANGE_KEY);
        String message = MessageFormatter.format(pattern, values);
        throw new IllegalArgumentException(message);
    }

    private Assertion() {
    }
}

