/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.junit.internal.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import junit.framework.Test;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.eclipse.soda.sat.core.junit.internal.AllTests;
import org.eclipse.soda.sat.core.service.LogReaderAggregatorService;
import org.eclipse.soda.sat.junit.service.TestRunnerServerService;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;

public class Activator
extends BaseBundleActivator {
    public static BundleContext BUNDLE_CONTEXT;
    public static ConfigurationAdmin CONFIGURATION_ADMIN;
    public static LogReaderAggregatorService LOG_READER_AGGREGATOR_SERVICE;
    private static final String CONFIGURATION_ADMIN_SERVICE_NAME;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.cm.ConfigurationAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CONFIGURATION_ADMIN_SERVICE_NAME = clazz.getName();
    }

    protected void activate() {
        BundleContext bundleContext;
        BUNDLE_CONTEXT = bundleContext = this.getBundleContext();
        CONFIGURATION_ADMIN = this.getConfigurationAdmin();
        LOG_READER_AGGREGATOR_SERVICE = this.getLogReaderAggregatorService();
        TestRunnerServerService server = this.getTestRunnerServerService();
        Test test = AllTests.suite();
        server.run(test);
    }

    private void addSystemProperties() {
        Properties properties = this.getProperties();
        boolean empty = properties.isEmpty();
        if (empty) {
            return;
        }
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = properties.getProperty(key);
            this.addSystemProperty(key, value);
        }
    }

    private void addSystemProperty(Object key, Object value) {
        Properties sysProps = System.getProperties();
        boolean exists = sysProps.containsKey(key);
        if (exists) {
            return;
        }
        sysProps.put(key, value);
    }

    protected void deactivate() {
        LOG_READER_AGGREGATOR_SERVICE = null;
        CONFIGURATION_ADMIN = null;
        BUNDLE_CONTEXT = null;
    }

    private ConfigurationAdmin getConfigurationAdmin() {
        return (ConfigurationAdmin)this.getImportedService(CONFIGURATION_ADMIN_SERVICE_NAME);
    }

    protected String[] getImportedServiceNames() {
        return new String[]{TestRunnerServerService.SERVICE_NAME, CONFIGURATION_ADMIN_SERVICE_NAME, LogReaderAggregatorService.SERVICE_NAME};
    }

    private LogReaderAggregatorService getLogReaderAggregatorService() {
        return (LogReaderAggregatorService)this.getImportedService(LogReaderAggregatorService.SERVICE_NAME);
    }

    protected InputStream getPropertiesInputStream() throws IOException {
        InputStream stream = this.getFilePropertiesInputStream();
        if (stream != null) {
            return stream;
        }
        stream = this.getResourcePropertiesInputStream();
        return stream;
    }

    private TestRunnerServerService getTestRunnerServerService() {
        return (TestRunnerServerService)this.getImportedService(TestRunnerServerService.SERVICE_NAME);
    }

    protected void handleFailedToFindProperties(String filename) {
    }

    private void removeSystemProperties() {
        Properties properties = this.getProperties();
        boolean empty = properties.isEmpty();
        if (empty) {
            return;
        }
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.removeSystemProperty(key);
        }
    }

    private void removeSystemProperty(String key) {
        Properties sysProps = System.getProperties();
        sysProps.remove(key);
    }

    protected void start() {
        this.addSystemProperties();
    }

    protected void stop() {
        this.removeSystemProperties();
    }
}

