/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util.test;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.framework.interfaces.ITokenizer;
import org.eclipse.soda.sat.core.junit.internal.AbstractSatTestCase;

public class TokenizerTestCase
extends AbstractSatTestCase {
    private static final String ONE = "one";
    private static final String TWO = "two";
    private static final String THREE = "three";
    private static final String ONE_TWO_THREE = "one,two,three";
    private static final char COMMA = ',';
    private static final char SPACE = ' ';
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.util.test.TokenizerTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public TokenizerTestCase(String name) {
        super(name);
    }

    private void _test_nextToken(String value, char delimiter) {
        ITokenizer tokenizer = this.createTokenizer(value, delimiter);
        ArrayList<String> tokens = new ArrayList<String>(5);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            tokens.add(token);
        }
        Object actual = tokens.get(0);
        Assert.assertEquals((Object)ONE, actual);
        actual = tokens.get(1);
        Assert.assertEquals((Object)TWO, actual);
        actual = tokens.get(2);
        Assert.assertEquals((Object)THREE, actual);
        actual = tokenizer.nextToken();
        Assert.assertEquals(null, actual);
    }

    private Runnable createRunnable(final ITokenizer tokenizer, final List list) {
        return new Runnable(){

            public void run() {
                TokenizerTestCase.this.process(tokenizer, list);
            }
        };
    }

    private Thread createThread(int id, ITokenizer tokenizer, List list) {
        String name = "Tokenizer-" + id;
        Runnable runnable = this.createRunnable(tokenizer, list);
        Thread thread = new Thread(runnable, name);
        return thread;
    }

    private ITokenizer createTokenizer(String value) {
        return AbstractSatTestCase.FACTORY.createTokenizer(value);
    }

    private ITokenizer createTokenizer(String value, char delimiter) {
        return AbstractSatTestCase.FACTORY.createTokenizer(value, delimiter);
    }

    private ITokenizer createTokenizer(String value, int offset) {
        ITokenizer tokenizer = AbstractSatTestCase.FACTORY.createTokenizer(value, offset);
        return tokenizer;
    }

    private void process(ITokenizer tokenizer, List list) {
        try {
            String token;
            while ((token = tokenizer.nextToken()) != null) {
                list.add(token);
                Thread.sleep(25L);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public void test_constructorsWithIllegalArguments() {
        try {
            this.createTokenizer(null);
            Assert.fail((String)"The parameter must not be null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
        try {
            int offset = -1;
            this.createTokenizer("one,two", offset);
            Assert.fail((String)"The index parameter must be a positive interger");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
    }

    public void test_constructorWithOffset() {
        String value = "one,two";
        ITokenizer tokenizer = this.createTokenizer(value, 0);
        String actual = tokenizer.nextToken();
        Assert.assertEquals((Object)ONE, (Object)actual);
        tokenizer = this.createTokenizer(value, 1);
        String expected = "ne";
        actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, (Object)actual);
        tokenizer = this.createTokenizer(value, 3);
        expected = new String();
        actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, (Object)actual);
        tokenizer = this.createTokenizer(value, 4);
        actual = tokenizer.nextToken();
        Assert.assertEquals((Object)TWO, (Object)actual);
        tokenizer = this.createTokenizer(value, 6);
        expected = "o";
        actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, (Object)actual);
        tokenizer = this.createTokenizer(value, 7);
        actual = tokenizer.nextToken();
        Assert.assertNull((Object)actual);
    }

    public void test_hasMoreTokens() {
        ITokenizer tokenizer = this.createTokenizer(ONE_TWO_THREE);
        boolean expected = true;
        boolean actual = tokenizer.hasMoreTokens();
        tokenizer.nextToken();
        Assert.assertEquals((boolean)expected, (boolean)actual);
        actual = tokenizer.hasMoreTokens();
        tokenizer.nextToken();
        Assert.assertEquals((boolean)expected, (boolean)actual);
        actual = tokenizer.hasMoreTokens();
        tokenizer.nextToken();
        Assert.assertEquals((boolean)expected, (boolean)actual);
        expected = false;
        actual = tokenizer.hasMoreTokens();
        Assert.assertEquals((boolean)expected, (boolean)actual);
    }

    public void test_nextToken() {
        this._test_nextToken(ONE_TWO_THREE, ',');
        String value = "one two three";
        this._test_nextToken(value, ' ');
    }

    public void test_nextTokenWithDuplicateDelimiter() {
        String value = "one,,three";
        ITokenizer tokenizer = this.createTokenizer(value);
        String expected = ONE;
        String actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = new String();
        actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = THREE;
        actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_nextTokenWithEmptyString() {
        String value = new String();
        ITokenizer tokenizer = this.createTokenizer(value);
        Object expected = null;
        String actual = tokenizer.nextToken();
        Assert.assertEquals(expected, (Object)actual);
    }

    public void test_nextTokenWithLeadingDelimiter() {
        String value = ",one";
        ITokenizer tokenizer = this.createTokenizer(value);
        String expected = new String();
        String actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = ONE;
        actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = null;
        actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_nextTokenWithTrailingDelimiter() {
        String value = ONE;
        ITokenizer tokenizer = this.createTokenizer(value);
        String expected = ONE;
        String actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = null;
        actual = tokenizer.nextToken();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_synchronization() {
        ITokenizer tokenizer = this.createTokenizer("1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25");
        tokenizer = tokenizer.toSynchronizedTokenizer();
        ArrayList list1 = new ArrayList(10);
        ArrayList list2 = new ArrayList(10);
        ArrayList list3 = new ArrayList(10);
        Thread thread1 = this.createThread(1, tokenizer, list1);
        Thread thread2 = this.createThread(2, tokenizer, list2);
        Thread thread3 = this.createThread(3, tokenizer, list3);
        thread1.start();
        thread2.start();
        thread3.start();
        try {
            thread1.join();
            thread2.join();
            thread3.join();
        }
        catch (InterruptedException interruptedException) {
            Assert.fail();
        }
        int expectedSize = 25;
        ArrayList tokens = new ArrayList(expectedSize);
        tokens.addAll(list1);
        tokens.addAll(list2);
        tokens.addAll(list3);
        int actualSize = tokens.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
    }

    public void test_toSynchronizedTokenizer() {
        ITokenizer tokenizer = this.createTokenizer(ONE_TWO_THREE);
        ITokenizer synchronizedTokenizer = tokenizer.toSynchronizedTokenizer();
        Assert.assertNotSame((Object)tokenizer, (Object)synchronizedTokenizer);
        ITokenizer alias = synchronizedTokenizer.toSynchronizedTokenizer();
        Assert.assertSame((Object)synchronizedTokenizer, (Object)alias);
        ITokenizer synchronizedTokenizer2 = tokenizer.toSynchronizedTokenizer();
        Assert.assertNotSame((Object)synchronizedTokenizer, (Object)synchronizedTokenizer2);
        String expectedName = "SynchronizedTokenizer";
        Class<?> clazz = synchronizedTokenizer.getClass();
        String actualName = clazz.getName();
        boolean state = actualName.endsWith(expectedName);
        Assert.assertTrue((boolean)state);
    }
}

