/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.soda.dk.core.EscObject;

public class LLRPConfigParser {
    public static String getString(String str, int fromIndex, char startChar, char endChar) {
        char[] chars = str.toCharArray();
        int startIndex = str.indexOf(startChar, fromIndex);
        if (startIndex == -1) {
            return "";
        }
        int startCharCount = 0;
        StringBuffer result = new StringBuffer();
        int i = startIndex + 1;
        while (i < chars.length) {
            if (chars[i] == startChar) {
                ++startCharCount;
                result.append(chars[i]);
            } else if (chars[i] == endChar) {
                if (startCharCount <= 0) break;
                --startCharCount;
                result.append(chars[i]);
            } else {
                result.append(chars[i]);
            }
            ++i;
        }
        return result.toString();
    }

    public static byte[] parseByteArray(String arrayContent) {
        StringTokenizer items = new StringTokenizer(arrayContent);
        byte[] result = new byte[items.countTokens()];
        int i = 0;
        while (items.hasMoreTokens()) {
            String item = items.nextToken();
            result[i] = (byte)Integer.parseInt(item, 16);
            ++i;
        }
        return result;
    }

    public static Object parseConfig(String str) {
        if (str == null || str.trim().length() == 0) {
            return new HashMap();
        }
        if (str.startsWith("[]{")) {
            String listContent = LLRPConfigParser.getString(str, 2, '{', '}');
            return LLRPConfigParser.parseList(listContent);
        }
        if (str.startsWith("{")) {
            String mapContent = LLRPConfigParser.getString(str, 0, '{', '}');
            return LLRPConfigParser.parseMap(mapContent);
        }
        if (str.startsWith("\"")) {
            String string = str.substring(1, str.length() - 1);
            return string;
        }
        if (str.startsWith("[")) {
            String arrayContent = LLRPConfigParser.getString(str, 0, '[', ']');
            if (arrayContent.startsWith("0x")) {
                String content = arrayContent.substring(2);
                return LLRPConfigParser.parseByteArray(content);
            }
            if (arrayContent.startsWith("\"")) {
                return LLRPConfigParser.parseStringArray(arrayContent);
            }
            return LLRPConfigParser.parseIntArray(arrayContent);
        }
        return EscObject.createInteger((int)Integer.parseInt(str));
    }

    public static int[] parseIntArray(String arrayContent) {
        StringTokenizer items = new StringTokenizer(arrayContent);
        int[] result = new int[items.countTokens()];
        int i = 0;
        while (items.hasMoreTokens()) {
            String item = items.nextToken();
            result[i] = Integer.parseInt(item);
            ++i;
        }
        return result;
    }

    public static List parseList(String listContent) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (listContent.startsWith("{")) {
            int startIndex = 0;
            while (startIndex < listContent.length()) {
                String mapContent = LLRPConfigParser.getString(listContent, startIndex, '{', '}');
                Map map = LLRPConfigParser.parseMap(mapContent);
                result.add(map);
                startIndex = startIndex + mapContent.length() + 3;
            }
        } else {
            StringTokenizer items = new StringTokenizer(listContent);
            while (items.hasMoreTokens()) {
                result.add(Integer.valueOf(items.nextToken()));
            }
        }
        return result;
    }

    public static Map parseMap(String mapContent) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> items = new ArrayList<String>();
        char[] contentChars = mapContent.toCharArray();
        StringBuffer item = new StringBuffer();
        int insideMapCount = 0;
        int i = 0;
        while (i < contentChars.length) {
            if (contentChars[i] == ',' && insideMapCount == 0) {
                items.add(item.toString());
                item = new StringBuffer();
            } else {
                item.append(contentChars[i]);
                if (contentChars[i] == '{') {
                    ++insideMapCount;
                } else if (contentChars[i] == '}') {
                    --insideMapCount;
                }
                if (i == contentChars.length - 1) {
                    items.add(item.toString());
                }
            }
            ++i;
        }
        i = 0;
        while (i < items.size()) {
            String itemStr = (String)items.get(i);
            int equalIndex = itemStr.indexOf(61);
            String key = itemStr.substring(1, equalIndex - 1);
            String value = itemStr.substring(equalIndex + 1);
            Object valueObj = LLRPConfigParser.parseConfig(value);
            result.put(key, valueObj);
            ++i;
        }
        return result;
    }

    public static String[] parseStringArray(String arrayContent) {
        StringTokenizer items = new StringTokenizer(arrayContent);
        String[] result = new String[items.countTokens()];
        int i = 0;
        while (items.hasMoreTokens()) {
            String item = items.nextToken();
            result[i] = item.substring(1, item.length() - 1);
            ++i;
        }
        return result;
    }
}

