/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.testmanager.view;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestReportContentProvider
implements ITreeContentProvider {
    private static Set nodeIgnoreSet;
    TreeViewer viewer;

    private static String getNodeDescriptorKey(short nodeType, String nodeName) {
        return String.valueOf(Short.toString(nodeType)) + '/' + nodeName;
    }

    private static synchronized Set getNodeIgnoreSet() {
        if (nodeIgnoreSet == null) {
            nodeIgnoreSet = new HashSet();
            nodeIgnoreSet.add(TestReportContentProvider.getNodeDescriptorKey((short)2, "xmlns:xsi"));
            nodeIgnoreSet.add(TestReportContentProvider.getNodeDescriptorKey((short)2, "xsi:noNamespaceSchemaLocation"));
            nodeIgnoreSet.add(TestReportContentProvider.getNodeDescriptorKey((short)2, "name"));
            nodeIgnoreSet.add(TestReportContentProvider.getNodeDescriptorKey((short)2, "project"));
            nodeIgnoreSet.add(TestReportContentProvider.getNodeDescriptorKey((short)2, "startTime"));
            nodeIgnoreSet.add(TestReportContentProvider.getNodeDescriptorKey((short)2, "testScript"));
            nodeIgnoreSet.add(TestReportContentProvider.getNodeDescriptorKey((short)2, "testName"));
            nodeIgnoreSet.add(TestReportContentProvider.getNodeDescriptorKey((short)2, "id"));
            nodeIgnoreSet.add(TestReportContentProvider.getNodeDescriptorKey((short)2, "message"));
        }
        return nodeIgnoreSet;
    }

    private static boolean ignoreNode(Node node) {
        return TestReportContentProvider.getNodeIgnoreSet().contains(TestReportContentProvider.getNodeDescriptorKey(node.getNodeType(), node.getNodeName()));
    }

    public void dispose() {
    }

    public Object[] getChildren(Object parentElement) {
        Node node = (Node)parentElement;
        if (node != null) {
            ArrayList<Node> children = new ArrayList<Node>();
            NamedNodeMap nodeMap = node.getAttributes();
            if (nodeMap != null) {
                int len = nodeMap.getLength();
                int i = 0;
                while (i < len) {
                    Node item = nodeMap.item(i);
                    if (item.getNodeType() == 2 && !TestReportContentProvider.ignoreNode(item)) {
                        children.add(item);
                    }
                    ++i;
                }
            }
            NodeList nodeList = node.getChildNodes();
            int len = nodeList.getLength();
            int i = 0;
            while (i < len) {
                Node child = nodeList.item(i);
                if (child != null && child.getNodeType() == 1 && !TestReportContentProvider.ignoreNode(child)) {
                    children.add(child);
                }
                ++i;
            }
            return children.toArray();
        }
        return new Object[0];
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Node) {
            return this.getChildren(inputElement);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        Node node = (Node)element;
        if (node != null) {
            return node.getParentNode();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
    }
}

