/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.testmanager.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.soda.devicekit.editor.dkml.DkmlEditorContributor;
import org.eclipse.soda.devicekit.ui.testmanager.TestManagerMessages;
import org.eclipse.soda.devicekit.ui.testmanager.TestManagerPlugin;
import org.eclipse.soda.devicekit.ui.testmanager.util.TestManagerImages;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class TestScriptEditorContributor
extends DkmlEditorContributor {
    private Action runAction;

    public TestScriptEditorContributor() {
        this.createActions();
    }

    public void contributeToMenu(IMenuManager manager) {
        super.contributeToMenu(manager);
        MenuManager menu = new MenuManager(TestManagerMessages.TestScriptEditorContributor_MenuTitle);
        manager.prependToGroup("additions", (IContributionItem)menu);
        menu.add((IAction)this.runAction);
    }

    public void contributeToToolBar(IToolBarManager manager) {
        super.contributeToToolBar(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.runAction);
    }

    private void createActions() {
        this.createRunAction();
    }

    private void createRunAction() {
        this.runAction = new Action(){

            public void run() {
                IWorkbenchPage activePage;
                IWorkbenchWindow activeWindow = TestManagerPlugin.getActiveWorkbenchWindow();
                if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null) {
                    try {
                        IEditorPart editor = TestScriptEditorContributor.this.getActiveEditorPart();
                        IStorageEditorInput editorInput = (IStorageEditorInput)editor.getEditorInput();
                        IJavaProject javaProject = null;
                        if (editorInput instanceof IFileEditorInput) {
                            IFile file = ((IFileEditorInput)editorInput).getFile();
                            javaProject = JavaCore.create((IProject)file.getProject());
                        }
                        TestManagerPlugin.getModel().createTestRunSession(editorInput.getStorage(), javaProject);
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, "org.eclipse.soda.devicekit.ui.testmanager", 0, TestManagerMessages.TestScriptEditorContributor_RunFailed, (Throwable)e);
                        TestManagerPlugin.getDefault().getLog().log((IStatus)status);
                    }
                }
            }
        };
        this.runAction.setText(TestManagerMessages.TestScriptEditorContributor_RunActionTitle);
        this.runAction.setToolTipText(TestManagerMessages.TestScriptEditorContributor_RunActionToolTip);
        TestManagerImages.setLocalImageDescriptors((IAction)this.runAction, "launch.gif");
    }
}

