/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.metadata.model;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.soda.devicekit.generator.metadata.MetaDataUtility;

public abstract class MetaDataInformation {
    public String timeStamp = "" + System.currentTimeMillis();
    private String generatorVersion = MetaDataUtility.getDkVersion();
    public boolean old = false;
    private String dkmlVersion;

    protected MetaDataInformation(String dkmlVersion) {
        this.dkmlVersion = dkmlVersion;
    }

    public Object getData() {
        return this.toString();
    }

    public String getDkmlVersion() {
        return this.dkmlVersion;
    }

    public String getGeneratorVersion() {
        return this.generatorVersion;
    }

    public abstract String getKey();

    public String getPrettyTimeStamp() {
        Long longStamp = Long.valueOf(this.getTimeStamp());
        Date date = new Date(longStamp);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return formatter.format(date);
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public boolean isOld() {
        return this.old;
    }

    public void markOld(boolean old) {
        this.old = old;
    }

    public void setDkmlVersion(String dkmlVersion) {
        this.dkmlVersion = dkmlVersion;
    }

    public void setGeneratorVersion(String generatorVersion) {
        this.generatorVersion = generatorVersion;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }
}

