/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.simplemap.model.triggers.parent;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.mappings.GMFMapFactory;
import org.eclipse.gmf.mappings.LabelMapping;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.tooldef.AbstractTool;
import org.eclipse.gmf.tooldef.CreationTool;
import org.eclipse.gmf.tooling.simplemap.model.triggers.parent.NewElementTrigger;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleChildNode;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleLinkMapping;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleMapping;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleParentNode;

class NewLinkMappingTrigger
extends NewElementTrigger {
    protected SimpleLinkMapping newSimpleLinkMapping;
    protected SimpleParentNode parent;

    public NewLinkMappingTrigger(TransactionalEditingDomain domain, SimpleParentNode parent, SimpleLinkMapping newSimpleLinkMapping) {
        super(domain, (SimpleChildNode)newSimpleLinkMapping);
        this.newSimpleLinkMapping = newSimpleLinkMapping;
        this.parent = parent;
    }

    @Override
    public void executeTrigger() {
        Connection newConnection = GMFGraphFactory.eINSTANCE.createConnection();
        DiagramLabel newLabel = GMFGraphFactory.eINSTANCE.createDiagramLabel();
        this.updateCanvas(newConnection, newLabel);
        CreationTool newCreationTool = this.createNewTool();
        this.updateMapping((SimpleMapping)this.parent, newConnection, newLabel, newCreationTool);
    }

    protected void updateCanvas(Connection newConnection, DiagramLabel newLabel) {
        this.canvasFactory.createNewDefaultPolygon(newConnection, newLabel);
    }

    protected void updateMapping(SimpleMapping mapping, Connection newConnection, DiagramLabel newLabel, CreationTool newCreationTool) {
        LinkMapping newLinkMapping = this.createNewLinkMapping(newConnection, newLabel, newCreationTool);
        mapping.getMapping().getLinks().add((Object)newLinkMapping);
        this.newSimpleLinkMapping.setLinkMapping(newLinkMapping);
    }

    protected LinkMapping createNewLinkMapping(Connection newConnection, DiagramLabel newLabel, CreationTool newCreationTool) {
        LinkMapping newLinkMapping = GMFMapFactory.eINSTANCE.createLinkMapping();
        newLinkMapping.setDiagramLink(newConnection);
        newLinkMapping.setTool((AbstractTool)newCreationTool);
        LabelMapping labelMapping = GMFMapFactory.eINSTANCE.createLabelMapping();
        labelMapping.setDiagramLabel(newLabel);
        newLinkMapping.getLabelMappings().add((Object)labelMapping);
        return newLinkMapping;
    }
}

