/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.simplemap.model.triggers.link;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.gmf.gmfgraph.Identity;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.PolylineConnection;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.tooldef.AbstractTool;
import org.eclipse.gmf.tooling.simplemap.model.triggers.AbstractTrigger;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleLinkMapping;

class SetLinkMappingNameTrigger
extends AbstractTrigger {
    private SimpleLinkMapping simpleLinkMapping;
    private String newName;

    public SetLinkMappingNameTrigger(TransactionalEditingDomain domain, SimpleLinkMapping linkMapping, String newName) {
        super(domain);
        this.simpleLinkMapping = linkMapping;
        this.newName = newName;
    }

    @Override
    public void executeTrigger() {
        this.updateCanvas();
    }

    private void updateCanvas() {
        Connection connectionToRename = this.simpleLinkMapping.getDiagramLink();
        AbstractTool toolToRename = this.simpleLinkMapping.getTool();
        DiagramLabel diagramLabelToRename = this.simpleLinkMapping.getDiagramLabel();
        if (connectionToRename != null && this.canRename((EObject)connectionToRename)) {
            String newLinkName = this.getNewCanvasElementName(this.newName, (Identity)connectionToRename);
            connectionToRename.setName(newLinkName);
            this.renameConnection(connectionToRename, this.newName);
        }
        String newDiagramLabelName = String.valueOf(this.newName) + "ConnectionName";
        if (diagramLabelToRename != null && this.canRename((EObject)diagramLabelToRename)) {
            String newLabelName = this.getNewCanvasElementName(newDiagramLabelName, (Identity)diagramLabelToRename);
            diagramLabelToRename.setName(newLabelName);
            this.renameLabel(diagramLabelToRename, String.valueOf(this.newName) + "ConnectionLabel");
        }
        if (toolToRename != null && this.canRename((EObject)toolToRename)) {
            String newToolName = this.getNewToolName(this.newName, toolToRename);
            toolToRename.setTitle(newToolName);
            toolToRename.setDescription("Create new " + this.newName + "Connection");
        }
    }

    private void renameConnection(Connection connectionToRename, String newElementName) {
        String newFigureName = String.valueOf(newElementName) + "ConnectionFigure";
        FigureDescriptor figDesc = connectionToRename.getFigure();
        String newFigDescName = this.getNewCanvasElementName(newFigureName, (Identity)figDesc);
        figDesc.setName(newFigDescName);
        if (figDesc.getActualFigure() instanceof RealFigure) {
            ((RealFigure)figDesc.getActualFigure()).setName(newFigDescName);
        }
        String newTargetDecorationName = String.valueOf(this.newName) + "TargetDecoration";
        String newSourceDecorationName = String.valueOf(this.newName) + "SourceDecoration";
        if (figDesc.getActualFigure() instanceof PolylineConnection) {
            PolylineConnection polylineConnection = (PolylineConnection)figDesc.getActualFigure();
            if (polylineConnection.getTargetDecoration() != null) {
                polylineConnection.getTargetDecoration().setName(newTargetDecorationName);
            }
            if (polylineConnection.getSourceDecoration() != null) {
                polylineConnection.getSourceDecoration().setName(newSourceDecorationName);
            }
        }
    }

    private void renameLabel(DiagramLabel labelToRename, String newElementName) {
        String newFigureName = String.valueOf(newElementName) + "Figure";
        FigureDescriptor figDesc = labelToRename.getFigure();
        String newFigDescName = this.getNewCanvasElementName(newFigureName, (Identity)figDesc);
        figDesc.setName(newFigDescName);
        if (figDesc.getActualFigure() instanceof RealFigure) {
            ((RealFigure)figDesc.getActualFigure()).setName(newFigDescName);
        }
        if (figDesc.getActualFigure() instanceof Label) {
            ((Label)figDesc.getActualFigure()).setText(this.newName.toLowerCase());
        }
    }
}

