/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.codegen.xtend.ui.handlers;

import com.google.inject.Injector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.common.UnexpectedBehaviourException;
import org.eclipse.gmf.internal.common.codegen.TextEmitter;

public class Xtend2Emitter
implements TextEmitter {
    private final Class<?> myXtendGenerator;
    private final String myMethodName;
    private final Injector myInjector;

    public Xtend2Emitter(Injector injector, Class<?> clazz, String methodName) {
        this.myInjector = injector;
        this.myXtendGenerator = clazz;
        this.myMethodName = methodName;
    }

    public String generate(IProgressMonitor monitor, Object[] arguments) throws InterruptedException, InvocationTargetException, UnexpectedBehaviourException {
        return this.generate(monitor, this.myMethodName, arguments);
    }

    protected String generate(IProgressMonitor monitor, String methodName, Object[] arguments) throws InterruptedException, InvocationTargetException, UnexpectedBehaviourException {
        Object result;
        if (monitor != null && monitor.isCanceled()) {
            throw new InterruptedException();
        }
        if (arguments.length > 1) {
            LinkedList<Object> fixedArgs = new LinkedList<Object>();
            fixedArgs.add(arguments[0]);
            int i = 1;
            while (i < arguments.length) {
                fixedArgs.add(arguments[i]);
                ++i;
            }
            arguments = fixedArgs.toArray();
        }
        Object generator = this.instantiateGenerator();
        Method method = this.getGeneratorMethod(arguments.length, methodName);
        try {
            result = method.invoke(generator, arguments);
        }
        catch (IllegalArgumentException e) {
            throw new UnexpectedBehaviourException("Invocation failed for: " + this, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new UnexpectedBehaviourException("Invocation failed for: " + this, (Throwable)e);
        }
        if (result == null) {
            throw new UnexpectedBehaviourException("Xtend generator returned null for " + this);
        }
        return String.valueOf(result);
    }

    private Object instantiateGenerator() throws UnexpectedBehaviourException {
        Object instance = this.myInjector.getInstance(this.myXtendGenerator);
        if (instance == null) {
            throw new UnexpectedBehaviourException("Can't instantiate Xtend generator object " + this);
        }
        return instance;
    }

    private Method getGeneratorMethod(int paramsCount, String methodName) throws UnexpectedBehaviourException {
        Method[] allMethods;
        try {
            allMethods = this.myXtendGenerator.getDeclaredMethods();
        }
        catch (SecurityException e) {
            throw new UnexpectedBehaviourException("For : " + this, (Throwable)e);
        }
        Method candidate = null;
        Method[] methodArray = allMethods;
        int n = allMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method next = methodArray[n2];
            if (methodName.equals(next.getName()) && next.getParameterTypes().length == paramsCount) {
                if (candidate != null) {
                    throw new UnexpectedBehaviourException("More than 1 method found for " + this + ", " + candidate + " vs " + next);
                }
                candidate = next;
            }
            ++n2;
        }
        if (candidate == null) {
            throw new UnexpectedBehaviourException("No such method (with params count = " + paramsCount + ") for : " + this);
        }
        return candidate;
    }

    public String toString() {
        return "xtend2:[" + this.myXtendGenerator.getSimpleName() + "#" + this.myMethodName + "]";
    }

    protected Object extractTarget(Object[] arguments) {
        assert (arguments != null && arguments.length > 0);
        return arguments[0];
    }

    protected Injector getInjector() {
        return this.myInjector;
    }

    protected Class<?> getTemplateClass() {
        return this.myXtendGenerator;
    }
}

