/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.codegen.ecore.ui.EmptyProjectWizard;
import org.eclipse.gmf.internal.bridge.ui.Plugin;
import org.eclipse.gmf.internal.bridge.wizards.pages.ShowDashboardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class NewGMFProjectWizard
extends EmptyProjectWizard {
    private static final String SD_PROPERTY = "show_dashboard";
    private boolean showDashboard = Plugin.getDefault().getPreferenceStore().getBoolean("show_dashboard");
    private ShowDashboardPage sdp;
    private String initialProjectName;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(Plugin.getBundleString("newProjectWizard.name"));
    }

    public void addPages() {
        super.addPages();
        WizardNewProjectCreationPage page = (WizardNewProjectCreationPage)this.getPage("NewProjectCreationPage");
        if (page != null) {
            page.setInitialProjectName(this.initialProjectName);
            page.setDescription(Plugin.getBundleString("newProjectWizard.desc"));
            page.setTitle(Plugin.getBundleString("newProjectWizard.name"));
        }
        this.sdp = new ShowDashboardPage("Show Dashboard", this.showDashboard);
        this.sdp.setTitle(Plugin.getBundleString("showDashboardPage.name"));
        this.sdp.setDescription(Plugin.getBundleString("showDashboardPage.desc"));
        this.addPage((IWizardPage)this.sdp);
    }

    public void setShowDashboard(boolean showDashboard) {
        this.showDashboard = showDashboard;
    }

    public boolean performFinish() {
        this.showDashboard = this.sdp.isShowDashboard();
        Plugin.getDefault().getPreferenceStore().setValue(SD_PROPERTY, this.showDashboard);
        boolean created = super.performFinish();
        if (!created) {
            return false;
        }
        if (this.showDashboard) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    NewGMFProjectWizard.this.openDashboardView();
                }
            });
        }
        return created;
    }

    protected void openDashboardView() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && window.getActivePage() != null) {
            try {
                window.getActivePage().showView("org.eclipse.gmf.bridge.ui.dashboard.DashboardPart");
            }
            catch (PartInitException e) {
                Plugin.log((CoreException)e);
            }
        }
    }

    public void setInitialProjectName(String initialProjectName) {
        this.initialProjectName = initialProjectName;
    }
}

