/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.common.util.StringUtil;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEnginePool;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.introspection.java.SimulinkPropertyGetter;
import org.eclipse.epsilon.emc.simulink.introspection.java.SimulinkPropertySetter;
import org.eclipse.epsilon.emc.simulink.model.IGenericSimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.types.CellStr;
import org.eclipse.epsilon.emc.simulink.types.Complex;
import org.eclipse.epsilon.emc.simulink.types.HandleObject;
import org.eclipse.epsilon.emc.simulink.types.Struct;
import org.eclipse.epsilon.emc.simulink.util.MatlabEngineUtil;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolEnumerationValueNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.models.CachedModel;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.IRelativePathResolver;

public abstract class AbstractSimulinkModel
extends CachedModel<ISimulinkModelElement>
implements IGenericSimulinkModel {
    public static final String PROPERTY_WORKING_DIR = "working_dir";
    public static final String PROPERTY_PATHS = "paths";
    public static final String PROPERTY_FILE = "file";
    public static final String PROPERTY_MATLAB_PATH = "matlab_path";
    public static final String PROPERTY_LIBRARY_PATH = "library_path";
    public static final String PROPERTY_ENGINE_JAR_PATH = "engine_jar_path";
    public static final String PROPERTY_SIMULINK_PROJECT = "project";
    public static final String PROPERTY_OPEN_ON_LOAD = "openOnLoad";
    public static final String PROPERTY_CLOSE_ON_DISPOSE = "closeOnDispose";
    public static final String PROPERTY_ENABLE_TRY_CATCH = "tryCatch";
    public static final String PROPERTY_CURRENT_SIMULINK_PROJECT = "use_current_project";
    public static final String PROPERTY_ENGINE_POOL_SIZE = "engine_max_pool_size";
    public static final String PROPERTY_TRACK_API = "track_API";
    public static final String PROPERTY_REDUCE_EXCHANGES = "reduce_matlab_exchanges";
    public static final String ENV_MATLAB_PATH = "org.eclipse.epsilon.emc.matlab_path";
    public static final String ENV_LIBRARY_PATH = "org.eclipse.epsilon.emc.library_path";
    public static final String ENV_ENGINE_JAR_PATH = "org.eclipse.epsilon.emc.engine_jar_path";
    protected File file;
    protected String matlabPath;
    protected String libraryPath;
    protected String engineJarPath;
    protected MatlabEngine engine;
    protected File simulinkProject;
    protected boolean useCurrentProject = false;
    protected boolean openOnLoad = false;
    protected boolean closeOnDispose = false;
    protected boolean enableTryCatch = true;
    protected Integer enginePoolSize = 2;
    boolean trackApi = false;
    protected File workingDir = null;
    protected List<String> paths = new ArrayList<String>();
    protected boolean reduceExchanges = false;

    public AbstractSimulinkModel() {
        this.propertyGetter = new SimulinkPropertyGetter();
        this.propertySetter = new SimulinkPropertySetter();
    }

    public void flush() throws EolRuntimeException {
        if (this.engine != null) {
            try {
                this.engine.flush();
            }
            catch (Exception e) {
                throw new EolRuntimeException((Throwable)e);
            }
        }
    }

    protected void loadModel() throws EolModelLoadingException {
        try {
            this.resolvePaths();
            if (this.isUseCurrentProject().booleanValue()) {
                this.engine = MatlabEnginePool.getInstance().getEngineForProject("current");
                this.engine.trackApi(this.trackApi);
                this.engine.enableTryCatch(this.isEnableTryCatch());
                this.engine.addModel(this);
            } else if (this.getProject() != null && this.getProject().exists()) {
                try {
                    this.engine = MatlabEnginePool.getInstance().getEngineForProject(this.getProject().getAbsolutePath());
                    this.engine.addModel(this);
                }
                catch (Exception ex) {
                    throw new EolModelLoadingException(ex, (IModel)this);
                }
            }
            if (this.engine == null) {
                this.engine = MatlabEnginePool.getInstance().getMatlabEngine();
                this.engine.enableTryCatch(this.isEnableTryCatch());
                this.engine.trackApi(this.trackApi);
            }
            if (!this.isUseCurrentProject().booleanValue() && this.getProject() == null && this.getWorkingDir() != null && this.getWorkingDir().exists()) {
                try {
                    this.engine.eval("cd '?';", this.getWorkingDir());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            for (String path : this.getPaths()) {
                this.engine.eval("addpath ?", path);
            }
            this.engine.setReduceExchanges(this.reduceExchanges);
        }
        catch (Exception e) {
            throw new EolModelLoadingException(e, (IModel)this);
        }
    }

    protected void disposeModel() {
        if (this.isCloseOnDispose().booleanValue()) {
            this.closeMatlabModel();
        }
        try {
            if (this.isReduceExchanges() && !this.engine.isEvalCommandQueueEmpty()) {
                throw new IllegalStateException("There were MATLAB commands that were not submitted during the execution! \n When enabling the \"reduce MATLAB exchanges\" option in the Simulink model, you must ensure to call the `ModelName.flush()` method in the model at the end of the execution, e.g. within a post{} block.");
            }
            this.engine.release(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract void closeMatlabModel();

    protected Object getCacheKeyForType(String type) throws EolModelElementTypeNotFoundException {
        return type;
    }

    protected Collection<String> getAllTypeNamesOf(Object instance) {
        if (instance instanceof ISimulinkModelElement) {
            return ((ISimulinkModelElement)instance).getAllTypeNamesOf();
        }
        return Arrays.asList(this.getTypeNameOf(instance));
    }

    public Object getEnumerationValue(String enumeration, String label) throws EolEnumerationValueNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public MatlabEngine getEngine() {
        return this.engine;
    }

    public void setEngine(MatlabEngine engine) {
        this.engine = engine;
    }

    @Override
    public String getLibraryPath() {
        return this.libraryPath;
    }

    @Override
    public void setLibraryPath(String libraryPath) {
        this.libraryPath = libraryPath;
    }

    @Override
    public String getEngineJarPath() {
        return this.engineJarPath;
    }

    @Override
    public void setEngineJarPath(String engineJarPath) {
        this.engineJarPath = engineJarPath;
    }

    @Override
    public String getMatlabPath() {
        return this.matlabPath;
    }

    @Override
    public void setMatlabPath(String matlabPath) {
        this.matlabPath = matlabPath;
    }

    @Override
    public void setTrackApi(boolean track) {
        this.trackApi = track;
    }

    @Override
    public boolean isTrackApi() {
        return this.trackApi;
    }

    @Override
    public File getProject() {
        return this.simulinkProject;
    }

    @Override
    public void setProject(String simulinkProject) {
        this.simulinkProject = new File(simulinkProject);
    }

    public void setProject(File simulinkProject) {
        this.simulinkProject = simulinkProject;
    }

    @Override
    public Boolean isUseCurrentProject() {
        return this.useCurrentProject;
    }

    @Override
    public void setUseCurrentProject(Boolean currentSimulinkProject) {
        this.useCurrentProject = currentSimulinkProject;
    }

    @Override
    public void setCloseOnDispose(Boolean closeOnDispose) {
        this.closeOnDispose = closeOnDispose;
    }

    @Override
    public void setOpenOnLoad(Boolean openOnLoad) {
        this.openOnLoad = openOnLoad;
    }

    @Override
    public Boolean isCloseOnDispose() {
        return this.closeOnDispose;
    }

    @Override
    public Boolean isOpenOnLoad() {
        return this.openOnLoad;
    }

    public void setEnableTryCatch(boolean enableTryCatch) {
        this.enableTryCatch = enableTryCatch;
    }

    public boolean isEnableTryCatch() {
        return this.enableTryCatch;
    }

    public Object parseMatlabEngineVariable(String variableName) throws MatlabException {
        return MatlabEngineUtil.parseMatlabEngineVariable(this.engine, variableName);
    }

    public void statement(String statement) throws EolRuntimeException {
        try {
            this.engine.eval(statement);
        }
        catch (MatlabException e) {
            throw new EolRuntimeException(e.getMessage());
        }
    }

    public Object statementWithResult(String statement) throws EolRuntimeException {
        try {
            return this.engine.evalWithResult(statement);
        }
        catch (MatlabException e) {
            throw new EolRuntimeException(e.getMessage());
        }
    }

    public Object getWorkspaceVariable(String value) {
        try {
            return MatlabEngineUtil.parseMatlabEngineVariable(this.engine, value);
        }
        catch (MatlabException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean owns(Object instance) {
        return instance instanceof Struct || instance instanceof Complex || instance instanceof HandleObject || instance instanceof CellStr;
    }

    public boolean isInstantiable(String type) {
        return Arrays.asList("Struct", "Complex", "CellStr").contains(type);
    }

    protected ISimulinkModelElement createInstanceInModel(String type) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        switch (type) {
            case "Struct": {
                return new Struct(this.getEngine());
            }
            case "Complex": {
                return new Complex(this.getEngine());
            }
            case "CellStr": {
                return new CellStr(this.getEngine());
            }
        }
        throw new EolModelElementTypeNotFoundException(this.getName(), type);
    }

    public void load(StringProperties properties, IRelativePathResolver resolver) throws EolModelLoadingException {
        String project;
        super.load(properties, resolver);
        String workingDirPath = properties.getProperty(PROPERTY_WORKING_DIR);
        String filePath = properties.getProperty(PROPERTY_FILE);
        if (filePath != null && filePath.trim().length() > 0) {
            this.setFile(new File(resolver.resolve(filePath)));
        }
        if (!StringUtil.isEmpty((String)workingDirPath)) {
            this.setWorkingDir(new File(resolver.resolve(workingDirPath)));
        } else {
            this.setWorkingDir(new File(resolver.resolve(filePath)).getParentFile());
        }
        String paths = properties.getProperty(PROPERTY_PATHS);
        if (!StringUtil.isEmpty((String)paths)) {
            Arrays.stream(paths.trim().split(";")).forEach(this::addPath);
        }
        if ((project = properties.getProperty(PROPERTY_SIMULINK_PROJECT, "")) != null && project.trim().length() > 0) {
            this.setProject(new File(resolver.resolve(project)));
        }
        this.setUseCurrentProject(properties.getBooleanProperty(PROPERTY_CURRENT_SIMULINK_PROJECT, false));
        this.setOpenOnLoad(properties.getBooleanProperty(PROPERTY_OPEN_ON_LOAD, false));
        this.setCloseOnDispose(properties.getBooleanProperty(PROPERTY_CLOSE_ON_DISPOSE, false));
        this.setEnableTryCatch(properties.getBooleanProperty(PROPERTY_ENABLE_TRY_CATCH, true));
        this.setReduceExchanges(properties.getBooleanProperty(PROPERTY_REDUCE_EXCHANGES, this.reduceExchanges));
        this.setMatlabPath(properties.getProperty(PROPERTY_MATLAB_PATH, this.matlabPath));
        this.setLibraryPath(properties.getProperty(PROPERTY_LIBRARY_PATH, this.libraryPath));
        this.setEngineJarPath(properties.getProperty(PROPERTY_ENGINE_JAR_PATH, this.engineJarPath));
        this.resolvePaths();
    }

    public boolean isLoaded() {
        return this.file != null && this.engine != null;
    }

    @Override
    public File getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    @Override
    public void addPath(String path) {
        this.paths.add(path);
    }

    @Override
    public void addPath(File path) {
        this.paths.add(path.getAbsolutePath());
    }

    @Override
    public List<String> getPaths() {
        return this.paths;
    }

    protected boolean resolvePaths() {
        String[] allPaths = new String[]{this.matlabPath, this.libraryPath, this.engineJarPath};
        MatlabEngineUtil.resolvePaths(allPaths);
        this.matlabPath = allPaths[0];
        this.libraryPath = allPaths[1];
        this.engineJarPath = allPaths[2];
        return MatlabEnginePool.resolve(this.libraryPath, this.engineJarPath);
    }

    public boolean isReduceExchanges() {
        return this.reduceExchanges;
    }

    public void setReduceExchanges(boolean reduceExchanges) {
        this.reduceExchanges = reduceExchanges;
    }
}

