/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPointException;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.ui.Activator;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.CommitDialogTray;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.EMFStoreTitleAreaDialog;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.Messages;
import org.eclipse.emf.emfstore.internal.client.ui.views.changes.TabbedChangesComposite;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CommitDialog
extends EMFStoreTitleAreaDialog
implements KeyListener {
    private static final String COMMITDIALOG_TRAY_EXTENSION_POINT = "org.eclipse.emf.emfstore.client.ui.commitdialog.tray";
    private Text txtLogMsg;
    private String logMsg = "";
    private final AbstractChangePackage changes;
    private EList<String> oldLogMessages;
    private final ProjectSpace activeProjectSpace;
    private final Map<String, CommitDialogTray> trays;
    private Image commitImage;
    private final int numberOfChanges;
    private final ModelElementIdToEObjectMapping idToEObjectMapping;
    private TabbedChangesComposite changesComposite;

    public CommitDialog(Shell parentShell, AbstractChangePackage localChangePackage, ProjectSpace activeProjectSpace, ModelElementIdToEObjectMapping idToEObjectMapping) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.idToEObjectMapping = idToEObjectMapping;
        this.changes = localChangePackage;
        this.activeProjectSpace = activeProjectSpace;
        this.numberOfChanges = localChangePackage.size();
        this.trays = new LinkedHashMap<String, CommitDialogTray>();
        for (ESExtensionElement element : new ESExtensionPoint(COMMITDIALOG_TRAY_EXTENSION_POINT, true).getExtensionElements()) {
            try {
                CommitDialogTray tray = (CommitDialogTray)((Object)element.getClass("class", CommitDialogTray.class));
                String name = element.getAttribute("name");
                tray.init(this);
                this.trays.put(name, tray);
            }
            catch (ESExtensionPointException eSExtensionPointException) {}
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.CommitDialog_Commit);
        this.commitImage = Activator.getImageDescriptor("icons/arrow_right.png").createImage();
        newShell.setImage(this.commitImage);
    }

    protected Control createDialogArea(Composite parent) {
        this.oldLogMessages = this.activeProjectSpace.getOldLogMessages();
        Composite contents = new Composite(parent, 0);
        contents.setLayoutData((Object)new GridData(4, 4, true, true));
        contents.setLayout((Layout)new GridLayout(2, false));
        String projectName = "";
        if (this.activeProjectSpace.getProjectName() != null && this.activeProjectSpace.getProjectName().length() > 0) {
            projectName = String.valueOf(Messages.CommitDialog_OfProject) + "\"" + this.activeProjectSpace.getProjectName() + "\" ";
        }
        this.setTitle(String.valueOf(Messages.CommitDialog_CommitLocalChanges) + projectName + Messages.CommitDialog_ToServer);
        this.setMessage(String.valueOf(Messages.CommitDialog_NumberOfCompositeChanges) + this.numberOfChanges + ", " + Messages.CommitDialog_NumberOverallChanges + this.numberOfChanges);
        Label lblLogMsg = new Label(contents, 0);
        lblLogMsg.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        lblLogMsg.setText(Messages.CommitDialog_LogMessage);
        this.createLogMessageText(contents);
        Label oldLabel = new Label(contents, 0);
        oldLabel.setText(Messages.CommitDialog_PreviousMessage);
        final Combo oldMsg = new Combo(contents, 8);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)oldMsg);
        ArrayList<String> oldLogMessagesCopy = new ArrayList<String>();
        oldLogMessagesCopy.addAll((Collection<String>)this.oldLogMessages);
        Collections.reverse(oldLogMessagesCopy);
        oldMsg.setItems(oldLogMessagesCopy.toArray(new String[0]));
        oldMsg.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CommitDialog.this.txtLogMsg.setText(oldMsg.getItem(oldMsg.getSelectionIndex()));
            }
        });
        if (this.oldLogMessages.size() > 0) {
            oldMsg.select(0);
        }
        ArrayList<AbstractChangePackage> changePackages = new ArrayList<AbstractChangePackage>();
        changePackages.add(this.changes);
        this.changesComposite = new TabbedChangesComposite(contents, 2048, changePackages, this.getActiveProjectSpace().getProject(), this.idToEObjectMapping, true);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo((Control)this.changesComposite);
        return contents;
    }

    public ProjectSpace getActiveProjectSpace() {
        return this.activeProjectSpace;
    }

    private void createLogMessageText(Composite contents) {
        this.txtLogMsg = new Text(contents, 18434);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).align(4, 128).hint(this.convertHorizontalDLUsToPixels(1), this.convertVerticalDLUsToPixels(45)).applyTo((Control)this.txtLogMsg);
        String logMsg = "";
        LogMessage logMessage = this.changes.getLogMessage();
        logMsg = this.oldLogMessages.size() == 0 ? logMessage.getMessage() : (String)this.oldLogMessages.get(this.oldLogMessages.size() - 1);
        this.txtLogMsg.setText(logMsg);
        this.txtLogMsg.selectAll();
        this.txtLogMsg.addKeyListener((KeyListener)this);
    }

    protected void okPressed() {
        this.logMsg = this.txtLogMsg.getText();
        for (CommitDialogTray t : this.trays.values()) {
            t.okPressed();
        }
        super.okPressed();
    }

    public boolean close() {
        this.commitImage.dispose();
        this.changesComposite.dispose();
        return super.close();
    }

    public String getLogText() {
        return this.logMsg.equals("") ? Messages.CommitDialog_EmptyMessage : this.logMsg;
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 13 && (e.stateMask & SWT.MOD1) != 0) {
            this.okPressed();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    protected void createButtonsForButtonBar(Composite parent) {
        for (ESExtensionElement c : new ESExtensionPoint(COMMITDIALOG_TRAY_EXTENSION_POINT).getExtensionElements()) {
            final String name = c.getAttribute("name");
            final CommitDialogTray tray = this.trays.get(name);
            if (tray == null) continue;
            final Button notificationsButton = this.createButton(parent, 2138, String.valueOf(name) + " >>", false);
            notificationsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
                private boolean isOpen;

                public void widgetSelected(SelectionEvent e) {
                    if (!this.isOpen) {
                        CommitDialog.this.openTray(tray);
                        notificationsButton.setText(String.valueOf(name) + " <<");
                        Rectangle bounds = CommitDialog.this.getShell().getBounds();
                        bounds.x -= CommitDialog.this.convertHorizontalDLUsToPixels(100);
                        CommitDialog.this.getShell().setBounds(bounds);
                    } else {
                        CommitDialog.this.closeTray();
                        notificationsButton.setText(String.valueOf(name) + " >>");
                        Rectangle bounds = CommitDialog.this.getShell().getBounds();
                        bounds.x += CommitDialog.this.convertHorizontalDLUsToPixels(100);
                        CommitDialog.this.getShell().setBounds(bounds);
                    }
                    this.isOpen = !this.isOpen;
                }
            });
        }
        super.createButtonsForButtonBar(parent);
    }
}

