/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.mongodb;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;

public final class MongoDBConfiguration {
    public static final MongoDBConfiguration INSTANCE = new MongoDBConfiguration();
    public static final String HOST_NAME = "emfstore.mongodb.hostName";
    public static final String PORT = "emfstore.mongodb.port";
    private static Properties properties;
    private static final String PROPERTIES_FILE_NAME = "mongodb.properties";

    private MongoDBConfiguration() {
        properties = this.initProperties();
    }

    private Properties initProperties() {
        File propertyFile = new File(String.valueOf(ServerConfiguration.getConfDirectory()) + File.separator + PROPERTIES_FILE_NAME);
        if (!propertyFile.exists() && !this.dropPropertiesFileToHardDrive(propertyFile)) {
            ModelUtil.logWarning((String)"MongoDB property initialization failed, using default properties.");
            return null;
        }
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(propertyFile);
                properties.load(fis);
            }
            catch (IOException iOException) {
                ModelUtil.logWarning((String)"MongoDB property initialization failed, using default properties.");
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException2) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (IOException iOException) {}
        return properties;
    }

    private boolean dropPropertiesFileToHardDrive(File targetFile) {
        try {
            FileUtil.copyFile((InputStream)this.getClass().getResourceAsStream(PROPERTIES_FILE_NAME), (File)targetFile);
        }
        catch (IOException iOException) {
            ModelUtil.logWarning((String)"Copying MongoDB property file to configuration folder failed");
            return false;
        }
        return true;
    }

    public String getMongoURIPrefix() {
        if (properties == null) {
            return this.getDefaultMongoURIPrefix();
        }
        String hostName = properties.getProperty(HOST_NAME);
        String port = properties.getProperty(PORT);
        if (hostName == null || hostName.equals("")) {
            return this.getDefaultMongoURIPrefix();
        }
        String prefix = "mongodb://" + hostName;
        if (port != null && !port.equals("")) {
            prefix = String.valueOf(prefix) + ":" + port;
        }
        prefix = String.valueOf(prefix) + "/";
        return prefix;
    }

    private String getDefaultMongoURIPrefix() {
        return "mongodb://localhost/";
    }
}

