/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.test.common.util;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESRemoteProject;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.ESWorkspaceProvider;
import org.eclipse.emf.emfstore.client.callbacks.ESCommitCallback;
import org.eclipse.emf.emfstore.client.callbacks.ESUpdateCallback;
import org.eclipse.emf.emfstore.client.test.common.TestConflictResolver;
import org.eclipse.emf.emfstore.client.test.common.dsl.CreateAPI;
import org.eclipse.emf.emfstore.client.test.common.util.Times;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.ConflictResolver;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.ChangeConflictException;
import org.eclipse.emf.emfstore.internal.client.model.impl.ProjectSpaceBase;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.SerializationException;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidVersionSpecException;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.versionspec.ESPrimaryVersionSpecImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.exceptions.ESUpdateRequiredException;
import org.eclipse.emf.emfstore.server.model.ESGlobalProjectId;
import org.eclipse.emf.emfstore.server.model.versionspec.ESPrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versionspec.ESTagVersionSpec;
import org.eclipse.emf.emfstore.server.model.versionspec.ESVersionSpec;
import org.eclipse.emf.emfstore.test.model.TestElement;

public class ProjectUtil {
    private static final String NONAME = "NONAME";
    private static final String LOGMESSAGE = "LOGMESSAGE";
    private static final String DEFAULT_NAME = "TestProject";

    public static IProgressMonitor nullProgressMonitor() {
        return new NullProgressMonitor();
    }

    public static String defaultName() {
        return DEFAULT_NAME;
    }

    public static ESLocalProject cloneProject(final ESLocalProject localProject) {
        return (ESLocalProject)RunESCommand.runWithResult((Callable)new Callable<ESLocalProject>(){

            @Override
            public ESLocalProject call() throws Exception {
                ProjectSpace projectSpace = (ProjectSpace)((ESLocalProjectImpl)localProject).toInternalAPI();
                Project clonedProject = (Project)ModelUtil.clone((EObject)projectSpace.getProject());
                ProjectSpace clonedProjectSpace = (ProjectSpace)ModelUtil.clone((EObject)projectSpace);
                clonedProjectSpace.setProject(clonedProject);
                return (ESLocalProject)clonedProjectSpace.toAPI();
            }
        });
    }

    public static ESLocalProject clearModelElements(final ESLocalProject localProject) {
        return (ESLocalProject)RunESCommand.runWithResult((Callable)new Callable<ESLocalProject>(){

            @Override
            public ESLocalProject call() throws Exception {
                localProject.getModelElements().clear();
                return localProject;
            }
        });
    }

    public static ESLocalProject clearOperations(ESLocalProject localProject) {
        final ProjectSpaceBase projectSpace = (ProjectSpaceBase)((ESLocalProjectImpl)localProject).toInternalAPI();
        RunESCommand.run((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                projectSpace.getLocalChangePackage().clear();
                projectSpace.getOperationManager().clearOperations();
                return null;
            }
        });
        return localProject;
    }

    public static void deleteRemoteProjects(ESServer server, ESUsersession usersession) throws IOException, FatalESException, ESException {
        for (ESRemoteProject project : server.getRemoteProjects(usersession)) {
            project.delete(usersession, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static void deleteLocalProjects() throws IOException, ESException {
        ProjectUtil.deleteLocalProjects((IProgressMonitor)new NullProgressMonitor());
    }

    public static void rename(final ESLocalProject localProject, final String name) {
        RunESCommand.run((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestElement testElement = (TestElement)localProject.getModelElements().get(0);
                testElement.setName(name);
                return null;
            }
        });
    }

    public static void deleteLocalProjects(IProgressMonitor monitor) throws IOException, ESException {
        for (ESLocalProject lp : ESWorkspaceProvider.INSTANCE.getWorkspace().getLocalProjects()) {
            lp.delete(monitor);
        }
    }

    public static ESLocalProject addElement(final ESLocalProject localProject, final EObject modelElement) {
        return (ESLocalProject)RunESCommand.runWithResult((Callable)new Callable<ESLocalProject>(){

            @Override
            public ESLocalProject call() throws Exception {
                localProject.getModelElements().add((Object)modelElement);
                return localProject;
            }
        });
    }

    public static ESLocalProject removeModelElement(final ESLocalProject localProject, final EObject modelElement) {
        return (ESLocalProject)RunESCommand.runWithResult((Callable)new Callable<ESLocalProject>(){

            @Override
            public ESLocalProject call() throws Exception {
                localProject.getModelElements().remove((Object)modelElement);
                return localProject;
            }
        });
    }

    public static ESLocalProject revert(final ESLocalProject localProject) {
        return (ESLocalProject)RunESCommand.runWithResult((Callable)new Callable<ESLocalProject>(){

            @Override
            public ESLocalProject call() throws Exception {
                localProject.revert();
                return localProject;
            }
        });
    }

    public static long computeChecksum(ESLocalProject localProject) throws SerializationException {
        ProjectSpace projectSpace = (ProjectSpace)((ESLocalProjectImpl)localProject).toInternalAPI();
        long checksum = ModelUtil.computeChecksum((IdEObjectCollection)projectSpace.getProject());
        System.out.println(ModelUtil.eObjectToString((EObject)projectSpace.getProject()));
        return checksum;
    }

    public static ESLocalProject update(ESLocalProject localProject, ESVersionSpec version) throws ChangeConflictException, ESException {
        localProject.update(version, null, ProjectUtil.nullProgressMonitor());
        return localProject;
    }

    public static ESLocalProject update(ESLocalProject localProject) throws ChangeConflictException, ESException {
        localProject.update(ProjectUtil.nullProgressMonitor());
        return localProject;
    }

    public static ESLocalProject update(ESLocalProject localProject, ESUpdateCallback updateCallback) throws ChangeConflictException, ESException {
        localProject.update((ESVersionSpec)ESVersionSpec.FACTORY.createHEAD(), updateCallback, ProjectUtil.nullProgressMonitor());
        return localProject;
    }

    protected ESLocalProject reCheckout(ESLocalProject localProject) {
        return (ESLocalProject)RunESCommand.runWithResult((Callable)new Callable<ESLocalProject>(){

            @Override
            public ESLocalProject call() throws Exception {
                return null;
            }
        });
    }

    public static ESLocalProject commit(ESLocalProject localProject) throws ESException {
        localProject.commit(ProjectUtil.nullProgressMonitor());
        return localProject;
    }

    public static ESLocalProject checkout(final ESLocalProject localProject) throws ESException {
        return (ESLocalProject)RunESCommand.WithException.runWithResult(ESException.class, (Callable)new Callable<ESLocalProject>(){

            @Override
            public ESLocalProject call() throws Exception {
                return localProject.getRemoteProject().checkout(ProjectUtil.NONAME, localProject.getUsersession(), localProject.getBaseVersion(), (IProgressMonitor)new NullProgressMonitor());
            }
        });
    }

    public static ESLocalProject checkout(final ESLocalProject localProject, final ESPrimaryVersionSpec versionSpec) {
        return (ESLocalProject)RunESCommand.runWithResult((Callable)new Callable<ESLocalProject>(){

            @Override
            public ESLocalProject call() throws Exception {
                return localProject.getRemoteProject().checkout(ProjectUtil.NONAME, localProject.getUsersession(), versionSpec, (IProgressMonitor)new NullProgressMonitor());
            }
        });
    }

    public static ESLocalProject commitToBranch(ESLocalProject localProject, String branch) throws InvalidVersionSpecException, ESUpdateRequiredException, ESException {
        localProject.commitToBranch(CreateAPI.branchVersionSpec(branch), "", null, ProjectUtil.nullProgressMonitor());
        return localProject;
    }

    public static ESLocalProject tag(ESLocalProject localProject, ESPrimaryVersionSpec versionSpec, String branchName, String tag) throws ESException {
        ESTagVersionSpec tagVersionSpec = CreateAPI.tagVersionSpec(branchName, tag);
        localProject.addTag(versionSpec, tagVersionSpec, ProjectUtil.nullProgressMonitor());
        return localProject;
    }

    public static ESGlobalProjectId share(ESUsersession session, ESLocalProject localProject) throws ESException {
        ESRemoteProject shareProject = localProject.shareProject(session, (IProgressMonitor)new NullProgressMonitor());
        return shareProject.getGlobalProjectId();
    }

    public static ESLocalProject mergeWithBranch(final ESLocalProject trunk, final ESPrimaryVersionSpec latestOnBranch, final int expectedConflicts) {
        return (ESLocalProject)RunESCommand.runWithResult((Callable)new Callable<ESLocalProject>(){

            @Override
            public ESLocalProject call() throws Exception {
                ((ProjectSpace)((ESLocalProjectImpl)trunk).toInternalAPI()).mergeBranch((PrimaryVersionSpec)((ESPrimaryVersionSpecImpl)latestOnBranch).toInternalAPI(), (ConflictResolver)new TestConflictResolver(true, expectedConflicts), (IProgressMonitor)new NullProgressMonitor());
                return trunk;
            }
        });
    }

    public static Times addAndCommit(ESLocalProject localProject) {
        return new Times(localProject);
    }

    public static ESLocalProject branch(final ESLocalProject localProject, final String branchName) {
        return (ESLocalProject)RunESCommand.runWithResult((Callable)new Callable<ESLocalProject>(){

            @Override
            public ESLocalProject call() throws Exception {
                localProject.commitToBranch(ESVersionSpec.FACTORY.createBRANCH(branchName), ProjectUtil.LOGMESSAGE, ESCommitCallback.NOCALLBACK, (IProgressMonitor)new NullProgressMonitor());
                return localProject;
            }
        });
    }

    public static ESLocalProject stopRecording(final ESLocalProject localProject) {
        return (ESLocalProject)RunESCommand.runWithResult((Callable)new Callable<ESLocalProject>(){

            @Override
            public ESLocalProject call() throws Exception {
                ProjectSpace projectSpace = (ProjectSpace)((ESLocalProjectImpl)localProject).toInternalAPI();
                projectSpace.getOperationManager().stopChangeRecording();
                return (ESLocalProject)projectSpace.toAPI();
            }
        });
    }

    public static ESLocalProject startRecording(final ESLocalProject localProject) {
        return (ESLocalProject)RunESCommand.runWithResult((Callable)new Callable<ESLocalProject>(){

            @Override
            public ESLocalProject call() throws Exception {
                ProjectSpace projectSpace = (ProjectSpace)((ESLocalProjectImpl)localProject).toInternalAPI();
                projectSpace.getOperationManager().startChangeRecording();
                return (ESLocalProject)projectSpace.toAPI();
            }
        });
    }

    public static ESPrimaryVersionSpec getMergedVersion(ESLocalProject localProject) {
        ESLocalProjectImpl projectImpl = (ESLocalProjectImpl)ESLocalProjectImpl.class.cast(localProject);
        PrimaryVersionSpec mergedVersion = ((ProjectSpace)projectImpl.toInternalAPI()).getMergedVersion();
        if (mergedVersion == null) {
            return null;
        }
        return (ESPrimaryVersionSpec)mergedVersion.toAPI();
    }
}

