/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.test.persistence;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESProject;
import org.eclipse.emf.emfstore.client.test.common.cases.ESTest;
import org.eclipse.emf.emfstore.client.test.common.dsl.Create;
import org.eclipse.emf.emfstore.client.test.common.util.ProjectUtil;
import org.eclipse.emf.emfstore.internal.client.importexport.ExportImportControllerExecutor;
import org.eclipse.emf.emfstore.internal.client.importexport.ExportImportControllerFactory;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ExportImportDataUnits;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.test.model.TestElement;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ImportExportTest
extends ESTest {
    private File temp;

    @After
    public void after() {
        if (this.temp != null) {
            FileUtils.deleteQuietly((File)this.temp);
            this.temp = null;
        }
        super.after();
    }

    @Test
    public void testExportImportChangesController() throws IOException {
        ProjectSpace clonedProjectSpace = (ProjectSpace)ModelUtil.clone((EObject)this.getProjectSpace());
        TestElement testElement = Create.testElement((String)"A");
        ProjectUtil.addElement((ESLocalProject)this.getLocalProject(), (EObject)testElement);
        Assert.assertTrue((this.getProjectSpace().getOperations().size() > 0 ? 1 : 0) != 0);
        this.temp = File.createTempFile("changes", ExportImportDataUnits.Change.getExtension());
        new ExportImportControllerExecutor(this.temp, (IProgressMonitor)new NullProgressMonitor()).execute(ExportImportControllerFactory.Export.getExportChangesController((ProjectSpace)this.getProjectSpace()));
        new ExportImportControllerExecutor(this.temp, (IProgressMonitor)new NullProgressMonitor()).execute(ExportImportControllerFactory.Import.getImportChangesController((ProjectSpace)clonedProjectSpace));
        Assert.assertTrue((boolean)ModelUtil.areEqual((IdEObjectCollection)this.getProjectSpace().getProject(), (IdEObjectCollection)clonedProjectSpace.getProject()));
    }

    @Test
    public void testExportImportProjectController() throws IOException {
        TestElement testElement = Create.testElement((String)"A");
        ProjectUtil.addElement((ESLocalProject)this.getLocalProject(), (EObject)testElement);
        Assert.assertTrue((this.getProjectSpace().getOperations().size() > 0 ? 1 : 0) != 0);
        this.temp = File.createTempFile("project", ExportImportDataUnits.Project.getExtension());
        new ExportImportControllerExecutor(this.temp, (IProgressMonitor)new NullProgressMonitor()).execute(ExportImportControllerFactory.Export.getExportProjectController((ProjectSpace)this.getProjectSpace()));
        new ExportImportControllerExecutor(this.temp, (IProgressMonitor)new NullProgressMonitor()).execute(ExportImportControllerFactory.Import.getImportProjectController((String)"importedProject"));
        ProjectSpace newProjectSpace = null;
        for (ESProject project : ESWorkspaceProviderImpl.getInstance().getWorkspace().getLocalProjects()) {
            if (!project.getProjectName().equals("importedProject")) continue;
            newProjectSpace = this.getProjectSpace();
            break;
        }
        Assert.assertTrue((newProjectSpace != null ? 1 : 0) != 0);
    }

    @Test
    public void testDuplicateImportOfProjectSpace() throws IOException {
        this.temp = File.createTempFile("projectSpace", ExportImportDataUnits.ProjectSpace.getExtension());
        new ExportImportControllerExecutor(this.temp, (IProgressMonitor)new NullProgressMonitor()).execute(ExportImportControllerFactory.Export.getExportProjectSpaceController((ProjectSpace)this.getProjectSpace()));
        new ExportImportControllerExecutor(this.temp, (IProgressMonitor)new NullProgressMonitor()).execute(ExportImportControllerFactory.Import.getImportProjectSpaceController());
        new ExportImportControllerExecutor(this.temp, (IProgressMonitor)new NullProgressMonitor()).execute(ExportImportControllerFactory.Import.getImportProjectSpaceController());
        Assert.assertEquals((long)3L, (long)ESWorkspaceProviderImpl.getInstance().getWorkspace().getLocalProjects().size());
        ProjectSpace projectSpace = (ProjectSpace)ESWorkspaceProviderImpl.getInstance().getInternalWorkspace().getProjectSpaces().get(1);
        ProjectSpace projectSpace2 = (ProjectSpace)ESWorkspaceProviderImpl.getInstance().getInternalWorkspace().getProjectSpaces().get(2);
        Assert.assertFalse((boolean)projectSpace.getIdentifier().equals(projectSpace2.getIdentifier()));
    }

    @Test
    public void testExportImportProjectSpaceController() throws IOException {
        TestElement testElement = Create.testElement((String)"A");
        ProjectUtil.addElement((ESLocalProject)this.getLocalProject(), (EObject)testElement);
        Assert.assertTrue((this.getProjectSpace().getOperations().size() > 0 ? 1 : 0) != 0);
        this.temp = File.createTempFile("projectSpace", ExportImportDataUnits.ProjectSpace.getExtension());
        new ExportImportControllerExecutor(this.temp, (IProgressMonitor)new NullProgressMonitor()).execute(ExportImportControllerFactory.Export.getExportProjectSpaceController((ProjectSpace)this.getProjectSpace()));
        Assert.assertEquals((long)1L, (long)ESWorkspaceProviderImpl.getInstance().getWorkspace().getLocalProjects().size());
        new ExportImportControllerExecutor(this.temp, (IProgressMonitor)new NullProgressMonitor()).execute(ExportImportControllerFactory.Import.getImportProjectSpaceController());
        Assert.assertEquals((long)2L, (long)ESWorkspaceProviderImpl.getInstance().getWorkspace().getLocalProjects().size());
        ESLocalProject a = (ESLocalProject)ESWorkspaceProviderImpl.getInstance().getWorkspace().getLocalProjects().get(0);
        ESLocalProject b = (ESLocalProject)ESWorkspaceProviderImpl.getInstance().getWorkspace().getLocalProjects().get(1);
        Assert.assertEquals((long)a.getModelElements().size(), (long)b.getModelElements().size());
    }
}

