/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.EMFStore;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.AuthorizationControl;
import org.eclipse.emf.emfstore.internal.server.core.AbstractEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.AbstractSubEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.Messages;
import org.eclipse.emf.emfstore.internal.server.core.MethodInvocation;
import org.eclipse.emf.emfstore.internal.server.core.ServerCallObserverNotifier;
import org.eclipse.emf.emfstore.internal.server.core.helper.EmfStoreMethod;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.EMFStorePropertiesSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.EPackageSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.FileTransferSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.HistorySubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.ProjectPropertiesSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.ProjectSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.UserSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.VersionSubInterfaceImpl;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.model.ServerSpace;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.observer.ESServerCallObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFStoreImpl
extends AbstractEmfstoreInterface
implements InvocationHandler {
    private static final String CLASS = "class";
    private static final String ORG_ECLIPSE_EMF_EMFSTORE_SERVER_SERVER_CALL_OBSERVER = "org.eclipse.emf.emfstore.server.serverCallObserver";
    private EnumMap<EmfStoreMethod.MethodId, SubInterfaceMethod> subInterfaceMethods;
    private final Set<ESServerCallObserver> serverCallObservers = this.initServerCallObservers();

    public EMFStoreImpl(ServerSpace serverSpace, AuthorizationControl authorizationControl) throws FatalESException {
        super(serverSpace, authorizationControl);
    }

    private Set<ESServerCallObserver> initServerCallObservers() {
        LinkedHashSet<ESServerCallObserver> result = new LinkedHashSet<ESServerCallObserver>();
        for (ESExtensionElement e : new ESExtensionPoint(ORG_ECLIPSE_EMF_EMFSTORE_SERVER_SERVER_CALL_OBSERVER).getExtensionElements()) {
            ESServerCallObserver observer = (ESServerCallObserver)e.getClass(CLASS, ESServerCallObserver.class);
            if (observer == null) continue;
            result.add(observer);
        }
        return result;
    }

    @Override
    protected void initSubInterfaces() throws FatalESException {
        this.subInterfaceMethods = new EnumMap(EmfStoreMethod.MethodId.class);
        this.addSubInterface(new HistorySubInterfaceImpl(this));
        this.addSubInterface(new ProjectSubInterfaceImpl(this));
        this.addSubInterface(new UserSubInterfaceImpl(this));
        this.addSubInterface(new VersionSubInterfaceImpl(this));
        this.addSubInterface(new FileTransferSubInterfaceImpl(this));
        this.addSubInterface(new ProjectPropertiesSubInterfaceImpl(this));
        this.addSubInterface(new EMFStorePropertiesSubInterfaceImpl(this));
        this.addSubInterface(new EPackageSubInterfaceImpl(this));
    }

    @Override
    protected void addSubInterface(AbstractSubEmfstoreInterface iface) {
        super.addSubInterface(iface);
        Method[] methodArray = iface.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            EmfStoreMethod implSpec = method.getAnnotation(EmfStoreMethod.class);
            if (implSpec != null) {
                this.subInterfaceMethods.put(implSpec.value(), new SubInterfaceMethod(iface, method));
            }
            ++n2;
        }
    }

    @Override
    public Object invoke(Object obj, final Method method, final Object[] args) throws ESException {
        MethodInvocation methodInvocation = new MethodInvocation(method.getName(), args);
        this.getAuthorizationControl().checkAccess(methodInvocation);
        this.notifyServerCallObservers(new ServerCallObserverNotifier(){

            public void notify(ESServerCallObserver observer) {
                observer.notifyPreServerCallExecution(method, args);
            }
        });
        SubInterfaceMethod subIfaceMethod = this.subInterfaceMethods.get((Object)methodInvocation.getType());
        try {
            final Object result = subIfaceMethod.getIface().execute(subIfaceMethod.getMethod(), args);
            this.notifyServerCallObservers(new ServerCallObserverNotifier(){

                public void notify(ESServerCallObserver observer) {
                    observer.notifyPostServerCallExecution(method, args, result);
                }
            });
            return result;
        }
        catch (ESException esException) {
            this.notifyServerCallObservers(new ServerCallObserverNotifier(){

                public void notify(ESServerCallObserver observer) {
                    observer.notifyServerCallExecutionESExceptionFailure(method, args, esException);
                }
            });
            throw esException;
        }
        catch (RuntimeException runtimeException) {
            this.notifyServerCallObservers(new ServerCallObserverNotifier(){

                public void notify(ESServerCallObserver observer) {
                    observer.notifyServerCallExecutionRuntimeExceptionFailure(method, args, runtimeException);
                }
            });
            throw runtimeException;
        }
    }

    private void notifyServerCallObservers(ServerCallObserverNotifier serverCallObserverNotifier) {
        for (ESServerCallObserver callObserver : this.serverCallObservers) {
            try {
                serverCallObserverNotifier.notify(callObserver);
            }
            catch (RuntimeException runtimeException) {
                ModelUtil.logWarning((String)Messages.EMFStoreImpl_ServerCallObserverNotifier_Failed, (Throwable)runtimeException);
            }
        }
    }

    public static EMFStore createInterface(ServerSpace serverSpace, AuthorizationControl accessControl) throws IllegalArgumentException, FatalESException {
        return (EMFStore)Proxy.newProxyInstance(EMFStoreImpl.class.getClassLoader(), new Class[]{EMFStore.class}, (InvocationHandler)new EMFStoreImpl(serverSpace, accessControl));
    }

    private class SubInterfaceMethod {
        private final AbstractSubEmfstoreInterface iface;
        private final Method method;

        public SubInterfaceMethod(AbstractSubEmfstoreInterface iface, Method m) {
            this.method = m;
            this.iface = iface;
        }

        public AbstractSubEmfstoreInterface getIface() {
            return this.iface;
        }

        public Method getMethod() {
            return this.method;
        }
    }
}

