/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.conflictDetection;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.emfstore.internal.common.api.APIDelegate;
import org.eclipse.emf.emfstore.internal.server.impl.api.ESConflictImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.ESConflict;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictBucket
implements APIDelegate<ESConflict> {
    private Set<AbstractOperation> myOperations;
    private Set<AbstractOperation> theirOperations;
    private AbstractOperation myOperation;
    private AbstractOperation theirOperation;
    private ESConflict apiImpl;
    private Set<AbstractOperation> acceptedLocalOperations;
    private boolean isResolved;
    private Set<AbstractOperation> rejectedRemoteOperations;

    public ConflictBucket(AbstractOperation myOperation, AbstractOperation theirOperation) {
        this.myOperations = new LinkedHashSet<AbstractOperation>();
        this.myOperations.add(myOperation);
        this.theirOperations = new LinkedHashSet<AbstractOperation>();
        this.theirOperations.add(theirOperation);
    }

    public ConflictBucket(Set<AbstractOperation> myOperations, Set<AbstractOperation> theirOperations) {
        this.myOperations = myOperations;
        this.theirOperations = theirOperations;
    }

    public Set<AbstractOperation> getMyOperations() {
        return this.myOperations;
    }

    public Set<AbstractOperation> getTheirOperations() {
        return this.theirOperations;
    }

    public AbstractOperation getMyOperation() {
        return this.myOperation;
    }

    public void setMyOperation(AbstractOperation myOperation) {
        this.myOperation = myOperation;
    }

    public AbstractOperation getTheirOperation() {
        return this.theirOperation;
    }

    public void setTheirOperation(AbstractOperation theirOperation) {
        this.theirOperation = theirOperation;
    }

    public ESConflict toAPI() {
        if (this.apiImpl == null) {
            this.apiImpl = this.createAPI();
        }
        return this.apiImpl;
    }

    public ESConflict createAPI() {
        return new ESConflictImpl(this);
    }

    public void resolveConflict(Set<AbstractOperation> acceptedLocalOperations, Set<AbstractOperation> rejectedRemoteOperations) {
        this.acceptedLocalOperations = acceptedLocalOperations;
        this.rejectedRemoteOperations = rejectedRemoteOperations;
        this.isResolved = true;
    }

    public Set<AbstractOperation> getAcceptedLocalOperations() {
        return this.acceptedLocalOperations;
    }

    public Set<AbstractOperation> getRejectedRemoteOperations() {
        return this.rejectedRemoteOperations;
    }

    public boolean isResolved() {
        return this.isResolved;
    }
}

