/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs.login;

import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.internal.client.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESServerImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESUsersessionImpl;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.login.ILoginDialogController;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;

public class LoginDialog
extends TitleAreaDialog {
    private Text passwordField;
    private Button savePassword;
    private ComboViewer usernameCombo;
    private final ILoginDialogController controller;
    private Usersession selectedUsersession;
    private boolean passwordModified;
    private List<Usersession> knownUsersessions;
    private String password;
    private boolean isSavePassword;

    public LoginDialog(Shell parentShell, ILoginDialogController controller) {
        super(parentShell);
        this.controller = controller;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(ResourceManager.getPluginImage("org.eclipse.emf.emfstore.client.ui", "icons/login_icon.png"));
        this.setTitle("Log in to " + this.controller.getServer().getName());
        this.setMessage("Please enter your username and password");
        this.getShell().setText("Authentication required");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        Composite loginContainer = new Composite(container, 0);
        loginContainer.setLayout((Layout)new GridLayout(3, false));
        loginContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        loginContainer.setBounds(0, 0, 64, 64);
        Label usernameLabel = new Label(loginContainer, 0);
        GridData gridData = new GridData(131072, 0x1000000, false, false, 1, 1);
        gridData.widthHint = 95;
        usernameLabel.setLayoutData((Object)gridData);
        usernameLabel.setText("Username");
        this.usernameCombo = new ComboViewer(loginContainer, 0);
        ComboListener comboListener = new ComboListener();
        this.usernameCombo.addPostSelectionChangedListener((ISelectionChangedListener)comboListener);
        Combo combo = this.usernameCombo.getCombo();
        combo.addModifyListener((ModifyListener)comboListener);
        gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        gridData.widthHint = 235;
        combo.setLayoutData((Object)gridData);
        new Label(loginContainer, 0);
        Label passwordLabel = new Label(loginContainer, 0);
        gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        gridData.widthHint = 80;
        passwordLabel.setLayoutData((Object)gridData);
        passwordLabel.setText("Password");
        this.passwordField = new Text(loginContainer, 0x400800);
        gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        gridData.widthHint = 250;
        this.passwordField.setLayoutData((Object)gridData);
        this.passwordField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LoginDialog.this.passwordModified = true;
                LoginDialog.this.flushErrorMessage();
            }
        });
        new Label(loginContainer, 0);
        Label savePasswordLabel = new Label(loginContainer, 0);
        savePasswordLabel.setText("Save Password");
        this.savePassword = new Button(loginContainer, 32);
        new Label(loginContainer, 0);
        this.initData();
        if (this.controller.getUsersession() == null) {
            ESUsersession lastUsersession = this.controller.getServer().getLastUsersession();
            if (lastUsersession != null) {
                this.loadUsersession((Usersession)((ESUsersessionImpl)lastUsersession).toInternalAPI());
            } else {
                this.loadUsersession(null);
            }
        } else {
            ESUsersession usersession = this.controller.getUsersession();
            this.loadUsersession((Usersession)((ESUsersessionImpl)usersession).toInternalAPI());
        }
        return area;
    }

    private void initData() {
        this.usernameCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.usernameCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Usersession && ((Usersession)element).getUsername() != null) {
                    return ((Usersession)element).getUsername();
                }
                return super.getText(element);
            }
        });
        this.knownUsersessions = APIUtil.mapToInternalAPI(Usersession.class, this.controller.getKnownUsersessions());
        this.usernameCombo.setInput(this.knownUsersessions);
    }

    private void loadUsersession(Usersession usersession) {
        if (usersession != null && this.getSelectedUsersession() == usersession) {
            return;
        }
        this.selectedUsersession = usersession;
        this.passwordField.setMessage("");
        this.savePassword.setSelection(false);
        if (this.getSelectedUsersession() != null) {
            if (!this.usernameCombo.getCombo().getText().equals(this.getSelectedUsersession().getUsername())) {
                this.usernameCombo.getCombo().setText(this.getSelectedUsersession().getUsername());
            }
            if (this.getSelectedUsersession().isSavePassword() && this.getSelectedUsersession().getPassword() != null) {
                this.passwordField.setMessage("<password is saved, reenter to change>");
                this.passwordField.setText("");
                this.savePassword.setSelection(true);
            }
            this.passwordModified = false;
        }
    }

    protected void okPressed() {
        final String username = this.usernameCombo.getCombo().getText();
        Usersession candidateSession = this.getSelectedUsersession();
        ESServerImpl server = (ESServerImpl)this.controller.getServer();
        if (candidateSession == null) {
            candidateSession = this.getUsersessionIfKnown(username);
        }
        if (candidateSession == null || !candidateSession.getServerInfo().equals(server.toInternalAPI())) {
            final ESServerImpl serverImpl = (ESServerImpl)this.controller.getServer();
            final Usersession session = candidateSession = ModelFactory.eINSTANCE.createUsersession();
            this.selectedUsersession = candidateSession;
            RunESCommand.run((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    session.setServerInfo((ServerInfo)serverImpl.toInternalAPI());
                    session.setUsername(username);
                    return null;
                }
            });
        }
        this.password = this.passwordField.getText();
        this.isSavePassword = this.savePassword.getSelection();
        super.okPressed();
    }

    private Usersession getUsersessionIfKnown(String username) {
        if (this.getSelectedUsersession() != null && this.getSelectedUsersession().getUsername().equals(username)) {
            return this.getSelectedUsersession();
        }
        for (Usersession session : this.knownUsersessions) {
            if (!session.getUsername().equals(username)) continue;
            return session;
        }
        return null;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(400, 250);
    }

    private void flushErrorMessage() {
        this.setErrorMessage(null);
    }

    public Usersession getSelectedUsersession() {
        return this.selectedUsersession;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isSavePassword() {
        return this.isSavePassword;
    }

    public boolean isPasswordModified() {
        return this.passwordModified;
    }

    private final class ComboListener
    implements ISelectionChangedListener,
    ModifyListener {
        private String lastText = "";

        private ComboListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object firstElement;
            ISelection selection = event.getSelection();
            if (selection instanceof StructuredSelection && (firstElement = ((StructuredSelection)selection).getFirstElement()) instanceof Usersession) {
                LoginDialog.this.loadUsersession((Usersession)firstElement);
            }
        }

        public void modifyText(ModifyEvent e) {
            String text = LoginDialog.this.usernameCombo.getCombo().getText();
            if (text != null && !text.equals("") && !text.equals(this.lastText)) {
                LoginDialog.this.loadUsersession(LoginDialog.this.getUsersessionIfKnown(text));
                this.lastText = text;
            }
            LoginDialog.this.flushErrorMessage();
        }
    }
}

