/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.filter;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.emfstore.client.handler.ESNotificationFilter;
import org.eclipse.emf.emfstore.common.model.ESObjectContainer;
import org.eclipse.emf.emfstore.common.model.util.ESNotificationInfo;
import org.eclipse.emf.emfstore.internal.common.model.impl.IdEObjectCollectionImpl;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoreOutsideProjectReferencesFilter
implements ESNotificationFilter {
    @Override
    public boolean check(ESNotificationInfo notificationInfo, ESObjectContainer<?> container) {
        if (container == null) {
            return false;
        }
        if (!notificationInfo.isReferenceNotification()) {
            return false;
        }
        EReference reference = (EReference)notificationInfo.getFeature();
        if (reference.isContainer() || reference.isContainment()) {
            return false;
        }
        if (notificationInfo.getEventType() == 7) {
            return ModelUtil.getProject((EObject)notificationInfo.getNewModelElementValue()) == null;
        }
        if (notificationInfo.getNewValue() != null && notificationInfo.getNewValue() instanceof List) {
            return this.checkNewValueList(notificationInfo, container);
        }
        if (notificationInfo.getOldValue() != null && notificationInfo.getOldValue() instanceof List) {
            if (!notificationInfo.wasSet() && ((List)notificationInfo.getOldValue()).size() == 0) {
                return false;
            }
            return this.checkOldValueList(notificationInfo, container);
        }
        if (!notificationInfo.wasSet() && notificationInfo.getNewValue() == notificationInfo.getStructuralFeature().getDefaultValue()) {
            return false;
        }
        return this.checkSingleReference(notificationInfo, container);
    }

    private boolean checkSingleReference(ESNotificationInfo notificationInfo, ESObjectContainer<?> container) {
        if (notificationInfo.getEventType() == 2) {
            return false;
        }
        if (notificationInfo.getOldValue() != null && !notificationInfo.isMoveEvent() && this.isOrWasInProject(container, notificationInfo.getOldModelElementValue())) {
            return false;
        }
        return notificationInfo.getNewValue() == null || !this.isOrWasInProject(container, notificationInfo.getNewModelElementValue());
    }

    private boolean checkOldValueList(ESNotificationInfo notificationInfo, ESObjectContainer<?> container) {
        for (EObject referencedElement : (List)notificationInfo.getOldValue()) {
            if (!this.isOrWasInProject(container, referencedElement)) continue;
            return false;
        }
        return true;
    }

    private boolean checkNewValueList(ESNotificationInfo notificationInfo, ESObjectContainer<?> container) {
        for (EObject referencedElement : (List)notificationInfo.getNewValue()) {
            if (!this.isOrWasInProject(container, referencedElement)) continue;
            return false;
        }
        return true;
    }

    private boolean isOrWasInProject(ESObjectContainer<?> container, EObject referencedElement) {
        if (ModelUtil.isSingleton((EObject)referencedElement)) {
            return true;
        }
        boolean b = container.contains(referencedElement) || ((IdEObjectCollectionImpl)container).getDeletedModelElementId(referencedElement) != null;
        return b;
    }
}

