/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor.internal.e3;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.spi.DeleteService;
import org.eclipse.emf.ecp.editor.e3.ECPEditorContext;
import org.eclipse.emf.ecp.editor.internal.e3.Activator;
import org.eclipse.emf.ecp.editor.internal.e3.MEEditor;
import org.eclipse.emf.ecp.editor.internal.e3.ShortLabelProvider;
import org.eclipse.emf.ecp.spi.ui.ECPDeleteServiceImpl;
import org.eclipse.emf.ecp.spi.ui.ECPReferenceServiceImpl;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTView;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextFactory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.menus.IMenuService;

public class MEEditorPage
extends FormPage {
    private static final String TOOLBAR_ORG_ECLIPSE_EMF_ECP_EDITOR_INTERNAL_E3_ME_EDITOR_PAGE = "toolbar:org.eclipse.emf.ecp.editor.internal.e3.MEEditorPage";
    private ScrolledForm form;
    private final ECPEditorContext modelElementContext;
    private ShortLabelProvider shortLabelProvider;
    private ComposedAdapterFactory composedAdapterFactory;
    private ECPSWTView ecpView;
    private DeleteService deleteService;

    public MEEditorPage(MEEditor editor, String id, String title, ECPEditorContext ecpEditorContext, EObject modelElement) {
        super((FormEditor)editor, id, title);
        this.modelElementContext = ecpEditorContext;
    }

    public MEEditorPage(MEEditor editor, String id, String title, ECPEditorContext modelElementContext, EObject modelElement, EStructuralFeature problemFeature) {
        this(editor, id, title, modelElementContext, modelElement);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        this.shortLabelProvider = new ShortLabelProvider((AdapterFactory)this.composedAdapterFactory);
        FormToolkit toolkit = this.getEditor().getToolkit();
        this.form = managedForm.getForm();
        this.form.setShowFocusedControl(true);
        toolkit.decorateFormHeading(this.form.getForm());
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout());
        body.setBackground(body.getDisplay().getSystemColor(1));
        body.setBackgroundMode(2);
        EObject domainObject = this.modelElementContext.getDomainObject();
        VView view = ViewProviderHelper.getView((EObject)domainObject, null);
        this.deleteService = new ECPDeleteServiceImpl();
        ViewModelContext vmc = ViewModelContextFactory.INSTANCE.createViewModelContext((VElement)view, domainObject, new ViewModelService[]{new ECPReferenceServiceImpl(), this.deleteService});
        try {
            this.ecpView = ECPSWTViewRenderer.INSTANCE.render(body, vmc);
        }
        catch (ECPRendererException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
        }
        this.form.setImage(this.shortLabelProvider.getImage(this.modelElementContext.getDomainObject()));
        this.createToolbar();
        this.form.pack();
        this.updateSectionTitle();
    }

    public void updateSectionTitle() {
        String name = this.shortLabelProvider.getText(this.modelElementContext.getDomainObject());
        name = String.valueOf(name) + " [" + this.modelElementContext.getDomainObject().eClass().getName() + "]";
        try {
            this.form.setText(name);
        }
        catch (SWTException sWTException) {
            // empty catch block
        }
    }

    private void createToolbar() {
        IMenuService menuService = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
        this.form.getToolBarManager().add((IAction)new Action("", Activator.getImageDescriptor("IMG_TOOL_DELETE")){

            public void run() {
                MEEditorPage.this.deleteService.deleteElement((Object)MEEditorPage.this.modelElementContext.getDomainObject());
                MEEditorPage.this.getEditor().close(true);
            }
        });
        menuService.populateContributionManager((ContributionManager)this.form.getToolBarManager(), TOOLBAR_ORG_ECLIPSE_EMF_ECP_EDITOR_INTERNAL_E3_ME_EDITOR_PAGE);
        this.form.getToolBarManager().update(true);
    }

    public void setFocus() {
    }

    public void dispose() {
        if (this.ecpView != null) {
            this.ecpView.dispose();
        }
        if (this.composedAdapterFactory != null) {
            this.composedAdapterFactory.dispose();
        }
        if (this.shortLabelProvider != null) {
            this.shortLabelProvider.dispose();
        }
        if (this.form != null) {
            this.form.dispose();
        }
        super.dispose();
    }
}

