/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.common;

import java.util.concurrent.Callable;
import org.eclipse.emf.emfstore.client.ui.ESUIRunnableProvider;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RunInUI {
    private static RunInUI runInUI = new RunInUI();
    private ESUIRunnableProvider runnableProvider;
    private boolean initialized;

    private RunInUI() {
    }

    public static void run(final Callable<Void> callable) {
        try {
            RunInUI runInUI = RunInUI.runInUI;
            runInUI.getClass();
            new RunInUIThread(runInUI){

                public Void doRun() throws ESException {
                    try {
                        callable.call();
                        return null;
                    }
                    catch (Exception e) {
                        throw new ESException(e.getMessage());
                    }
                }
            }.execute();
        }
        catch (ESException e) {
            WorkspaceUtil.handleException((Exception)((Object)e));
        }
    }

    public static <T> T runWithResult(final Callable<T> callable) {
        try {
            RunInUI runInUI = RunInUI.runInUI;
            runInUI.getClass();
            return new RunInUIThreadWithResult<T>(runInUI){

                @Override
                public T doRun() throws ESException {
                    try {
                        return callable.call();
                    }
                    catch (Exception e) {
                        throw new ESException(e.getMessage());
                    }
                }
            }.execute();
        }
        catch (ESException eSException) {
            return null;
        }
    }

    private Runnable getUIRunnable(Runnable runnable) {
        ESUIRunnableProvider runnableProvider = this.getRunnableProvider();
        if (runnableProvider == null) {
            return runnable;
        }
        return runnableProvider.createRunnable(runnable);
    }

    private ESUIRunnableProvider getRunnableProvider() {
        if (!this.initialized) {
            this.initialized = true;
            this.runnableProvider = (ESUIRunnableProvider)new ESExtensionPoint("org.eclipse.emf.emfstore.client.ui.uiRunnableProvider").getClass("class", ESUIRunnableProvider.class);
        }
        return this.runnableProvider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class RunInUIThread
    extends RunInUIThreadWithResult<Void> {
        public RunInUIThread() {
            super(Display.getDefault());
        }

        @Override
        public abstract Void doRun() throws ESException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class RunInUIThreadWithResult<T> {
        private T returnValue;
        private final Display display;
        private ESException exception;

        public RunInUIThreadWithResult() {
            this.display = Display.getDefault();
        }

        public RunInUIThreadWithResult(Display display) {
            this.display = display;
        }

        public T execute() throws ESException {
            this.returnValue = null;
            this.display.syncExec(RunInUI.this.getUIRunnable(new Runnable(){

                public void run() {
                    try {
                        RunInUIThreadWithResult.this.returnValue = RunInUIThreadWithResult.this.doRun();
                    }
                    catch (ESException e) {
                        RunInUIThreadWithResult.this.exception = e;
                    }
                }
            }));
            if (this.exception != null) {
                throw this.exception;
            }
            return this.returnValue;
        }

        public abstract T doRun() throws ESException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WithException {
        public static <T> T runWithResult(final Callable<T> callable) throws ESException {
            RunInUI runInUI = runInUI;
            runInUI.getClass();
            return new RunInUIThreadWithResult<T>(runInUI){

                @Override
                public T doRun() throws ESException {
                    try {
                        return callable.call();
                    }
                    catch (ESException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new ESException(e.getMessage(), (Throwable)e);
                    }
                }
            }.execute();
        }

        public static void run(final Callable<Void> callable) throws ESException {
            RunInUI runInUI = runInUI;
            runInUI.getClass();
            new RunInUIThread(runInUI){

                public Void doRun() throws ESException {
                    try {
                        callable.call();
                        return null;
                    }
                    catch (Exception e) {
                        throw new ESException(e.getMessage());
                    }
                }
            }.execute();
        }
    }
}

