/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs;

import java.util.List;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CompareProjectsDialog
extends TitleAreaDialog {
    private ProjectSpace selectedProjectSpace;
    private ListViewer listViewer;

    protected Control createDialogArea(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayoutData((Object)new GridData(4, 4, true, true));
        contents.setLayout((Layout)new GridLayout());
        Label lbl1 = new Label(contents, 0);
        lbl1.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        lbl1.setText("Selected Project:");
        Label lblSelectedProj = new Label(contents, 2048);
        lblSelectedProj.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        lblSelectedProj.setText(this.selectedProjectSpace.getProjectName());
        Label lbl3 = new Label(contents, 0);
        lbl3.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        lbl3.setText("Compare to:");
        this.listViewer = new ListViewer(contents, 4);
        this.listViewer.getList().setLayoutData((Object)new GridData(4, 4, true, true));
        this.listViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                List projects = ESWorkspaceProviderImpl.getInstance().getWorkspace().getLocalProjects();
                return projects.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ProjectSpace)element).getProjectName();
            }
        });
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectSpace secondProjectSpace = (ProjectSpace)((StructuredSelection)event.getSelection()).getFirstElement();
                if (secondProjectSpace.equals(CompareProjectsDialog.this.selectedProjectSpace)) {
                    CompareProjectsDialog.this.setErrorMessage("Selected projects must be different");
                    CompareProjectsDialog.this.getButton(0).setEnabled(false);
                } else {
                    CompareProjectsDialog.this.setErrorMessage(null);
                    CompareProjectsDialog.this.getButton(0).setEnabled(true);
                }
            }
        });
        this.listViewer.setInput(new Object());
        this.setTitle("Select a project from list to compare");
        return contents;
    }

    protected void okPressed() {
        ProjectSpace secondProjectSpace = (ProjectSpace)((StructuredSelection)this.listViewer.getSelection()).getFirstElement();
        boolean areEqual = ModelUtil.areEqual((IdEObjectCollection)this.selectedProjectSpace.getProject(), (IdEObjectCollection)secondProjectSpace.getProject());
        String message = areEqual ? "The projects are identical." : "The projects are NOT identical!";
        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, (String)message);
        super.okPressed();
    }

    public CompareProjectsDialog(Shell parentShell, ProjectSpace selectedProjectSpace) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.selectedProjectSpace = selectedProjectSpace;
    }
}

