/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.DecisionManager;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictOption;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.VisualConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.DecisionUtil;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge.ui.DescriptionComponent;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge.ui.OptionComponent;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge.ui.components.ContextComponent;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge.ui.components.DetailsComponent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionBox
extends Composite {
    private static final String EMFSTORE_CLIENT_UI_PLUGIN_ID = "org.eclipse.emf.emfstore.client.ui";
    private static final String OPTION_COMPONENT_CLASS = "org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge.ui.OptionComponentImpl";
    private static final String DESCRIPTION_COMPONENT_CLASS = "org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge.ui.DescriptionComponentImpl";
    private final VisualConflict conflict;
    private final DecisionManager decisionManager;
    private OptionComponent optionComponent;

    public DecisionBox(Composite parent, DecisionManager decisionManager, Color color, VisualConflict conflict) {
        super(parent, 2048);
        this.decisionManager = decisionManager;
        this.conflict = conflict;
        this.init(color);
    }

    private void init(Color color) {
        GridLayout decisionLayout = new GridLayout(2, true);
        this.setLayout((Layout)decisionLayout);
        this.setLayoutData(new GridData(4, 4, true, false));
        if (color != null) {
            this.setBackground(color);
        }
        new ContextComponent(this, this.conflict);
        this.optionComponent = (OptionComponent)this.newInstanceOf(OPTION_COMPONENT_CLASS);
        this.optionComponent.init(this, this, this.conflict);
        DescriptionComponent descriptionComponent = (DescriptionComponent)this.newInstanceOf(DESCRIPTION_COMPONENT_CLASS);
        descriptionComponent.init(this, this, this.conflict);
        if (DecisionUtil.detailsNeeded((VisualConflict)this.conflict)) {
            new DetailsComponent(this, this.conflict);
        }
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setBackground(this.getBackground());
            ++n2;
        }
    }

    public DecisionManager getDecisionManager() {
        return this.decisionManager;
    }

    public void setSolution(ConflictOption option) {
        this.conflict.setSolution(option);
        this.optionComponent.refreshButtonColor();
    }

    public void layoutPage(int heightSizeChange) {
        ScrolledComposite scrollArea = (ScrolledComposite)this.getParent().getParent();
        scrollArea.setMinSize(scrollArea.getMinWidth(), scrollArea.getMinHeight() + heightSizeChange);
        scrollArea.layout();
    }

    public VisualConflict getConflict() {
        return this.conflict;
    }

    private <T> T newInstanceOf(String clazz) {
        try {
            Class<T> c = DecisionBox.loadClass(EMFSTORE_CLIENT_UI_PLUGIN_ID, clazz);
            T newInstance = c.getConstructor(new Class[0]).newInstance(new Object[0]);
            return newInstance;
        }
        catch (ClassNotFoundException ex) {
            WorkspaceUtil.logException((String)ex.getMessage(), (Exception)ex);
        }
        catch (InstantiationException ex) {
            WorkspaceUtil.logException((String)ex.getMessage(), (Exception)ex);
        }
        catch (IllegalAccessException ex) {
            WorkspaceUtil.logException((String)ex.getMessage(), (Exception)ex);
        }
        catch (IllegalArgumentException ex) {
            WorkspaceUtil.logException((String)ex.getMessage(), (Exception)ex);
        }
        catch (InvocationTargetException ex) {
            WorkspaceUtil.logException((String)ex.getMessage(), (Exception)ex);
        }
        catch (NoSuchMethodException ex) {
            WorkspaceUtil.logException((String)ex.getMessage(), (Exception)ex);
        }
        catch (SecurityException ex) {
            WorkspaceUtil.logException((String)ex.getMessage(), (Exception)ex);
        }
        return null;
    }

    private static <T> Class<T> loadClass(String bundleName, String clazz) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ClassNotFoundException(String.valueOf(clazz) + " cannot be loaded because bundle " + bundleName + " cannot be resolved");
        }
        return bundle.loadClass(clazz);
    }
}

