/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.internal.reporting;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecp.view.spi.model.reporting.AbstractReport;
import org.eclipse.emf.ecp.view.spi.model.reporting.ReportService;
import org.eclipse.emf.ecp.view.spi.model.reporting.ReportServiceConsumer;

public class ReportServiceImpl
implements ReportService {
    private final List<AbstractReport> reports = new ArrayList<AbstractReport>();
    private final Set<ReportServiceConsumer> consumers = new LinkedHashSet<ReportServiceConsumer>();

    @Override
    public void report(AbstractReport reportEntity) {
        this.reports.add(reportEntity);
        for (ReportServiceConsumer consumer : this.consumers) {
            consumer.reported(reportEntity);
        }
    }

    @Override
    public List<AbstractReport> getReports() {
        return this.reports;
    }

    @Override
    public void clearReports() {
        this.reports.clear();
    }

    @Override
    public void addConsumer(ReportServiceConsumer consumer) {
        this.consumers.add(consumer);
    }

    @Override
    public void removeConsumer(ReportServiceConsumer consumer) {
        this.consumers.remove(consumer);
    }
}

