/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs.login;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.Workspace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESUsersessionImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESWorkspaceImpl;
import org.eclipse.emf.emfstore.internal.client.ui.common.RunInUI;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.login.ILoginDialogController;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.login.LoginDialog;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.login.Messages;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoginDialogController
implements ILoginDialogController {
    private ESUsersession usersession;
    private ESServer server;
    private LoginDialog dialog;

    @Override
    public List<ESUsersession> getKnownUsersessions() {
        EList usersessions = ((Workspace)ESWorkspaceProviderImpl.getInstance().getWorkspace().toInternalAPI()).getUsersessions();
        ArrayList<ESUsersession> knownSessions = new ArrayList<ESUsersession>();
        for (Usersession session : usersessions) {
            ServerInfo serverInfo = session.getServerInfo();
            if (serverInfo == null || serverInfo.toAPI() != this.server) continue;
            knownSessions.add((ESUsersession)session.toAPI());
        }
        return knownSessions;
    }

    private ESUsersession login(boolean force) throws ESException {
        if (this.server != null && this.server.getLastUsersession() != null && this.server.getLastUsersession().isLoggedIn() && !force) {
            this.server.getLastUsersession().refresh();
            return this.server.getLastUsersession();
        }
        Integer userInput = RunInUI.runWithResult(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                LoginDialogController.this.dialog = new LoginDialog(Display.getCurrent().getActiveShell(), LoginDialogController.this);
                LoginDialogController.this.dialog.setBlockOnOpen(true);
                return LoginDialogController.this.dialog.open();
            }
        });
        if (userInput != 0) {
            throw new AccessControlException(Messages.LoginDialogController_LoginFailed);
        }
        final Usersession session = this.dialog.getSelectedUsersession();
        if (session == null) {
            throw new AccessControlException(Messages.LoginDialogController_LoginFailed);
        }
        final String password = this.dialog.getPassword();
        final boolean savePassword = this.dialog.isSavePassword();
        final boolean passwordModified = this.dialog.isPasswordModified();
        RunESCommand.run((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                session.setSavePassword(savePassword);
                if (passwordModified) {
                    session.setPassword(password);
                }
                return null;
            }
        });
        this.validate((ESUsersession)session.toAPI());
        return this.usersession;
    }

    public String getServerLabel() {
        return this.getServer().getName();
    }

    @Override
    public void validate(ESUsersession session) throws ESException {
        final Usersession usersession = (Usersession)((ESUsersessionImpl)session).toInternalAPI();
        ESWorkspaceImpl workspace = ESWorkspaceProviderImpl.getInstance().getWorkspace();
        final EList usersessions = ((Workspace)workspace.toInternalAPI()).getUsersessions();
        RunESCommand.WithException.run(ESException.class, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                usersession.logIn();
                if (!usersessions.contains((Object)usersession)) {
                    usersessions.add((Object)usersession);
                }
                return null;
            }
        });
        this.usersession = session;
        ((Workspace)ESWorkspaceProviderImpl.getInstance().getWorkspace().toInternalAPI()).save();
    }

    @Override
    public ESUsersession getUsersession() {
        return this.usersession;
    }

    @Override
    public ESServer getServer() {
        if (this.server != null) {
            return this.server;
        }
        return this.usersession.getServer();
    }

    public ESUsersession login(ESServer server, boolean force) throws ESException {
        this.server = server;
        this.usersession = null;
        return this.login(force);
    }

    public void login(ESUsersession usersession, boolean force) throws ESException {
        this.server = null;
        this.usersession = usersession;
        this.login(force);
    }

    public ESUsersession login(ESServer server) throws ESException {
        this.server = server;
        this.usersession = null;
        return this.login(false);
    }

    public ESUsersession login(ESUsersession usersession) throws ESException {
        this.usersession = usersession;
        this.server = usersession.getServer();
        return this.login(false);
    }
}

