/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.model.util;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.impl.Activator;
import org.eclipse.emf.ecp.view.spi.model.reporting.DomainModelReferenceResolutionFailedReport;

public final class ViewModelUtil {
    private static final String ORG_ECLIPSE_EMF_ECP_VIEW_SPI_LABEL_MODEL_V_LABEL = "org.eclipse.emf.ecp.view.spi.label.model.VLabel";
    private static Boolean debugMode;
    private static boolean isDebugInitialized;

    private ViewModelUtil() {
    }

    public static void resolveDomainReferences(EObject renderable, EObject domainModelRoot) {
        ViewModelUtil.checkAndResolve(renderable, domainModelRoot);
        TreeIterator eAllContents = renderable.eAllContents();
        while (eAllContents.hasNext()) {
            EObject eObject = (EObject)eAllContents.next();
            ViewModelUtil.checkAndResolve(eObject, domainModelRoot);
        }
    }

    private static void checkAndResolve(EObject renderable, EObject domainModelRoot) {
        if (VControl.class.isInstance(renderable)) {
            VControl control = (VControl)renderable;
            if (control.getDomainModelReference() == null) {
                return;
            }
            boolean init = control.getDomainModelReference().init(domainModelRoot);
            if (!init && ViewModelUtil.isDebugMode()) {
                Activator.getDefault().getReportService().report(new DomainModelReferenceResolutionFailedReport(control.getDomainModelReference(), control));
            }
        } else if (VContainedElement.class.isInstance(renderable)) {
            VContainedElement element = (VContainedElement)VContainedElement.class.cast(renderable);
            if (!ORG_ECLIPSE_EMF_ECP_VIEW_SPI_LABEL_MODEL_V_LABEL.equals(element.eClass().getInstanceClassName())) {
                return;
            }
            for (EObject object : element.eContents()) {
                boolean init;
                if (!VDomainModelReference.class.isInstance(object) || (init = ((VDomainModelReference)VDomainModelReference.class.cast(object)).init(domainModelRoot)) || !ViewModelUtil.isDebugMode()) continue;
                Activator.getDefault().getReportService().report(new DomainModelReferenceResolutionFailedReport((VDomainModelReference)VDomainModelReference.class.cast(object), element));
            }
        }
    }

    public static boolean isDebugMode() {
        if (!isDebugInitialized) {
            debugMode = Boolean.FALSE;
            String[] commandLineArgs = Platform.getCommandLineArgs();
            int i = 0;
            while (i < commandLineArgs.length) {
                String arg = commandLineArgs[i];
                if ("-debugEMFForms".equalsIgnoreCase(arg)) {
                    debugMode = Boolean.TRUE;
                }
                ++i;
            }
            isDebugInitialized = true;
        }
        return debugMode;
    }
}

