/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.custom.swt;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecp.edit.spi.swt.util.SWTValidationHelper;
import org.eclipse.emf.ecp.internal.edit.EditMessages;
import org.eclipse.emf.ecp.view.model.common.AbstractRenderer;
import org.eclipse.emf.ecp.view.spi.custom.model.VCustomControl;
import org.eclipse.emf.ecp.view.spi.custom.swt.ECPAbstractCustomControlSWT;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridCell;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridDescription;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.osgi.framework.Bundle;

public class CustomControlSWTRenderer
extends AbstractSWTRenderer<VCustomControl> {
    private ECPAbstractCustomControlSWT swtCustomControl;

    protected void preInit() {
        super.preInit();
        VCustomControl customControl = (VCustomControl)this.getVElement();
        this.swtCustomControl = this.loadCustomControl(customControl);
        if (this.swtCustomControl == null) {
            throw new IllegalStateException(String.format("The  %1$s/%2$s cannot be loaded!", customControl.getBundleName(), customControl.getClassName()));
        }
        this.swtCustomControl.init((VCustomControl)this.getVElement(), this.getViewModelContext());
    }

    protected ECPAbstractCustomControlSWT loadCustomControl(VCustomControl customControl) {
        String bundleName = customControl.getBundleName();
        String className = customControl.getClassName();
        customControl.getBundleName();
        if (bundleName == null) {
            bundleName = "";
        }
        if (className == null) {
            className = "";
        }
        this.swtCustomControl = CustomControlSWTRenderer.loadObject(bundleName, className);
        return this.swtCustomControl;
    }

    private static ECPAbstractCustomControlSWT loadObject(String bundleName, String clazz) {
        Class loadClass;
        block6: {
            Bundle bundle = Platform.getBundle((String)bundleName);
            if (bundle == null) {
                new ClassNotFoundException(String.valueOf(clazz) + EditMessages.CONTROLFACTROY_CANNOT_BE_LOADED + bundleName + EditMessages.CONTROLFACTORY_CANNOT_BE_RESOLVED);
                return null;
            }
            loadClass = bundle.loadClass(clazz);
            if (ECPAbstractCustomControlSWT.class.isAssignableFrom(loadClass)) break block6;
            return null;
        }
        try {
            return (ECPAbstractCustomControlSWT)ECPAbstractCustomControlSWT.class.cast(loadClass.newInstance());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    protected void dispose() {
        this.swtCustomControl.dispose();
        super.dispose();
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        SWTGridDescription gd = this.swtCustomControl.getGridDescription();
        for (SWTGridCell gridCell : gd.getGrid()) {
            gridCell.setRenderer((AbstractRenderer)this);
        }
        return gd;
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        return this.swtCustomControl.renderControl(cell, parent);
    }

    protected void applyReadOnly() {
        this.swtCustomControl.applyReadOnly(this.getControls());
    }

    protected void applyEnable() {
        this.swtCustomControl.applyEnable(this.getControls());
    }

    protected void applyVisible() {
        for (SWTGridCell gridCell : this.getControls().keySet()) {
            GridData gridData;
            Object layoutData = ((Control)this.getControls().get(gridCell)).getLayoutData();
            if (GridData.class.isInstance(layoutData) && (gridData = (GridData)layoutData) != null) {
                gridData.exclude = false;
            }
            ((Control)this.getControls().get(gridCell)).setVisible(((VCustomControl)this.getVElement()).isVisible());
        }
    }

    protected void applyValidation() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (CustomControlSWTRenderer.this.getControls().size() == 0 || ((Control)CustomControlSWTRenderer.this.getControls().values().iterator().next()).isDisposed()) {
                    return;
                }
                Label validationIcon = null;
                switch (CustomControlSWTRenderer.this.getControls().size()) {
                    case 3: {
                        validationIcon = (Label)Label.class.cast(CustomControlSWTRenderer.this.getControls().get(new SWTGridCell(0, 1, (AbstractSWTRenderer)CustomControlSWTRenderer.this)));
                        break;
                    }
                }
                if (validationIcon != null && !validationIcon.isDisposed()) {
                    validationIcon.setImage(CustomControlSWTRenderer.this.getValidationIcon(((VCustomControl)CustomControlSWTRenderer.this.getVElement()).getDiagnostic().getHighestSeverity()));
                    validationIcon.setToolTipText(((VCustomControl)CustomControlSWTRenderer.this.getVElement()).getDiagnostic().getMessage());
                }
                if (CustomControlSWTRenderer.this.swtCustomControl != null) {
                    CustomControlSWTRenderer.this.swtCustomControl.applyValidation();
                }
            }
        });
    }

    private Image getValidationIcon(int severity) {
        return SWTValidationHelper.INSTANCE.getValidationIcon(severity, this.getVElement(), this.getViewModelContext());
    }
}

