/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.template.internal.tooling.controls;

import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.template.internal.tooling.Activator;
import org.eclipse.emf.ecp.view.template.internal.tooling.Messages;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class URLSelectionControlSWTRenderer
extends SimpleControlSWTControlSWTRenderer {
    protected Binding[] createBindings(Control control, EStructuralFeature.Setting setting) {
        Composite composite = (Composite)Composite.class.cast(control);
        Control childControl = composite.getChildren()[0];
        ISWTObservableValue value = SWTObservables.observeText((Control)childControl);
        Binding binding = this.getDataBindingContext().bindValue((IObservableValue)value, this.getModelValue(setting));
        ISWTObservableValue toolTip = SWTObservables.observeTooltipText((Control)childControl);
        Binding tooltipBinding = this.getDataBindingContext().bindValue((IObservableValue)toolTip, this.getModelValue(setting));
        return new Binding[]{binding, tooltipBinding};
    }

    protected Control createSWTControl(Composite parent, final EStructuralFeature.Setting setting) {
        final Composite composite = new Composite(parent, 0);
        composite.setBackgroundMode(2);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(composite);
        Label label = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)label);
        Button selectExternFileButton = new Button(composite, 8);
        GridDataFactory.fillDefaults().align(1, 1).grab(false, false).applyTo((Control)selectExternFileButton);
        selectExternFileButton.setText(Messages.URLSelectionControlSWTRenderer_SelectExternalFileBtn);
        selectExternFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                FileDialog fd = new FileDialog(composite.getShell(), 4096);
                String open = fd.open();
                if (open == null) {
                    return;
                }
                String selectedURL = null;
                try {
                    selectedURL = new File(open).toURI().toURL().toExternalForm();
                }
                catch (MalformedURLException ex) {
                    Activator.log(ex);
                }
                URLSelectionControlSWTRenderer.this.setValue(selectedURL, setting);
            }
        });
        Button selectWorkspaceFileButton = new Button(composite, 8);
        GridDataFactory.fillDefaults().align(1, 1).grab(false, false).applyTo((Control)selectWorkspaceFileButton);
        selectWorkspaceFileButton.setText(Messages.URLSelectionControlSWTRenderer_SelectWorkspaceFileBtn);
        selectWorkspaceFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
                WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
                ElementTreeSelectionDialog etsd = new ElementTreeSelectionDialog(composite.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
                etsd.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                int open = etsd.open();
                if (1 == open) {
                    return;
                }
                IResource resource = (IResource)etsd.getResult()[0];
                String selectedURL = "platform:/plugin" + resource.getFullPath().toString();
                URLSelectionControlSWTRenderer.this.setValue(selectedURL, setting);
            }
        });
        return composite;
    }

    private void setValue(String selectedURL, EStructuralFeature.Setting setting) {
        EditingDomain editingDomain = this.getEditingDomain(setting);
        Command command = SetCommand.create((EditingDomain)editingDomain, (Object)setting.getEObject(), (Object)setting.getEStructuralFeature(), (Object)selectedURL);
        editingDomain.getCommandStack().execute(command);
    }

    protected String getUnsetText() {
        return Messages.URLSelectionControlSWTRenderer_UnsetText;
    }
}

