/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.swt;

import java.util.Collections;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTView;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.internal.table.swt.Activator;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.swt.TableControlSWTRenderer;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TableControlDetailPanelRenderer
extends TableControlSWTRenderer {
    private ECPSWTView ecpView;
    private VView view;
    private Composite detailPanel;
    private Composite border;
    private ScrolledComposite scrolledComposite;
    private boolean debugMode;

    public TableControlDetailPanelRenderer() {
        String[] commandLineArgs = Platform.getCommandLineArgs();
        int i = 0;
        while (i < commandLineArgs.length) {
            String arg = commandLineArgs[i];
            if ("-debugEMFForms".equalsIgnoreCase(arg)) {
                this.debugMode = true;
            }
            ++i;
        }
    }

    @Override
    protected Composite createControlComposite(Composite composite) {
        this.border = new Composite(composite, 2048);
        GridLayout gridLayout = GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).create();
        this.border.setLayout((Layout)gridLayout);
        int totalHeight = this.getTableHeightHint() + this.getDetailPanelHeightHint() + gridLayout.verticalSpacing;
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(1, totalHeight).applyTo((Control)this.border);
        Composite tableComposite = new Composite(this.border, 0);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 4).hint(1, this.getTableHeightHint()).applyTo((Control)tableComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.border);
        this.scrolledComposite = new ScrolledComposite(this.border, 512);
        this.scrolledComposite.setBackground(composite.getBackground());
        this.scrolledComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.scrolledComposite);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setExpandHorizontal(true);
        this.detailPanel = this.createDetailPanel(this.scrolledComposite);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.detailPanel);
        this.scrolledComposite.setContent((Control)this.detailPanel);
        this.detailPanel.layout();
        Point point = this.detailPanel.computeSize(-1, -1);
        this.scrolledComposite.setMinHeight(point.y);
        return tableComposite;
    }

    protected int getDetailPanelHeightHint() {
        return 400;
    }

    protected Composite createDetailPanel(ScrolledComposite composite) {
        Composite detail = new Composite((Composite)this.scrolledComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).applyTo(detail);
        return detail;
    }

    protected VView getView() {
        if (this.view == null) {
            VView detailView = ((VTableControl)this.getVElement()).getDetailView();
            if (detailView == null) {
                EStructuralFeature.Setting setting = (EStructuralFeature.Setting)((VTableControl)this.getVElement()).getDomainModelReference().getIterator().next();
                EReference reference = (EReference)setting.getEStructuralFeature();
                detailView = ViewProviderHelper.getView((EObject)EcoreUtil.create((EClass)reference.getEReferenceType()), Collections.emptyMap());
            }
            this.view = detailView;
        }
        return (VView)EcoreUtil.copy((EObject)this.view);
    }

    @Override
    protected void viewerSelectionChanged(SelectionChangedEvent event) {
        if (event.getSelection().isEmpty()) {
            this.handleEmptySelection();
        } else if (((IStructuredSelection)IStructuredSelection.class.cast(event.getSelection())).size() != 1) {
            this.handleMultiSelection((IStructuredSelection)event.getSelection());
        } else {
            this.handleSingleSelection((IStructuredSelection)event.getSelection());
        }
        super.viewerSelectionChanged(event);
    }

    protected void handleSingleSelection(IStructuredSelection selection) {
        try {
            this.disposeDetail();
            EObject object = (EObject)selection.getFirstElement();
            VView detailView = this.getView();
            if (detailView == null) {
                if (this.isDebug()) {
                    Label label = new Label(this.detailPanel, 0);
                    label.setBackground(Display.getDefault().getSystemColor(3));
                    label.setText("No Detail View found.");
                }
                return;
            }
            this.ecpView = ECPSWTViewRenderer.INSTANCE.render(this.detailPanel, object, detailView);
            this.border.layout(true, true);
            Point point = this.detailPanel.computeSize(-1, -1);
            this.scrolledComposite.setMinHeight(point.y);
        }
        catch (ECPRendererException ex) {
            Activator.log(ex);
        }
    }

    private boolean isDebug() {
        return this.debugMode;
    }

    protected void handleMultiSelection(IStructuredSelection selection) {
        this.disposeDetail();
    }

    protected void handleEmptySelection() {
        this.disposeDetail();
    }

    private void disposeDetail() {
        if (this.ecpView != null) {
            this.ecpView.getSWTControl().dispose();
            this.ecpView = null;
        }
        Control[] controlArray = this.detailPanel.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
    }
}

