/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfatic.ui.outline;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfatic.core.lang.gen.ast.ClassDecl;
import org.eclipse.emf.emfatic.ui.EmfaticUIPlugin;
import org.eclipse.emf.emfatic.ui.editor.EmfaticEditor;
import org.eclipse.emf.emfatic.ui.outline.AnnFilterAction;
import org.eclipse.emf.emfatic.ui.outline.AnnotationFilter;
import org.eclipse.emf.emfatic.ui.outline.AttrFilter;
import org.eclipse.emf.emfatic.ui.outline.AttrFilterAction;
import org.eclipse.emf.emfatic.ui.outline.OpFilter;
import org.eclipse.emf.emfatic.ui.outline.OpFilterAction;
import org.eclipse.emf.emfatic.ui.outline.RefFilter;
import org.eclipse.emf.emfatic.ui.outline.RefFilterAction;
import org.eclipse.emf.emfatic.ui.outline.TypeParamFilter;
import org.eclipse.emf.emfatic.ui.outline.TypeParamFilterAction;
import org.eclipse.gymnast.runtime.core.ast.ASTNode;
import org.eclipse.gymnast.runtime.core.outline.OutlineNode;
import org.eclipse.gymnast.runtime.ui.editor.LDTEditor;
import org.eclipse.gymnast.runtime.ui.outline.LDTContentOutlinePage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageSite;

public class EmfaticContentOutlinePage
extends LDTContentOutlinePage {
    private EmfaticEditor _editor = null;
    private Action annFilterAction;
    private AnnotationFilter annFilter;
    private Action attrFilterAction;
    private AttrFilter attrFilter;
    private Action refFilterAction;
    private RefFilter refFilter;
    private Action opFilterAction;
    private OpFilter opFilter;
    private Action typeParamFilterAction;
    private TypeParamFilter typeParamFilter;
    private Action fOpenInTypeHierarchy;
    private Menu fMenu;

    public EmfaticContentOutlinePage(EmfaticEditor _editor) {
        super((LDTEditor)_editor);
        this._editor = _editor;
        _editor.setContentOutlinePage(this);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.makeFilterActions();
        IActionBars bars = this.getSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this.annFilterAction);
        manager.add((IAction)this.attrFilterAction);
        manager.add((IAction)this.refFilterAction);
        manager.add((IAction)this.opFilterAction);
        manager.add((IAction)this.typeParamFilterAction);
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator());
        this.populateContextMenu();
    }

    private void populateContextMenu() {
        this.fOpenInTypeHierarchy = new Action(){

            public void run() {
                OutlineNode element = EmfaticContentOutlinePage.this.getSelectedNode();
                if (element != null && element.getASTNode() != null && element.getASTNode() instanceof ClassDecl) {
                    ClassDecl cd = (ClassDecl)element.getASTNode();
                    EObject eO = (EObject)EmfaticContentOutlinePage.this._editor.getCstDecl2EcoreAST().get((Object)cd);
                    if (eO != null && eO instanceof EClass) {
                        EmfaticContentOutlinePage.this._editor.showInTypeHierarchy((EClass)eO);
                    }
                }
            }
        };
        this.fOpenInTypeHierarchy.setText("fOpenInTypeHierarchy");
        this.fOpenInTypeHierarchy.setToolTipText("fOpenInTypeHierarchy");
        this.fOpenInTypeHierarchy.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        TreeViewer viewer = this.getTreeViewer();
        MenuManager manager = new MenuManager("#PopUp");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                EmfaticContentOutlinePage.this.contextMenuAboutToShow(menuManager);
            }
        });
        this.fMenu = manager.createContextMenu((Control)viewer.getTree());
        viewer.getTree().setMenu(this.fMenu);
        IPageSite site = this.getSite();
        site.registerContextMenu("org.eclipse.emf.emfatic.ui.outline", manager, (ISelectionProvider)viewer);
    }

    public ILabelProvider createOutlineLabelProvideDecorated() {
        return null;
    }

    void makeFilterActions() {
        this.annFilterAction = new AnnFilterAction("Show Annotations", 2, this.annFilter, this.getTreeViewer());
        this.annFilterAction.setText("Hide Annotations");
        this.annFilterAction.setToolTipText("Hide Annotations");
        ImageDescriptor id = EmfaticContentOutlinePage.getImageDescriptorFromIconsFolder("HideEAnnotations.gif");
        this.annFilterAction.setImageDescriptor(id);
        this.attrFilterAction = new AttrFilterAction("Show Attributes", 2, this.attrFilter, this.getTreeViewer());
        this.attrFilterAction.setText("Hide Attributes");
        this.attrFilterAction.setToolTipText("Hide Attributes");
        id = EmfaticContentOutlinePage.getImageDescriptorFromIconsFolder("HideEAttributes.gif");
        this.attrFilterAction.setImageDescriptor(id);
        this.refFilterAction = new RefFilterAction("Show References", 2, this.refFilter, this.getTreeViewer());
        this.refFilterAction.setText("Hide References");
        this.refFilterAction.setToolTipText("Hide References");
        id = EmfaticContentOutlinePage.getImageDescriptorFromIconsFolder("HideEReferences.gif");
        this.refFilterAction.setImageDescriptor(id);
        this.opFilterAction = new OpFilterAction("Show Operations", 2, this.opFilter, this.getTreeViewer());
        this.opFilterAction.setText("Hide Operations");
        this.opFilterAction.setToolTipText("Hide Operations");
        id = EmfaticContentOutlinePage.getImageDescriptorFromIconsFolder("HideEOperations.gif");
        this.opFilterAction.setImageDescriptor(id);
        this.typeParamFilterAction = new TypeParamFilterAction("Show Type Params", 2, this.typeParamFilter, this.getTreeViewer());
        this.typeParamFilterAction.setText("Hide Type Params");
        this.typeParamFilterAction.setToolTipText("Hide Type Params");
        id = EmfaticContentOutlinePage.getImageDescriptorFromIconsFolder("HideETypeParameters.gif");
        this.typeParamFilterAction.setImageDescriptor(id);
    }

    public static Image getImageFromIconsFolder(String name) {
        String iconPath = "icons/";
        try {
            URL installURL = EmfaticUIPlugin.getDefault().getBundle().getEntry("/");
            URL url = new URL(installURL, String.valueOf(iconPath) + name);
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
            Image image = imageDescriptor.createImage();
            return image;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static ImageDescriptor getImageDescriptorFromIconsFolder(String name) {
        String iconPath = "icons/";
        try {
            URL installURL = EmfaticUIPlugin.getDefault().getBundle().getEntry("/");
            URL url = new URL(installURL, String.valueOf(iconPath) + name);
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
            return imageDescriptor;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public boolean showingAnnotations() {
        return !this.annFilterAction.isChecked();
    }

    public boolean showingAttributes() {
        return !this.attrFilterAction.isChecked();
    }

    public boolean showingOperations() {
        return !this.opFilterAction.isChecked();
    }

    public boolean showingReferences() {
        return !this.refFilterAction.isChecked();
    }

    public boolean showingTypeParams() {
        return !this.typeParamFilterAction.isChecked();
    }

    public void selectFromEditor(OutlineNode toHighlight) {
        if (toHighlight != null) {
            ASTNode astNode = toHighlight.getASTNode();
            OutlineNode outlineRoot = null;
            TreeItem root = this.getTreeViewer().getTree().getTopItem();
            Object rootData = root.getData();
            if (rootData instanceof OutlineNode) {
                outlineRoot = (OutlineNode)rootData;
                while (outlineRoot.getParent() != null) {
                    outlineRoot = outlineRoot.getParent();
                }
            }
            toHighlight = this.findOutlineNodeForASTNode(outlineRoot, astNode);
            TreeViewer viewer = this.getTreeViewer();
            viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            viewer.setSelection((ISelection)new StructuredSelection((Object)toHighlight), true);
            viewer.reveal((Object)toHighlight);
            viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    private OutlineNode findOutlineNodeForASTNode(OutlineNode nodeInTree, ASTNode astNode) {
        if (nodeInTree == null) {
            return null;
        }
        ASTNode treeASTNode = nodeInTree.getASTNode();
        if (treeASTNode == astNode) {
            return nodeInTree;
        }
        if (nodeInTree.getChildren() != null) {
            OutlineNode[] outlineNodeArray = nodeInTree.getChildren();
            int n = outlineNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                OutlineNode outlineChild = outlineNodeArray[n2];
                OutlineNode candidate = this.findOutlineNodeForASTNode(outlineChild, astNode);
                if (candidate != null) {
                    return candidate;
                }
                ++n2;
            }
        }
        return null;
    }

    private void contextMenuAboutToShow(IMenuManager menuManager) {
        if (this.selectionIsEClass()) {
            menuManager.add((IAction)this.fOpenInTypeHierarchy);
        }
        menuManager.add((IContributionItem)new Separator("additions"));
    }

    private boolean selectionIsEClass() {
        OutlineNode o = this.getSelectedNode();
        if (o.getASTNode() != null && o.getASTNode() instanceof ClassDecl) {
            ClassDecl cd = (ClassDecl)o.getASTNode();
            EObject eO = (EObject)this._editor.getCstDecl2EcoreAST().get((Object)cd);
            if (eO != null && eO instanceof EClass) {
                return true;
            }
        }
        return false;
    }

    private OutlineNode getSelectedNode() {
        Object selected;
        IStructuredSelection selection;
        ISelection iselection = this.getSelection();
        if (iselection instanceof IStructuredSelection && (selection = (IStructuredSelection)iselection).size() == 1 && (selected = selection.getFirstElement()) instanceof OutlineNode) {
            return (OutlineNode)selected;
        }
        return null;
    }
}

