package pum.simuref.modeltocode.participant.java;

import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.refactor.refactorings.uml24.createclasswithattributesfromparameterlist.UmlParameterList;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.refactoring.IJavaRefactorings;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.uml2.uml.Operation;

import pum.simuref.matching.Measurement;
import pum.simuref.modeltocode.participant.participants.EmfJavaRefactoringParticipant;
import pum.simuref.utils.InformationsGui;
import pum.simuref.utils.Preferences;

public class RenameMethod extends EmfJavaRefactoringParticipant {

	private static final String JAVAREFACTORINGID = IJavaRefactorings.RENAME_METHOD;
	private RenameJavaElementDescriptor refactoringDescriptor;
	
	private Operation fOperation;
	private UmlParameterList fUmlParameterList; 
	private IMethod fIMethod;
	
	@Override
	protected boolean initialize(Object element) {
		fOperation = (Operation) contextElement;
		refactoringContribution = RefactoringCore.getRefactoringContribution(JAVAREFACTORINGID);
		setEmfToJavaMatching(Preferences.MATCHING_M2C_ALGO);
		
		Measurement.start();
		List<IMethod> candidates = matching.getMatchingIMethodsForEmfElement(fOperation);
		Measurement.stop();
		
		fIMethod = (IMethod) InformationsGui.checkCandidates(InformationsGui.INFORM_MODEL_TO_CODE, candidates);
		if (fIMethod == null) 
			return false;
			
		refactoringDescriptor = (RenameJavaElementDescriptor) refactoringContribution.createDescriptor();
		refactoringDescriptor.setJavaElement(fIMethod);
		refactoringDescriptor.setUpdateReferences(true);
		refactoringDescriptor.setNewName((String) fArguments.getEmfRefactoringArguments().getInPortByName("newName").getValue());
		
		RefactoringStatus refactoringStatus = new RefactoringStatus();
		refactoringStatus = refactoringDescriptor.validateDescriptor();
		if (refactoringStatus.isOK()) {
			try {
				refactoring = refactoringDescriptor.createRefactoring(refactoringStatus);
			} catch (CoreException e) {
				e.printStackTrace();
			}
			return true;
		}
		return false;
	}

	@Override
	public String getName() {
		return "IntroduceParameterObjectParticipant";
	}

}
