package pum.simuref.modeltocode.participant.java;

import java.util.List;
import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.refactoring.IJavaRefactorings;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.uml2.uml.Property;

import pum.simuref.configuration.managers.MappingManager;
import pum.simuref.matching.Measurement;
import pum.simuref.modeltocode.RefactoringArgumentsMapUtil;
import pum.simuref.modeltocode.participant.participants.EmfJavaRefactoringParticipant;
import pum.simuref.utils.InformationsGui;
import pum.simuref.utils.Preferences;

public class RenameAttributeByMapParticipant extends EmfJavaRefactoringParticipant {

	private static final String JAVAREFACTORINGID = IJavaRefactorings.RENAME_FIELD;
	private RenameJavaElementDescriptor refactoringDescriptor;
	
	private IField fIField;
	private Property fProperty;
	
	@Override
	protected boolean initialize(Object element) {
		fProperty = (Property) contextElement;
		refactoringContribution = RefactoringCore.getRefactoringContribution(JAVAREFACTORINGID);
		setEmfToJavaMatching(Preferences.MATCHING_M2C_ALGO);
		
		Measurement.start();
		List<IField> candidates = matching.getMatchingIFieldsForEmfElement(fProperty);
		Measurement.stop();
		
		fIField = (IField) InformationsGui.checkCandidates(InformationsGui.INFORM_CODE_TO_MODEL, candidates);
		if (fIField == null) 
			return false;
		
		// M�glichkeit den Namen herzuleiten.
		String project = MappingManager.getInstance().getJavaProjectNameForEmfElement((EObject) fArguments.getEmfRefactoringArguments().getInPortByName(SELECTEDEOBJECT).getValue());
		String description = fArguments.toString();
		String comment = "Comment: " + fArguments.toString();
		int flags = 0;
		String input = fIField.getHandleIdentifier().replace("="+project, "");
		Map <String, String> arguments = RefactoringArgumentsMapUtil.getDefaultMap(JAVAREFACTORINGID);
		arguments.put("input", input);
		arguments.put("name", (String) fArguments.getEmfRefactoringArguments().getInPortByName("newName").getValue());
		refactoringDescriptor = (RenameJavaElementDescriptor) refactoringContribution.createDescriptor(JAVAREFACTORINGID, project, description, comment, arguments, flags);

		RefactoringStatus refactoringStatus = new RefactoringStatus();
		refactoringStatus = refactoringDescriptor.validateDescriptor();
		if (refactoringStatus.isOK()) {
			try {
				refactoring = refactoringDescriptor.createRefactoring(refactoringStatus);
			} catch (CoreException e) {
				e.printStackTrace();
			}
			return true;
		}
		return false;
	}

	@Override
	public String getName() {
		return "JavaRenameAttribute";
	}

}
