/*******************************************************************************
 * Copyright (c) Philipps University of Marburg. All rights reserved. 
 * This program and the accompanying materials are made 
 * available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Philipps University of Marburg - initial API and implementation
 *******************************************************************************/
package pum.simuref.generator.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.refactor.refactoring.core.Refactoring;
import org.eclipse.emf.refactor.refactoring.managers.RefactoringManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

import pum.simuref.generator.core.JdtRefactoringInfo;
import pum.simuref.generator.core.SimuRefInfo;
import pum.simuref.generator.interfaces.INewSimuRefactoringWizard;
import pum.simuref.generator.managers.GenerationManager;
import pum.simuref.generator.managers.JdtRefactoringInfoManager;
import pum.simuref.matching.MatchingFactory;
import pum.simuref.matching.codetomodel.IJavaToEmfMatching;
import pum.simuref.matching.modeltocode.IEmfToJavaMatching;

/**
 * Wizard for editing data needed for model refactoring code generation.
 * @generated NOT
 * @author Thorsten Arendt
 */
public class NewRefactoringWizardJava extends Wizard implements INewWizard, INewSimuRefactoringWizard {
	
	/**
	 *  Wizard page for configurating model refactoring data (basics).
	 */
	private BasicDataWizardPage basicWizardPage;	
	
	/**
	 * Wizard page for configurating model refactoring parameters.
	 */
	private ParameterWizardPage parameterWizardPage;
	
	/**
	  * Wizard page for configurating model test parameters.
	  */
	 private TestWizardPage testWizardPage;
	 
	 private LinkedList<IProject> projects;

	private String projectName;

	private String menuLabel;

	private String id;

	private String namespaceUri;

	private String className;

	private String jar;

	private String importPackage;
	
	private final String WINDOW_TITLE = "New SimuRef Refactoring";
	
	// FOR SIMUREF
	private String mappingClass;
	private String simuId;
	private String simuName;
	private String emfRefactoringId;
	private String javaRefactoringId;

	private boolean participantCM;
	private boolean listenerCM;
	private boolean participantMC;
	private boolean listenerMC;
	
	private String matchingAlgoMC;
	private String matchingAlgoCM;
	 
	 /**
	  * Default constructor that initializes its wizard pages.
		* @param selectedEObject The selected EObject when starting the 
		* generation process of the model refactoring.
		*/
	public NewRefactoringWizardJava(){
	}
	
	public NewRefactoringWizardJava(String metamodel, String contextType) {
		this.namespaceUri = metamodel;
		this.className = contextType;
	}
	
	@Override
	public void addPages() {
		setWindowTitle(WINDOW_TITLE);
		this.basicWizardPage = new BasicDataWizardPage();
//		this.parameterWizardPage = new ParameterWizardPage();
//		this.testWizardPage = new TestWizardPage();
		if (namespaceUri != null && ! namespaceUri.isEmpty() 
				&& className != null && ! className.isEmpty()) {
			setMetamodelAndContext();
		}
		this.addPage(basicWizardPage);
//		this.addPage(parameterWizardPage);
//		this.addPage(testWizardPage);
	}
	
	public void setMetamodelAndContext() {
		basicWizardPage.setMetamodel(namespaceUri);
		basicWizardPage.setContextType(className);
	}

	/**
	 * @see org.eclipse.jface.wizard.Wizard#performFinish()
	 */
	@Override
	public boolean performFinish() {
		WorkspaceModifyOperation op = new WorkspaceModifyOperation() {
			@Override
			public void execute(IProgressMonitor monitor)
					throws InvocationTargetException {
				try {				
					createRefactoring(monitor);
				} catch (Exception e){
					e.printStackTrace();
				} finally {
					monitor.done();
				}
			}
		};
		try {
			getContainer().run(false, false, op);
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		return true;
	}
	
	@Override
	public boolean canFinish() {
		return basicWizardPage.isPageComplete();
	}
	
	/**
	 * Triggers the model refactoring generation activity. Collects data
	 * from its wizard pages and starts the refactoring generator.
	 * @param monitor Object monitoring the model refactoring 
	 * generation activity.
	 */
	protected void createRefactoring(IProgressMonitor monitor) {
//		String projectName = basicWizardPage.getProjectName();
//		String id = basicWizardPage.getRefactoringId();
//		String menuLabel = basicWizardPage.getMenuLabel();
//		String namespaceUri = basicWizardPage.getNsUri();
//		String namespacePrefix = basicWizardPage.getNsPrefix();
//		String metaModelName = basicWizardPage.getMetaModelName();
//		String className = basicWizardPage.getClassName();
//		String jar = basicWizardPage.getJar();
//		simuRefactoringConfig.setSelectedEObjectJar(jar);
//		simuRefactoringConfig.setSelectedEObjectClass(importPackage + "." + className);
//		simuRefactoringConfig.setMetaModelName(metaModelName);
//		simuRefactoringConfig.setParameters(parameterWizardPage.getParameters());
		
//		int numberOfTests = testWizardPage.getNumberOfTests();
//		String nsPrefix = getNsPrefix();
//		String metaModelName = getMetaModelName();
//		SimuRefInfo simuRefactoringConfig = 
//		   new SimuRefInfo(projectName, id, menuLabel, namespaceUri,
//		         nsPrefix, numberOfTests);
	
		int techniqueMC = SimuRefInfo.NO_TECH;
		int techniqueCM = SimuRefInfo.NO_TECH;
		
		if (participantCM) {
			if (javaRefactoringId.contains("rename"))
				techniqueCM = SimuRefInfo.PARTICIPANT_CM_RENAME;
			if (javaRefactoringId.contains("move"))
				techniqueCM = SimuRefInfo.PARTICIPANT_CM_MOVE;
		}
		if (listenerCM) techniqueCM = SimuRefInfo.LISTENER_CM;
		if (participantMC) techniqueMC = SimuRefInfo.PARTICIPANT_MC;
		if (listenerMC) techniqueMC = SimuRefInfo.LISTENER_MC;
		
		// Model -> COde
		if (techniqueMC != SimuRefInfo.NO_TECH) {
			SimuRefInfo simuRefactoringConfig = new SimuRefInfo(null, projectName, mappingClass, simuName, emfRefactoringId, javaRefactoringId, techniqueMC);
			simuRefactoringConfig.initializeDerivedElements();
			simuRefactoringConfig.setMatchingAlgorithmMC(matchingAlgoMC);
			
			System.out.println(simuRefactoringConfig);
			GenerationManager rg = new GenerationManager(simuRefactoringConfig); 
			rg.run(monitor);
		}
		
		// Code -> Model
		if (techniqueCM != SimuRefInfo.NO_TECH) {
			SimuRefInfo simuRefactoringConfig = new SimuRefInfo(null, projectName, mappingClass, simuName, emfRefactoringId, javaRefactoringId, techniqueCM);
			simuRefactoringConfig.initializeDerivedElements();
			simuRefactoringConfig.setMatchingAlgorithmCM(matchingAlgoCM);
			
			System.out.println(simuRefactoringConfig);
			GenerationManager rg = new GenerationManager(simuRefactoringConfig); 
			rg.run(monitor);
		}
	}

//	private String getMetaModelName() {
//		EPackage mm = 
//				EPackage.Registry.INSTANCE.getEPackage(namespaceUri);
//		return mm.getName();
//	}
//
//	private String getNsPrefix() {
//		EPackage mm = 
//				EPackage.Registry.INSTANCE.getEPackage(namespaceUri);
//		return mm.getNsPrefix();
//	}

	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		initProjects();
	}
	
	private void initProjects(){
		this.projects = new LinkedList<IProject>();
		IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
		for (IProject project : allProjects) {
			if (project.isOpen()) {
				IProjectNature nature = null;
				try {
					nature = project.getNature("org.eclipse.pde.PluginNature");
				} catch (CoreException e) {
					e.printStackTrace();
				}
				if (null != nature) 
					this.projects.add(project);
			}
		}
	}
	
	public LinkedList<IProject> getProjects() {
		return projects;
	}

	@Override
	public int getPageNumbers() {
		return 1;
	}

	@Override
	public void updateSecondPage() { }

	@Override
	public WizardPage getSecondPage() {
		return parameterWizardPage;
	}

	@Override
	public void setTargetProject(String projectName) {
		this.projectName = projectName;
	}

	@Override
	public void setName(String name) {
		this.menuLabel = name;
		// SIMU
		this.mappingClass = name;
		this.simuName = name;
	}

	@Override
	public void setId(String id) {
		this.id = id;
		// SIMU
		this.simuId = id;
	}

	@Override
	public void setMetamodel(String metamodel) {
		this.namespaceUri = metamodel;
	}

	@Override
	public void setContext(String context) {
		this.className = context;
	}

	@Override
	public void setJar(String jar) {
		this.jar = jar;
	}

	@Override
	public void setImportPackage(String importPackage) {
		this.importPackage = importPackage;
	}

	@Override
	public void setEmfRefactoringId(String emfRefactoringId) {
		// SIMU
		this.emfRefactoringId = emfRefactoringId;
	}

	@Override
	public void setListenerMC(boolean selection) {
		this.listenerMC = selection;
	}

	@Override
	public void setParticipantMC(boolean selection) {
		this.participantMC = selection;
	}

	@Override
	public void setListenerCM(boolean selection) {
		this.listenerCM = selection;
	}

	@Override
	public void setParticipantCM(boolean selection) {
		this.participantCM = selection;
	}

	@Override
	public void setJavaRefactoringId(String javaRefactoringId) {
		this.javaRefactoringId = javaRefactoringId;
	}

	@Override
	public List<Refactoring> getEmfRefactorings() {
		return RefactoringManager.getAllRefactorings();
	}

	@Override
	public List<JdtRefactoringInfo> getJdtRefactorings() {
		JdtRefactoringInfoManager.getInstance();
		return JdtRefactoringInfoManager.getAllJdtRefactorings();
	}

	@Override
	public Map<String, IJavaToEmfMatching> getJavaToEmfMatchings() {
		return MatchingFactory.getFactory().getJavaToEmfMatchings();
	}

	@Override
	public Map<String, IEmfToJavaMatching> getEmfToJavaMatchings() {
		return MatchingFactory.getFactory().getEmfToJavaMatchings();
	}

	@Override
	public void setEmfToJavaMatchingAlgorithmus(String matchingAlgoMC) {
		this.matchingAlgoMC = matchingAlgoMC;
	}

	@Override
	public void setJavaToEmfMatchingAlgorithmus(String matchingAlgoCM) {
		this.matchingAlgoCM = matchingAlgoCM;
	}
}
