package pum.simuref.generator.ui;

import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map.Entry;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

import pum.simuref.generator.core.JdtRefactoringInfo;
import pum.simuref.generator.interfaces.INewSimuRefactoringWizard;
import pum.simuref.matching.codetomodel.IJavaToEmfMatching;
import pum.simuref.matching.modeltocode.IEmfToJavaMatching;

import org.eclipse.swt.widgets.Button;
import org.eclipse.emf.refactor.refactoring.core.Refactoring;

public class BasicDataWizardPage extends WizardPage implements Listener {

	private static final String PAGE_NAME = "pum.simuref.generator.BasicDataWizardPage";
	private static final String PAGE_TITLE = "New simutaneous Refactoring: Basic Data";
	private static final String PAGE_DESCRIPTION = "Please specify basic mapping data. " +
												"Required fields are denoted by \"(*)\".";
	
	private Text nameTextField;
	private Combo projectCombo;
	private String jar = "";
	private String importPackage, metaModel, contextType;
	private Group grpMappingData;
	private GridLayout gl_grpMappingData;
	private GridData gd_grpMappingData;
	private Label lblRefactoringId;
	private Label lblInitialRefactoringId;
	private Group grpMappingDirections;
	private Composite container_1;
	private Group grpCodeModel;
	private Group grpModelCode;
	private Button btnParticipantCM;
	private Button btnListenerCM;
	private Button btnParticipantMC;
	private Button btnListenerMC;
	private Combo comboJdtRefactoring;
	private Combo comboEmfRefactorings;
	private Label lblMatchingAlgorithmus;
	private Combo comboMatchingAlgoCM;
	private Label lblMatchingAlgorithmus_1;
	private Combo comboMatchingAlgoMC;
	private Label lblApproach;
	private Label lblApproach_1;
	
	@Override
	public void createControl(Composite parent) {
		container_1 = new Composite(parent, SWT.NULL);
		final GridLayout gl_container_1 = new GridLayout();
		container_1.setLayout(gl_container_1);
		createTextFields(container_1);
		initRefactoringsAndProjectsAndMetamodels();
		initMatchingAlgorithmen();
//		System.out.println("vorher");
//		if (metaModel != null && ! metaModel.isEmpty() 
//				&& contextType != null && ! contextType.isEmpty()) {
//			System.out.println("drin");
//			setFixedMetamodel(metaModel);
//			setFixedContext(contextType);
//		}
//		System.out.println("nachher");
		setControl(container_1);
		this.setPageComplete(false);
	}	

	@Override
	public boolean canFlipToNextPage() {
		if (((INewSimuRefactoringWizard) getWizard()).getPageNumbers() > 1) {
			if (this.isPageComplete()) {
				((INewSimuRefactoringWizard) getWizard()).updateSecondPage();
				return true;
			}
		} 
		return false;
	}
	
	public WizardPage getNextPage() {
		if (((INewSimuRefactoringWizard) getWizard()).getPageNumbers() > 1) {
			return ((INewSimuRefactoringWizard) getWizard()).getSecondPage();
		} else {
			return null;
		}
	}
	
	@Override
	public void handleEvent(Event event) {
		if (event.widget == projectCombo) {
			((INewSimuRefactoringWizard) getWizard()).setTargetProject(projectCombo.getText());
		}
		if (event.widget == comboEmfRefactorings) {
			((INewSimuRefactoringWizard) getWizard()).setEmfRefactoringId(comboEmfRefactorings.getText());
		}
		if (event.widget == comboJdtRefactoring) {
			((INewSimuRefactoringWizard) getWizard()).setJavaRefactoringId(comboJdtRefactoring.getText());
		}
		if (event.widget == comboMatchingAlgoCM) {
			((INewSimuRefactoringWizard) getWizard()).setJavaToEmfMatchingAlgorithmus(this.comboMatchingAlgoCM.getText());
		}
		if (event.widget == comboMatchingAlgoMC) {
			((INewSimuRefactoringWizard) getWizard()).setEmfToJavaMatchingAlgorithmus(this.comboMatchingAlgoMC.getText());
		}
//		if (event.widget == metamodelCombo) {
//			String nsURI = metamodelCombo.getText();
//			if (nsURI != null && ! nsURI.isEmpty()) {
//				EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
//				if (ePackage != null) {
//					importPackage = ePackage.getClass().getPackage().getName();
//					if (importPackage.endsWith(".impl")) {
//						int length = importPackage.length();
//						importPackage = importPackage.substring(0, length-5);
//					}
//					if (importPackage.endsWith(".internal")) {
//						int length = importPackage.length();
//						importPackage = importPackage.substring(0, length-9);
//					}
//					System.out.println("importPackage: " + importPackage);
//					File jarFile;
//					try {
//						jarFile = new File
//								(ePackage.getClass().getProtectionDomain()
//								.getCodeSource().getLocation().toURI());
//						String jarName = jarFile.getName();
//						int index = jarName.indexOf("_");
//						if (index == -1) {
//							jar = jarName;
//						} else {
//							jar = jarName.substring(0, index);
//						}
//						System.out.println("Jar5: " + jar);
//					} catch (URISyntaxException e) {
//						e.printStackTrace();
//					} finally {	
//						contextCombo.removeAll();
//						
//						List<Object> namedElements = new ArrayList<Object>();
//						for (int i = 0; i < ePackage.eContents().size(); i++) {
//							EObject eObject = ePackage.eContents().get(i);
//							if (eObject instanceof ENamedElement) {
//								namedElements.add(eObject);								
//							}
//						}		
//						
//						Object[] eObjectNames = new Object[namedElements.size()];
//						for (int i = 0; i < eObjectNames.length; i++) {
//							eObjectNames[i] = ((ENamedElement) namedElements.get(i)).getName();
//						}
//						
//				        Arrays.sort(eObjectNames);
//						for(Object object : eObjectNames){
//							contextCombo.add((String)object);
//						}
//					}
//				}
//			} else {
//				jar = "";
//				contextCombo.removeAll();
//			}
//		}
			updatePageComplete();
			getWizard().getContainer().updateButtons();	
	}

	public BasicDataWizardPage() {
		super(PAGE_NAME);
		setTitle(PAGE_TITLE);
		setDescription(PAGE_DESCRIPTION);
	}
	
	private void createTextFields(Composite container) {
		Label label;
		GridData gridData;
		Group group;
		GridLayout layout;
		// - Project -
		group = new Group(container, SWT.NONE);
		group.setText("Project Data");
	    layout = new GridLayout();
	    layout.numColumns = 2;
	    group.setLayout(layout);
	    gridData = new GridData(GridData.FILL_HORIZONTAL);
	    group.setLayoutData(gridData);
		// col:1
		label = new Label(group, SWT.NONE);
		label.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
		label.setText("Target project (*):");
		// col:2
		projectCombo = new Combo(group, SWT.READ_ONLY);
		projectCombo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		//projectCombo.setText("Select Project");
		projectCombo.addListener(SWT.Selection, this);
		// - Refactoring Data -
		grpMappingData = new Group(container, SWT.NONE);
		grpMappingData.setText("Mapping Data");
		gl_grpMappingData = new GridLayout();
		gl_grpMappingData.numColumns = 2;
		grpMappingData.setLayout(gl_grpMappingData);
		gd_grpMappingData = new GridData(GridData.FILL_HORIZONTAL);
		grpMappingData.setLayoutData(gd_grpMappingData);
		// - Name -
		// col:1
		label = new Label(grpMappingData, SWT.NONE);
		label.setText("Name (*):");
		label.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
		// col:2
		nameTextField = new Text(grpMappingData, SWT.BORDER);
		nameTextField.addListener(SWT.Modify, this);
		nameTextField.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		// - Id -
		// col:1
		lblInitialRefactoringId = new Label(grpMappingData, SWT.NONE);
		lblInitialRefactoringId.setText("JDT refactoring ID (*):");
		lblInitialRefactoringId.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
		
		comboJdtRefactoring = new Combo(grpMappingData, SWT.READ_ONLY);
		comboJdtRefactoring.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboJdtRefactoring.addListener(SWT.Selection, this);
		
		lblRefactoringId = new Label(grpMappingData, SWT.NONE);
		lblRefactoringId.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblRefactoringId.setText("EMF Refactor refactoring ID (*):");
		
		comboEmfRefactorings = new Combo(grpMappingData, SWT.READ_ONLY);
		comboEmfRefactorings.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboEmfRefactorings.addListener(SWT.Selection, this);
		
		grpMappingDirections = new Group(container_1, SWT.NONE);
		grpMappingDirections.setToolTipText("One option must be selected.");
		GridData gd_grpMappingDirections = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_grpMappingDirections.widthHint = 564;
		grpMappingDirections.setLayoutData(gd_grpMappingDirections);
		grpMappingDirections.setText("Approach and Matching");
		grpMappingDirections.setLayout(new GridLayout(1, false));
		
		grpCodeModel = new Group(grpMappingDirections, SWT.NONE);
		grpCodeModel.setLayout(new GridLayout(3, false));
		GridData gd_grpCodeModel = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_grpCodeModel.widthHint = 683;
		grpCodeModel.setLayoutData(gd_grpCodeModel);
		grpCodeModel.setText("Code -> Model");
		
		lblApproach = new Label(grpCodeModel, SWT.NONE);
		lblApproach.setText("Approach:");
		
		btnListenerCM = new Button(grpCodeModel, SWT.RADIO);
		btnListenerCM.setText("Listener");
		btnListenerCM.addListener(SWT.Modify, this);
		btnListenerCM.addListener(SWT.Selection, this);
		
		btnParticipantCM = new Button(grpCodeModel, SWT.RADIO);
		btnParticipantCM.setToolTipText("Only available for rename and move refactorings.");
		btnParticipantCM.setText("Participant");
		btnParticipantCM.addListener(SWT.Modify, this);
		btnParticipantCM.addListener(SWT.Selection, this);
		
		lblMatchingAlgorithmus = new Label(grpCodeModel, SWT.NONE);
		lblMatchingAlgorithmus.setText("Matching algorithm:");
		
		comboMatchingAlgoCM = new Combo(grpCodeModel, SWT.READ_ONLY);
		comboMatchingAlgoCM.addListener(SWT.Selection, this);
		GridData gd_combo = new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1);
		gd_combo.widthHint = 441;
		comboMatchingAlgoCM.setLayoutData(gd_combo);
		
		grpModelCode = new Group(grpMappingDirections, SWT.NONE);
		grpModelCode.setLayout(new GridLayout(3, false));
		grpModelCode.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		grpModelCode.setText("Model -> Code");
		
		lblApproach_1 = new Label(grpModelCode, SWT.NONE);
		lblApproach_1.setText("Approach:");
		
		btnListenerMC = new Button(grpModelCode, SWT.RADIO);
		btnListenerMC.setText("Listener");
		btnListenerMC.addListener(SWT.Modify, this);
		btnListenerMC.addListener(SWT.Selection, this);
		
		btnParticipantMC = new Button(grpModelCode, SWT.RADIO);
		btnParticipantMC.setText("Participant");
		btnParticipantMC.addListener(SWT.Modify, this);
		btnParticipantMC.addListener(SWT.Selection, this);
		
		lblMatchingAlgorithmus_1 = new Label(grpModelCode, SWT.NONE);
		lblMatchingAlgorithmus_1.setText("Matching algorithm:");
		
		comboMatchingAlgoMC = new Combo(grpModelCode, SWT.READ_ONLY);
		comboMatchingAlgoMC.addListener(SWT.Selection, this);
		comboMatchingAlgoMC.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
	}
	
	private void initRefactoringsAndProjectsAndMetamodels(){
		for (Refactoring refactoring : ((INewSimuRefactoringWizard) getWizard()).getEmfRefactorings()) {
			comboEmfRefactorings.add(refactoring.getId());
		}
		for (JdtRefactoringInfo jdtRefactoringInfo : ((INewSimuRefactoringWizard) getWizard()).getJdtRefactorings()) {
			comboJdtRefactoring.add(jdtRefactoringInfo.getId());
		}
		for (IProject project : ((INewSimuRefactoringWizard) getWizard()).getProjects()) {
			projectCombo.add(project.getName());
		}
//		Object [] metamodelObjects = 
//				EPackage.Registry.INSTANCE.keySet().toArray(new Object[EPackage.Registry.INSTANCE.size()]);
//        Arrays.sort(metamodelObjects);
//		for(Object object : metamodelObjects){
//			metamodelCombo.add(object.toString());
//		}
	}
	
	private void initMatchingAlgorithmen(){
		for (Entry<String, IEmfToJavaMatching> entry : ((INewSimuRefactoringWizard) getWizard()).getEmfToJavaMatchings().entrySet()) {
			comboMatchingAlgoMC.add(entry.getKey());
		}
		for (Entry<String, IJavaToEmfMatching> entry : ((INewSimuRefactoringWizard) getWizard()).getJavaToEmfMatchings().entrySet()) {
			comboMatchingAlgoCM.add(entry.getKey());
		}
	}
	
//	private void setFixedMetamodel(String metaModel) {
//		for (String mm : metamodelCombo.getItems()) {
//			if (mm.equals(metaModel)) {
//				metamodelCombo.removeAll();
//				metamodelCombo.setItems(new String[] {metaModel});
//				metamodelCombo.select(0);
//				metamodelCombo.setEnabled(false);
//				EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(metaModel);
//				importPackage = ePackage.getClass().getPackage().getName();
//				if (importPackage.endsWith(".impl")) {
//					int length = importPackage.length();
//					importPackage = importPackage.substring(0, length-5);
//				}
//				if (importPackage.endsWith(".internal")) {
//					int length = importPackage.length();
//					importPackage = importPackage.substring(0, length-9);
//				}
//				System.out.println("importPackage: " + importPackage);
//				File jarFile;
//				try {
//					jarFile = new File
//							(ePackage.getClass().getProtectionDomain()
//							.getCodeSource().getLocation().toURI());
//					String jarName = jarFile.getName();
//					int index = jarName.indexOf("_");
//					if (index == -1) {
//						jar = jarName;
//					} else {
//						jar = jarName.substring(0, index);
//					}
//					System.out.println("Jar5: " + jar);
//				} catch (URISyntaxException e) {
//					e.printStackTrace();
//				}
//				break;
//			}
//		}
//	}
	
//	private void setFixedContext(String context) {
//		contextCombo.removeAll();
//		contextCombo.setItems(new String[] {context});
//		contextCombo.select(0);
//		contextCombo.setEnabled(false);
//	}

	/**
	 * Wird jedes mal ausgefhr wenn sich der Inhalt eines Textfeldes im Wizard
	 * verndert. berprft die inhalte der Textfelder und erzeugt
	 * entschprechende Meldungen im Wizardfenster.
	 */
	private void updatePageComplete() {
		if(!checkProject()){
			this.setMessage("Target project for the new refactoring is not specified.", ERROR);
			this.setPageComplete(false);
		}else
		if(nameTextField.getText().isEmpty()){
			this.setMessage("Simultaneousy Refactoring name is not specified.", ERROR);
			this.setPageComplete(false);
		}else
		if(comboJdtRefactoring.getText().isEmpty()){
			this.setMessage("JDT Refactoring ID is not specified.", ERROR);
			this.setPageComplete(false);
		}else
		if(comboEmfRefactorings.getText().isEmpty()){
			this.setMessage("EMF Refactoring ID is not specified.", ERROR);
			this.setPageComplete(false);
		}else
//		if(metamodelCombo.getText().isEmpty()){
//			this.setMessage("Refactoring meta model is not specified.", ERROR);
//			this.setPageComplete(false);
//		}else
//		if( contextCombo.getText().isEmpty()){
//			this.setMessage("Refactoring context is not specified.", ERROR);
//			this.setPageComplete(false);
//		}else
		if ((!btnParticipantCM.getSelection()) && (!btnParticipantMC.getSelection()) && (!btnListenerCM.getSelection()) && (!btnListenerMC.getSelection())) {
			this.setMessage("At least one direction must be selected.", ERROR);
			this.setPageComplete(false);
		}
		else 
		if (btnParticipantCM.getSelection() && ! ((comboJdtRefactoring.getText().contains("rename") || (comboJdtRefactoring.getText().contains("move"))))) {
			this.setMessage("Participant approach Code -> Model is only available for rename and move refactorings.", ERROR);
			this.setPageComplete(false);
		}
		else 
		if((btnParticipantCM.getSelection() || btnListenerCM.getSelection()) && comboMatchingAlgoCM.getText().isEmpty()) {
			this.setMessage("Matching Algorithm Code -> Model is not specified.", ERROR);
			this.setPageComplete(false);
		}else
		if((btnParticipantMC.getSelection() || btnListenerMC.getSelection()) && comboMatchingAlgoMC.getText().isEmpty()) {
			this.setMessage("Matching Algorithm Model -> Code is not specified.", ERROR);
			this.setPageComplete(false);
		}else{
			this.setMessage("");
			this.setPageComplete(true);
			saveTextFieldValues();
		}
	}
	
	private boolean checkProject(){
		if(!projectCombo.getText().isEmpty())
			return true;
		return false;
	}
	
	private void saveTextFieldValues(){
		((INewSimuRefactoringWizard) getWizard()).setName(this.nameTextField.getText());
//		((INewSimuRefactoringWizard) getWizard()).setMetamodel(this.metamodelCombo.getText());
//		((INewSimuRefactoringWizard) getWizard()).setContext(this.contextCombo.getText());
		((INewSimuRefactoringWizard) getWizard()).setJar(jar);
		((INewSimuRefactoringWizard) getWizard()).setImportPackage(importPackage);
		((INewSimuRefactoringWizard) getWizard()).setListenerMC(btnListenerMC.getSelection());
		((INewSimuRefactoringWizard) getWizard()).setParticipantMC(btnParticipantMC.getSelection());
		((INewSimuRefactoringWizard) getWizard()).setListenerCM(btnListenerCM.getSelection());
		((INewSimuRefactoringWizard) getWizard()).setParticipantCM(btnParticipantCM.getSelection());
	}

	public void setMetamodel(String metaModel) {
		this.metaModel = metaModel;
	}

	public void setContextType(String contextType) {
		this.contextType = contextType;
	}
}
	

