package pum.simuref.generator.managers;

import java.util.LinkedList;

import pum.simuref.generator.core.JdtRefactoringInfo;
import org.eclipse.jdt.core.refactoring.IJavaRefactorings;

public class JdtRefactoringInfoManager {
	
	private static LinkedList<JdtRefactoringInfo> jdtRefactoringInfos;
	private static JdtRefactoringInfoManager instance;
	
	public JdtRefactoringInfoManager() {
		initJdtRefactoringsList();
		System.out.println("JdtRefactoringInfoManager initialized!");
	}
	
	public static JdtRefactoringInfoManager getInstance() {
		if(instance == null) {
			instance = new JdtRefactoringInfoManager();
		}
		return instance;
	}
	
	public static LinkedList<JdtRefactoringInfo> getAllJdtRefactorings() {
		return jdtRefactoringInfos;
	}

	private void initJdtRefactoringsList() {
		jdtRefactoringInfos = new LinkedList<JdtRefactoringInfo>();
		JdtRefactoringInfo jdtRefactoringInfo = new JdtRefactoringInfo(IJavaRefactorings.RENAME_TYPE, "IType", "RenameJavaElementDescriptor");
		jdtRefactoringInfos.add(jdtRefactoringInfo);
		
		jdtRefactoringInfo = new JdtRefactoringInfo(IJavaRefactorings.RENAME_METHOD, "IMethod", "RenameJavaElementDescriptor");
		jdtRefactoringInfos.add(jdtRefactoringInfo);
		
		jdtRefactoringInfo = new JdtRefactoringInfo(IJavaRefactorings.RENAME_FIELD, "IField", "RenameJavaElementDescriptor");
		jdtRefactoringInfos.add(jdtRefactoringInfo);
		
		jdtRefactoringInfo = new JdtRefactoringInfo(IJavaRefactorings.ENCAPSULATE_FIELD, "IField", "EncapsulateFieldDescriptor");
		jdtRefactoringInfos.add(jdtRefactoringInfo);
		
		jdtRefactoringInfo = new JdtRefactoringInfo(IJavaRefactorings.MOVE_METHOD, "IMethod", "MoveMethodDescriptor");
		jdtRefactoringInfos.add(jdtRefactoringInfo);
			/**
			 * 	TODO: Weitere zur Verfgung stellen.
			 * 	
			 * CHANGE_METHOD_SIGNATURE : String
			CONVERT_ANONYMOUS : String
			CONVERT_LOCAL_VARIABLE : String
			CONVERT_MEMBER_TYPE : String
			COPY : String
			DELETE : String
			ENCAPSULATE_FIELD : String
			EXTRACT_CLASS : String
			EXTRACT_CONSTANT : String
			EXTRACT_INTERFACE : String
			EXTRACT_LOCAL_VARIABLE : String
			EXTRACT_METHOD : String
			EXTRACT_SUPERCLASS : String
			GENERALIZE_TYPE : String
			INFER_TYPE_ARGUMENTS : String
			INLINE_CONSTANT : String
			INLINE_LOCAL_VARIABLE : String
			INLINE_METHOD : String
			INTRODUCE_FACTORY : String
			INTRODUCE_INDIRECTION : String
			INTRODUCE_PARAMETER : String
			INTRODUCE_PARAMETER_OBJECT : String
			MOVE : String
			MOVE_METHOD : String
			MOVE_STATIC_MEMBERS : String
			PULL_UP : String
			PUSH_DOWN : String
			RENAME_COMPILATION_UNIT : String
			RENAME_ENUM_CONSTANT : String
			RENAME_FIELD : String
			RENAME_JAVA_PROJECT : String
			RENAME_LOCAL_VARIABLE : String
			RENAME_METHOD : String
			RENAME_PACKAGE : String
			RENAME_RESOURCE : String
			RENAME_SOURCE_FOLDER : String
			RENAME_TYPE : String
			RENAME_TYPE_PARAMETER : String
			USE_SUPER_TYPE : String
			 */
	}
	
	public static JdtRefactoringInfo getJdtRefactoringById(String jdtRefactoringId) {
		for (JdtRefactoringInfo jdti : jdtRefactoringInfos) {
			if (jdti.getId().equals(jdtRefactoringId)) {
				return jdti;
			}
		}
		return null;
	}

}
