package pum.simuref.generator.managers;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

import pum.simuref.generator.core.SimuRefInfo;

public class DependenciesManager {

	protected final static String MANIFEST_FILE = "/META-INF/MANIFEST.MF";	
	protected final static String REQUIREBUNDLE = "Require-Bundle";
	protected final static String ECORE = "org.eclipse.emf.ecore";
	protected final static String EXPRESSIONS = "org.eclipse.core.expressions";
	protected final static String ECORECHANGE = "org.eclipse.emf.ecore.change";
	protected final static String LTKCORE = "org.eclipse.ltk.core.refactoring";
	protected final static String LTKUI = "org.eclipse.ltk.ui.refactoring";	
	protected final static String REFACTORCOMMON = "org.eclipse.emf.refactor.refactoring";
	protected final static String REFACTORRUNTIME = "org.eclipse.emf.refactor.refactoring.runtime";
	protected final static String JUNIT = "org.junit";
	
	protected final static String JDT_MANIPULATION = "org.eclipse.jdt.core.manipulation";
	protected final static String JDT_CORE	= "org.eclipse.jdt.core";
	protected final static String PUM_CORE = "pum.simuref";
	protected final static String PUM_CONFIG = "pum.simuref.configuration";
	protected final static String PUM_M2C = "pum.simuref.modeltocode";
	protected final static String PUM_M2C_PARTI = "pum.simuref.modeltocode.participant";
	protected final static String PUM_M2C_LISTENER = "pum.simuref.modeltocode.listener";
	protected final static String PUM_C2M = "pum.simuref.codetomodel";
	protected final static String PUM_C2M_PARTI = "pum.simuref.codetomodel.participant";
	protected final static String PUM_C2M_LISTENER = "pum.simuref.codetomodel.listener";
	protected final static String LTK_CORE  = "org.eclipse.ltk.core.refactoring";
	protected final static String EMF_ECORE = "org.eclipse.emf.ecore";
	
	protected final static String UML = "org.eclipse.uml2.uml";
	
	/**
	 * Updates the plugin-dependencies (Require-Bundle) of the
	 * target project. Adds dependencies to org.eclipse.emf.ecore,
	 * org.eclipse.emf.ecore.change, org.eclipse.ltk.core.refactoring,
	 * org.eclipse.ltk.ui.refactoring, org.eclipse.emf.refactor.common,
	 * and org.eclipse.emf.refactor.runtime
	 */
	public static void updateDependencies(SimuRefInfo info) {		
		IProject project = ResourcesPlugin.getWorkspace().getRoot()
								.getProject(info.getProjectName());
		try {
			String fileName = project.getLocation().append(MANIFEST_FILE)
								.toOSString();
			FileInputStream is = new FileInputStream(fileName);
			Manifest mf = new Manifest(is);
			Attributes att = mf.getMainAttributes();
			String value = att.getValue(REQUIREBUNDLE);
			if (! value.contains(REFACTORCOMMON)) {
				value = value + "," + REFACTORCOMMON;
			}
			if (! value.contains(JDT_CORE)) {
				value = value + "," + JDT_CORE;
			}
			if (! value.contains(JDT_MANIPULATION)) {
				value = value + "," + JDT_MANIPULATION;
			}
			if (! value.contains(LTK_CORE)) {
				value = value + "," + LTK_CORE;
			}
			if (! value.contains(EMF_ECORE)) {
				value = value + "," + EMF_ECORE;
			}
			if (! value.contains(PUM_CORE)) {
				value = value + "," + PUM_CORE;
			}
			if (! value.contains(PUM_CONFIG)) {
				value = value + "," + PUM_CONFIG;
			}
			if (! value.contains(PUM_M2C)) {
				value = value + "," + PUM_M2C;
			}
			if (! value.contains(PUM_M2C_PARTI)) {
				value = value + "," + PUM_M2C_PARTI;
			}
			if (! value.contains(PUM_M2C_LISTENER)) {
				value = value + "," + PUM_M2C_LISTENER;
			}
			if (! value.contains(PUM_C2M)) {
				value = value + "," + PUM_C2M;
			}
			if (! value.contains(PUM_C2M_PARTI)) {
				value = value + "," + PUM_C2M_PARTI;
			}
			if (! value.contains(PUM_C2M_LISTENER)) {
				value = value + "," + PUM_C2M_LISTENER;
			}
			if (! value.contains(UML)) {
				value = value + "," + UML;
			}
//			if (! value.contains(JUNIT)) 
//				value = value + "," +  JUNIT + ";bundle-version=\"4.8.1\"";
//			if (! value.contains(info.getJar()))
//				value = value + "," +  info.getJar();
			att.putValue(REQUIREBUNDLE, value);
			FileOutputStream out = new FileOutputStream(fileName);  
			mf.write(out); 
		} catch (MalformedURLException e) {
			e.printStackTrace();
		}  catch (IOException e) {
			e.printStackTrace();
		}
	}
}
