package pum.simuref.generator.interfaces;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.refactor.refactoring.core.Refactoring;
import org.eclipse.jface.wizard.WizardPage;

import pum.simuref.generator.core.JdtRefactoringInfo;
import pum.simuref.matching.codetomodel.IJavaToEmfMatching;
import pum.simuref.matching.modeltocode.IEmfToJavaMatching;

public interface INewSimuRefactoringWizard {

	public LinkedList<IProject> getProjects();

	public int getPageNumbers();

	public void updateSecondPage();

	public WizardPage getSecondPage();

	public void setTargetProject(String text);

	public void setName(String text);

	public void setId(String text);

	public void setMetamodel(String text);

	public void setContext(String text);

	public void setJar(String jar);

	public void setImportPackage(String importPackage);

	public void setEmfRefactoringId(String emfRefactoringId);
	
	public void setJavaRefactoringId(String javaRefactoringId);

	public void setListenerMC(boolean selection);

	public void setParticipantMC(boolean selection);

	public void setListenerCM(boolean selection);

	public void setParticipantCM(boolean selection);

	public List<Refactoring> getEmfRefactorings();

	public List<JdtRefactoringInfo> getJdtRefactorings();
	
	public Map<String, IJavaToEmfMatching> getJavaToEmfMatchings();
	
	public Map<String, IEmfToJavaMatching> getEmfToJavaMatchings();

	public void setEmfToJavaMatchingAlgorithmus(String text);

	public void setJavaToEmfMatchingAlgorithmus(String text);
}