package pum.simuref.generator.core;

import org.eclipse.emf.refactor.refactoring.core.Refactoring;
import org.eclipse.emf.refactor.refactoring.interfaces.IDataManagement;
import org.eclipse.emf.refactor.refactoring.managers.RefactoringManager;
import org.eclipse.jdt.core.refactoring.IJavaRefactorings;

import pum.simuref.generator.managers.JdtRefactoringInfoManager;

public class SimuRefInfo {
	
	private String projectName;
	private String mappingClass; 
	private String pluginId;
	private String name;
	private String javaRefactoringId;
	private String emfRefactoringId;
	private int technique;
	private String packageName;
	private String emfType;
	private String emfImport;
	private String emfPackage;
	private String jdtType;
	private String jdtImport;
	private String matchingMethodName;
	private String jdtRefactoringDescriptorName;
	private String matchingMC;
	private String matchingCM;
	
	public static final int NO_TECH = -1;
	public static final int PARTICIPANT_MC = 0;
	public static final int PARTICIPANT_CM_RENAME = 1;
	public static final int PARTICIPANT_CM_MOVE = 2;
	public static final int LISTENER_MC = 3;
	public static final int LISTENER_CM = 4;
	
	private static final String STRING_PARTICIPANT_MC = "modetomodel.participant";
	private static final String STRING_PARTICIPANT_CM_RENAME = "codetomodel.participant.rename";
	private static final String STRING_PARTICIPANT_CM_MOVE = "codetomodel.participant.move";
	private static final String STRING_LISTENER_MC = "modeltocode.listener";
	private static final String STRING_LISTENER_CM = "codetomodel.listener";
	
	private static final String C_PARTICIPANT_MC = "MCParticipant";
	private static final String C_PARTICIPANT_CM_RENAME = "CMRenameParticipant";
	private static final String C_PARTICIPANT_CM_MOVE = "CMMoveParticipant";
	private static final String C_LISTENER_MC = "MCListener";
	private static final String C_LISTENER_CM = "CMListener";
	private static final String SELECTED_EOBJECT = "selectedEObject";
	
	JdtRefactoringInfo jdtRefactoringInfo = null;
	Refactoring emfRefactoring = null;
	
	public SimuRefInfo(String pluginId, String projectName, String mappingClass,
			String name, String emfRefactoringId, String javaRefactoringId, int technique) {
		String human_technique = "NO_TECH";
		String class_name_technique = "ERROR";
		switch (technique) {
		case PARTICIPANT_CM_RENAME:		
				human_technique  = STRING_PARTICIPANT_CM_RENAME;
				class_name_technique  = C_PARTICIPANT_CM_RENAME;
			break;
		case PARTICIPANT_CM_MOVE:		
			human_technique  = STRING_PARTICIPANT_CM_MOVE;
			class_name_technique  = C_PARTICIPANT_CM_MOVE;
		break;
		case PARTICIPANT_MC:		
			human_technique  = STRING_PARTICIPANT_MC;
			class_name_technique  = C_PARTICIPANT_MC;
		break;
		case LISTENER_CM:		
			human_technique  = STRING_LISTENER_CM;
			class_name_technique  = C_LISTENER_CM;
		break;
		case LISTENER_MC:		
			human_technique  = STRING_LISTENER_MC;
			class_name_technique  = C_LISTENER_MC;
		break;
		default:
			break;
		}
		this.projectName = projectName;
		if (pluginId != null) {
			this.pluginId = pluginId;
		}
		else {
			this.pluginId = projectName.toLowerCase().replaceAll(" ", "_") 
					+ "." + human_technique + "." + name.toLowerCase().replaceAll(" ", "_");
		}
		this.mappingClass = this.pluginId + "." + "SimuRef"+ class_name_technique;
		this.name = name;
		this.emfRefactoringId = emfRefactoringId;
		this.javaRefactoringId = javaRefactoringId;
		this.technique = technique;
		this.packageName = this.pluginId;
	}

	public void initializeDerivedElements() {
		// JDT
		JdtRefactoringInfoManager.getInstance();
		this.jdtRefactoringInfo = JdtRefactoringInfoManager.getJdtRefactoringById(javaRefactoringId);
		if (jdtRefactoringInfo != null) {
			this.jdtType = jdtRefactoringInfo.getContextElementType();
			this.jdtRefactoringDescriptorName = jdtRefactoringInfo.getRefactoringDescriptorType();
			if (jdtType == "IType") {
				switch (technique) {
				case LISTENER_CM:
					this.matchingMethodName = "getMatchingEmfElementsForITypeByIdentifier";
					break;
				case PARTICIPANT_CM_MOVE:
					this.matchingMethodName = "getMatchingEmfElementsForIType";
					break;
				case PARTICIPANT_CM_RENAME:
					this.matchingMethodName = "getMatchingEmfElementsForIType";
					break;
				case LISTENER_MC:
					this.matchingMethodName = "getMatchingITypesForEmfElement";
					break;
				case PARTICIPANT_MC:
					this.matchingMethodName = "getMatchingITypesForEmfElement";
					break;
				default:
					break;
				}
			}
			else if (jdtType == "IField") {
				switch (technique) {
				case LISTENER_CM:
					this.matchingMethodName = "getMatchingEmfElementsForIFieldByIdentifier";
					break;
				case PARTICIPANT_CM_RENAME:
					this.matchingMethodName = "getMatchingEmfElementsForIField";
					break;
				case PARTICIPANT_CM_MOVE:
					this.matchingMethodName = "getMatchingEmfElementsForIField";
					break;
				case LISTENER_MC:
					this.matchingMethodName = "getMatchingIFieldsForEmfElement";
					break;
				case PARTICIPANT_MC:
					this.matchingMethodName = "getMatchingIFieldsForEmfElement";
					break;
				default:
					break;
				}
				
			}
			else if (jdtType == "IMethod") {
				switch (technique) {
				case LISTENER_CM:
					this.matchingMethodName = "getMatchingEmfElementsForIMethodByIdentifier";
					break;
				case PARTICIPANT_CM_RENAME:
					this.matchingMethodName = "getMatchingEmfElementsForIMethod";
					break;
				case PARTICIPANT_CM_MOVE:
					this.matchingMethodName = "getMatchingEmfElementsForIMethod";
					break;
				case LISTENER_MC:
					this.matchingMethodName = "getMatchingIMethodsForEmfElement";
					break;
				case PARTICIPANT_MC:
					this.matchingMethodName = "getMatchingIMethodsForEmfElement";
					break;
				default:
					break;
				}
			}
		}
		
		RefactoringManager.getInstance();
		emfRefactoring = RefactoringManager.getById(emfRefactoringId);
		IDataManagement idatamanagement = emfRefactoring.getController().getDataManagementObject();
		this.emfImport = idatamanagement.getInPortByName(SELECTED_EOBJECT).getType().getName();
		this.emfType = emfImport.substring(emfImport.lastIndexOf('.')+1,emfImport.length());
	}

	public String getProjectName() {
		return projectName;
	}

	public String getPackageName() {
		return packageName;
	}
	
	public String getMappingClass() {
		return mappingClass;
	}

	public String getPluginId() {
		return pluginId;
	}

	public String getName() {
		return name;
	}

	public String getEmfRefactoringId() {
		return emfRefactoringId;
	}
	
	public String getJavaRefactoringId() {
		return javaRefactoringId;
	}

	public int getTechnique() {
		return technique;
	}
	
	public String getEmfType() {
		return emfType;
	}
	
	public String getJdtType() {
		return jdtType;
	}
	
	public String getMatchingMethod() {
		return matchingMethodName;
	}
	
	public String getJdtRefactoringDescriptor() {
		return jdtRefactoringDescriptorName;
	}
	
	public String getEmfPackage() {
		return emfPackage;
	}

	public void setEmfPackage(String emfPackage) {
		this.emfPackage = emfPackage;
	}
	
	public String getEmfImport() {
		return emfImport;
	}

	public void setEmfImport(String emfImport) {
		this.emfImport = emfImport;
	}

	public String getJdtImport() {
		return jdtImport;
	}

	public void setJdtImport(String jdtImport) {
		
	}

	public void setJdtImportWithId(String jdtImport) {
		this.jdtImport = jdtImport;
		if (this.technique == PARTICIPANT_CM_RENAME) {
			if (jdtImport.contains("IType")) {
				javaRefactoringId = IJavaRefactorings.RENAME_FIELD;
			}
			else if (jdtImport.contains("IMethod")) {
				javaRefactoringId = IJavaRefactorings.RENAME_METHOD;
			}
			else if (jdtImport.contains("IField")) {
				javaRefactoringId = IJavaRefactorings.RENAME_FIELD;
			}
		}
		if (this.technique == PARTICIPANT_CM_MOVE) {
			javaRefactoringId = IJavaRefactorings.MOVE;
		}
	}

	public void setMatchingAlgorithmCM(String matchingCM) {
		this.matchingCM = matchingCM;
		
	}

	public String getMatchingAlgorithmCM() {
		return matchingCM;
	}
	
	public void setMatchingAlgorithmMC(String matchingMC) {
		this.matchingMC = matchingMC;
	}
	
	public String getMatchingAlgorithmMC() {
		return matchingMC;
	}
	
}
